/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.catalog;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class Logger {
    private static final String PLUGINID = "org.eclipse.vtp.editor";
    private static ILog logger = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.vtp.editor"));
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    private static final int DEBUG_START = 200;
    public static final int OK_DEBUG = 200;
    public static final int INFO_DEBUG = 201;
    public static final int WARNING_DEBUG = 202;
    public static final int ERROR_DEBUG = 204;

    private Logger() {
    }

    private static void iLog(int level, String message, Throwable exception) {
        if (!(level != 200 && level != 201 && level != 202 && level != 204 || Logger.isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 201: {
                severity = 1;
                break;
            }
            case 2: 
            case 202: {
                severity = 2;
                break;
            }
            case 4: 
            case 204: {
                severity = 4;
            }
        }
        message = message != null ? message : "null";
        Status statusObj = new Status(severity, PLUGINID, severity, message, exception);
        logger.log((IStatus)statusObj);
    }

    public static boolean isDebugging() {
        return Platform.inDebugMode();
    }

    public static void log(int level, String message) {
        Logger.iLog(level, message, null);
    }

    public static void log(int level, String message, Throwable exception) {
        Logger.iLog(level, message, exception);
    }

    public static void logException(String message, Throwable exception) {
        Logger.iLog(4, message, exception);
    }

    public static void logException(Throwable exception) {
        Logger.iLog(4, exception.getMessage(), exception);
    }
}

