/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.catalog.nls;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.vtp.catalog.Logger;

public final class CatalogResourceHandler {
    public static final String DOC_ROOT = "org.eclipse.vtp.doc";
    private static ResourceBundle fgResourceBundle;
    public static final String RESOURCE_BUNDLE = "org.eclipse.vtp.catalog.nls.CatalogResources";

    private CatalogResourceHandler() {
    }

    public static ResourceBundle getResourceBundle() {
        try {
            return ResourceBundle.getBundle(RESOURCE_BUNDLE);
        }
        catch (MissingResourceException e) {
            Logger.logException(e);
            return null;
        }
    }

    public static String getString(String key) {
        if (fgResourceBundle == null) {
            fgResourceBundle = CatalogResourceHandler.getResourceBundle();
        }
        if (fgResourceBundle != null) {
            try {
                return fgResourceBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                return "!" + key + "!";
            }
        }
        return "!" + key + "!";
    }

    public static String getString(String key, Object[] args) {
        try {
            return MessageFormat.format(CatalogResourceHandler.getString(key), args);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return CatalogResourceHandler.getString(key);
        }
    }
}

