/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.catalog.ui;

import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;

public class CatalogEntrySelectionDialog
extends Dialog {
    protected String title;
    protected String previousValue;
    protected String selectedCatalogEntry;
    protected Table catalogTable;

    protected CatalogEntrySelectionDialog(Shell parentShell, String title, String previousValue) {
        super(parentShell);
        this.setShellStyle(2160);
        this.title = title;
        this.previousValue = previousValue;
        this.selectedCatalogEntry = previousValue;
    }

    protected Vector getKeys() {
        TreeSet<String> ss = new TreeSet<String>();
        this.getShell().setText(this.title);
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        if (xmlCatalog != null) {
            INextCatalog[] nextCatalogs = xmlCatalog.getNextCatalogs();
            if (nextCatalogs == null) {
                return new Vector();
            }
            int i = 0;
            while (i < nextCatalogs.length) {
                INextCatalog catalog = nextCatalogs[i];
                ICatalog referencedCatalog = catalog.getReferencedCatalog();
                if (referencedCatalog != null) {
                    ICatalog foundCatalog = null;
                    if ("system_catalog".equals(referencedCatalog.getId())) {
                        foundCatalog = referencedCatalog;
                    } else if ("user_catalog".equals(referencedCatalog.getId())) {
                        foundCatalog = referencedCatalog;
                    }
                    ICatalogEntry[] entries = foundCatalog.getCatalogEntries();
                    if (entries != null) {
                        int j = 0;
                        while (j < entries.length) {
                            String key;
                            if (entries[j] != null && entries[j].getEntryType() == 2 && !ss.contains(key = entries[j].getKey())) {
                                ss.add(key);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return new Vector(ss);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.catalogTable = new Table(composite, 2560);
        this.catalogTable.setLinesVisible(true);
        TableColumn tc = new TableColumn(this.catalogTable, 0);
        tc.setWidth(300);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        this.catalogTable.setLayoutData((Object)gd);
        Vector keys = this.getKeys();
        int i = 0;
        while (i < keys.size()) {
            TableItem ti = new TableItem(this.catalogTable, 0);
            ti.setText(0, (String)keys.get(i));
            if (this.previousValue.equals(keys.get(i))) {
                this.catalogTable.setSelection(i);
            }
            ++i;
        }
        this.catalogTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int i = CatalogEntrySelectionDialog.this.catalogTable.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                CatalogEntrySelectionDialog.this.selectedCatalogEntry = CatalogEntrySelectionDialog.this.catalogTable.getItem(i).getText();
                CatalogEntrySelectionDialog.this.okPressed();
            }
        });
        this.catalogTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = CatalogEntrySelectionDialog.this.catalogTable.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                CatalogEntrySelectionDialog.this.selectedCatalogEntry = CatalogEntrySelectionDialog.this.catalogTable.getItem(i).getText();
            }
        });
        return composite;
    }

    public String getSelectedCatalogEntry() {
        return this.selectedCatalogEntry;
    }
}

