/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.dialer.skype;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vtp.dialer.skype.ISkDialerListener;
import org.eclipse.vtp.dialer.skype.PhoneException;
import org.eclipse.vtp.dialer.skype.SkypePlugin;

public class SkDialer {
    private static final String NATIVE_LIB_ERR = "Native library did not load";
    private ISkDialerListener listener = null;
    private String connectResult = "";
    private String initFailReason = null;
    private static boolean alreadyFinalized = false;
    private static SkDialer _instance = new SkDialer();
    private static final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private static final boolean DEBUGGING = SkypePlugin.getDefault().isDebugging();
    private static boolean keepAliveRunning;
    private final Pattern dllMessage = Pattern.compile("DLL Message (\\d+):");
    private String synchObj = "";
    private boolean pongAfterPing = true;
    private boolean enableKeepAlive = true;
    Runnable pinger = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String string = SkDialer.this.synchObj;
            synchronized (string) {
                block11: {
                    while (SkDialer.this.enableKeepAlive) {
                        if (SkDialer.this.pongAfterPing) {
                            SkDialer.this.pongAfterPing = false;
                            if (!SkDialer.this.sendNative("PING") && DEBUGGING) {
                                System.out.println("sendNative returns false");
                            }
                            try {
                                SkDialer.this.synchObj.wait(10000L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                        }
                        break block11;
                    }
                    return;
                }
                if (DEBUGGING) {
                    System.out.println("No PONG received after PING");
                    System.out.flush();
                }
                try {
                    SkDialer.this.receiveMessageFromSkype("SKYPE DEAD");
                }
                catch (PhoneException phoneException) {}
                return;
            }
        }
    };

    static {
        if (DEBUGGING) {
            System.out.println("loading library");
        }
        System.loadLibrary("SkDialer");
        keepAliveRunning = false;
    }

    public static SkDialer getDialer() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkDialer.getDialer() called");
            System.out.flush();
        }
        return _instance;
    }

    private SkDialer() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkDialer create");
            System.out.flush();
        }
    }

    void setListener(ISkDialerListener listenerObject) {
        this.listener = listenerObject;
    }

    void initializeSkDialer(ISkDialerListener listenerObject) throws PhoneException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkDialer.initializeSkDialer() called");
            System.out.flush();
        }
        try {
            this.initFailReason = null;
            if (!this.initializeNative()) {
                if (this.initFailReason == null) {
                    throw new PhoneException("Native library did not initialize, reason unknown");
                }
                throw new PhoneException(this.initFailReason);
            }
            this.setListener(listenerObject);
            alreadyFinalized = false;
            this.connectResult = "";
        }
        catch (UnsatisfiedLinkError ule) {
            throw new PhoneException(NATIVE_LIB_ERR, ule);
        }
    }

    void connectSkDialer() throws PhoneException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkDialer.connectSkDialer() called");
            System.out.flush();
        }
        try {
            switch (this.connectNative()) {
                case -2: {
                    throw new PhoneException("Connection failed\nSuggest restart Eclipse and try again.");
                }
                case -1: {
                    throw new PhoneException("Connection failed\nSuggest restart Eclipse and try again.");
                }
                case 1: {
                    this.connectResult = "ATTACH CONNECTED";
                }
                case 0: {
                    while ("".equals(this.connectResult)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!"ATTACH REFUSED".equals(this.connectResult)) break;
                    throw new PhoneException("Connection refused by user");
                }
            }
            if (!keepAliveRunning) {
                new Thread(this.pinger, "pinger").start();
                keepAliveRunning = true;
            }
        }
        catch (UnsatisfiedLinkError ule) {
            throw new PhoneException(NATIVE_LIB_ERR, ule);
        }
    }

    void destroySkDialer() throws PhoneException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkDialer.destroySkDialer() called");
            System.out.flush();
        }
        if (alreadyFinalized) {
            return;
        }
        try {
            this.enableKeepAlive = false;
            keepAliveRunning = false;
            alreadyFinalized = true;
            this.destroyNative();
        }
        catch (UnsatisfiedLinkError ule) {
            throw new PhoneException(NATIVE_LIB_ERR, ule);
        }
    }

    void sendMessage(String message) throws PhoneException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkDialer.sendMessage() called");
            System.out.flush();
        }
        try {
            if (!this.sendNative(message)) {
                throw new PhoneException("Message sending failed");
            }
            if (message.startsWith("#tellme") && !this.sendNative("minimize")) {
                throw new PhoneException("Message sending failed");
            }
        }
        catch (UnsatisfiedLinkError ule) {
            throw new PhoneException(NATIVE_LIB_ERR, ule);
        }
    }

    protected native boolean initializeNative() throws UnsatisfiedLinkError;

    protected native int connectNative() throws UnsatisfiedLinkError;

    protected native void destroyNative() throws UnsatisfiedLinkError;

    protected synchronized native boolean sendNative(String var1) throws UnsatisfiedLinkError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void receiveMessageFromSkype(String message) throws PhoneException {
        String string = this.synchObj;
        synchronized (string) {
            if (DEBUGGING) {
                System.out.println(String.valueOf(time.format(new Date())) + ": SkDialer.receiveMessageFromSkype() message: " + message);
                System.out.flush();
            }
            if ("PONG".equals(message) && !this.pongAfterPing) {
                this.pongAfterPing = true;
                return;
            }
            Matcher matcher = this.dllMessage.matcher(message);
            if (matcher.lookingAt()) {
                String dllMsg;
                Integer.parseInt(matcher.group(1));
                this.initFailReason = dllMsg = message.substring(matcher.end()).trim();
                return;
            }
            if (this.listener != null) {
                this.listener.receiveMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void receiveConnectMessageFromSkype(String message) {
        String string;
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": ConnectMessage: " + message);
            System.out.flush();
        }
        if ("ATTACH CONNECTED".equals(message)) {
            string = this.connectResult;
            synchronized (string) {
                this.connectResult = message;
            }
        }
        if ("ATTACH REFUSED".equals(message)) {
            string = this.connectResult;
            synchronized (string) {
                this.connectResult = message;
            }
        }
    }
}

