/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.dialer.skype;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.vtp.dialer.skype.PhoneException;
import org.eclipse.vtp.dialer.skype.SkDialer;
import org.eclipse.vtp.dialer.skype.SkypeCall;
import org.eclipse.vtp.dialer.skype.SkypePlugin;
import org.eclipse.vtp.internal.dialer.IVoipCall;
import org.eclipse.vtp.internal.dialer.IVoipConnection;
import org.eclipse.vtp.internal.dialer.IVoipDialerListener;
import org.eclipse.vtp.internal.dialer.VoipDialerException;

public class SkypeConnection
implements IVoipConnection {
    private final IVoipDialerListener userListener;
    private final SkDialer skDialer;
    private int connectionStatus;
    private IVoipCall currentCall = null;
    private static final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private static final boolean DEBUGGING = SkypePlugin.getDefault().isDebugging();

    SkypeConnection(IVoipDialerListener listener, SkDialer dialer) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkypeConnection create");
            System.out.flush();
        }
        this.userListener = listener;
        this.skDialer = dialer;
        this.connectionStatus = -1;
    }

    void connect() throws VoipDialerException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkypeConnection.connect() called");
            System.out.flush();
        }
        try {
            this.skDialer.connectSkDialer();
        }
        catch (PhoneException pe) {
            this.connectionStatus = 4;
            throw new VoipDialerException(this.userListener, "Unable to init SkDialer", (Throwable)pe);
        }
        this.connectionStatus = 1;
    }

    public IVoipCall dial(String number) throws VoipDialerException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkypeConnection.dial() called");
            System.out.flush();
        }
        SkypeCall call = null;
        this.connectionStatus = 2;
        try {
            call = new SkypeCall(this.userListener, this.skDialer, this);
            call.dialNumber(number);
        }
        catch (VoipDialerException ve) {
            this.connectionStatus = 4;
            throw ve;
        }
        this.connectionStatus = 1;
        this.currentCall = call;
        return call;
    }

    public int status() {
        return this.connectionStatus;
    }

    public void disconnect() throws VoipDialerException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": SkypeConnection.disconnect() called");
            System.out.flush();
        }
        if (this.currentCall != null && this.currentCall.status() == 2) {
            this.currentCall.hangUp();
        }
        try {
            this.skDialer.destroySkDialer();
        }
        catch (PhoneException exc) {
            throw new VoipDialerException(this.userListener, "Library linking error", (Throwable)exc);
        }
    }
}

