/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.wst.sse.ui.internal.actions.ActionContributor;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class ActionContributorXML
extends ActionContributor {
    private static final String[] EDITOR_IDS = new String[]{"", ""};
    protected RetargetTextEditorAction fCleanupDocument = null;
    protected RetargetTextEditorAction fComment = null;
    protected RetargetTextEditorAction fContentAssist = null;
    protected RetargetTextEditorAction fFindOccurrences = null;
    protected RetargetTextEditorAction fFormatActiveElements = null;
    protected RetargetTextEditorAction fFormatDocument = null;
    protected MenuManager fFormatMenu = null;
    protected RetargetTextEditorAction fOpenFileAction = null;
    protected RetargetTextEditorAction fQuickFix = null;
    protected RetargetTextEditorAction fShowTooltipAction = null;
    protected RetargetTextEditorAction fUncomment = null;
    protected RetargetTextEditorAction fTest = null;

    public ActionContributorXML() {
        ResourceBundle resourceBundle = XMLUIMessages.getResourceBundle();
        this.fShowTooltipAction = new RetargetTextEditorAction(resourceBundle, "");
        this.fShowTooltipAction.setActionDefinitionId("org.eclipse.wst.sse.ui.show.javadoc");
        this.fContentAssist = new RetargetTextEditorAction(resourceBundle, "");
        this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fQuickFix = new RetargetTextEditorAction(resourceBundle, "");
        this.fQuickFix.setActionDefinitionId("org.eclipse.wst.sse.ui.edit.text.java.correction.assist.proposals");
        this.fCleanupDocument = new RetargetTextEditorAction(resourceBundle, "");
        this.fCleanupDocument.setActionDefinitionId("org.eclipse.wst.sse.ui.cleanup.document");
        this.fFormatDocument = new RetargetTextEditorAction(resourceBundle, "");
        this.fFormatDocument.setActionDefinitionId("org.eclipse.wst.sse.ui.format.document");
        this.fFormatActiveElements = new RetargetTextEditorAction(resourceBundle, "");
        this.fFormatActiveElements.setActionDefinitionId("org.eclipse.wst.sse.ui.format.active.elements");
        this.fFormatMenu = new MenuManager(XMLUIMessages.FormatMenu_label);
        this.fFormatMenu.add((IAction)this.fFormatDocument);
        this.fFormatMenu.add((IAction)this.fFormatActiveElements);
        this.fOpenFileAction = new RetargetTextEditorAction(resourceBundle, "");
        this.fOpenFileAction.setActionDefinitionId("org.eclipse.wst.sse.ui.open.file.from.source");
        this.fFindOccurrences = new RetargetTextEditorAction(resourceBundle, "");
        this.fFindOccurrences.setActionDefinitionId("org.eclipse.wst.sse.ui.search.find.occurrences");
        this.fTest = new RetargetTextEditorAction(resourceBundle, "");
        this.fTest.setActionDefinitionId("EditReferencedFile");
    }

    protected void addToMenu(IMenuManager menu) {
        IMenuManager navigateMenu;
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)this.fCommandsSeparator);
            editMenu.add((IAction)this.fToggleInsertModeAction);
            editMenu.add((IContributionItem)this.fCommandsSeparator);
            editMenu.add((IContributionItem)this.fExpandSelectionToMenu);
            editMenu.add((IContributionItem)this.fCommandsSeparator);
            editMenu.add((IAction)this.fShowTooltipAction);
            editMenu.add((IAction)this.fContentAssist);
            editMenu.add((IAction)this.fQuickFix);
            editMenu.add((IContributionItem)this.fMenuAdditionsGroupMarker);
        }
        String sourceMenuLabel = XMLUIMessages.SourceMenu_label;
        String sourceMenuId = "sourceMenuId";
        MenuManager sourceMenu = new MenuManager(sourceMenuLabel, sourceMenuId);
        menu.insertAfter("edit", (IContributionItem)sourceMenu);
        if (sourceMenu != null) {
            sourceMenu.add((IContributionItem)this.fCommandsSeparator);
            sourceMenu.add((IAction)this.fToggleComment);
            sourceMenu.add((IAction)this.fAddBlockComment);
            sourceMenu.add((IAction)this.fRemoveBlockComment);
            sourceMenu.add((IAction)this.fShiftRight);
            sourceMenu.add((IAction)this.fShiftLeft);
            sourceMenu.add((IAction)this.fCleanupDocument);
            sourceMenu.add((IContributionItem)this.fFormatMenu);
            sourceMenu.add((IContributionItem)this.fCommandsSeparator);
            sourceMenu.add((IAction)this.fFindOccurrences);
            sourceMenu.add((IAction)this.fTest);
        }
        if ((navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
            navigateMenu.appendToGroup("open.ext", (IContributionItem)this.fCommandsSeparator);
            navigateMenu.appendToGroup("open.ext", (IAction)this.fOpenFileAction);
        }
    }

    protected String[] getExtensionIDs() {
        return EDITOR_IDS;
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        IStatusLineManager statusLineManager;
        if (this.getActiveEditorPart() == activeEditor) {
            return;
        }
        super.setActiveEditor(activeEditor);
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null && (statusLineManager = actionBars.getStatusLineManager()) != null) {
            statusLineManager.setMessage(null);
            statusLineManager.setErrorMessage(null);
        }
        ITextEditor textEditor = this.getTextEditor(activeEditor);
        this.fShowTooltipAction.setAction(this.getAction(textEditor, "ShowTooltipDesc"));
        this.fContentAssist.setAction(this.getAction(textEditor, "ContentAssistProposals"));
        this.fQuickFix.setAction(this.getAction(textEditor, "QuickFix"));
        this.fCleanupDocument.setAction(this.getAction(textEditor, "CleanupDocument"));
        this.fFormatDocument.setAction(this.getAction(textEditor, "FormatDocument"));
        this.fFormatActiveElements.setAction(this.getAction(textEditor, "FormatActiveElements"));
        this.fCleanupDocument.setEnabled(textEditor != null && textEditor.isEditable());
        this.fFormatDocument.setEnabled(textEditor != null && textEditor.isEditable());
        this.fFormatActiveElements.setEnabled(textEditor != null && textEditor.isEditable());
        this.fOpenFileAction.setAction(this.getAction(textEditor, "OpenFileFromSource"));
        this.fFindOccurrences.setAction(this.getAction(textEditor, "FindOccurrences"));
        this.fTest.setAction(this.getAction(textEditor, "EditReferencedFile"));
    }

    public void setViewerSpecificContributionsEnabled(boolean enabled) {
        super.setViewerSpecificContributionsEnabled(enabled);
        this.fShowTooltipAction.setEnabled(enabled);
        this.fContentAssist.setEnabled(enabled);
        this.fQuickFix.setEnabled(enabled);
        this.fFormatActiveElements.setEnabled(enabled);
        this.fOpenFileAction.setEnabled(enabled);
        this.fFindOccurrences.setEnabled(enabled);
        this.fTest.setEnabled(enabled);
    }
}

