/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.editor.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.vtp.editor.actions.ActionSupport;
import org.eclipse.vtp.editor.nls.VoicetoolsResourceHandler;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class EditReferencedFileActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IEditorPart fEditor;
    private String attrValueLoaded;
    StructuredTextEditor textEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor;
    }

    public void dispose() {
        this.fEditor = null;
    }

    public void init(IAction action) {
        if (action != null) {
            action.setText(VoicetoolsResourceHandler.getString("EditReferencedFile.label"));
            action.setToolTipText(VoicetoolsResourceHandler.getString("EditReferencedFile.tooltip"));
            action.setDescription(VoicetoolsResourceHandler.getString("EditReferencedFile.description"));
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.fEditor instanceof ITextEditor) {
            this.textEditor = (StructuredTextEditor)this.fEditor;
        }
        String[] attrs = this.getAttributeNames();
        int i = 0;
        while (i < attrs.length) {
            this.attrValueLoaded = ActionSupport.currentPosGetAttributeValue(this.textEditor, attrs[i]);
            if (this.attrValueLoaded != null) break;
            ++i;
        }
        if (this.attrValueLoaded == null) {
            this.displayAttributeError2();
        } else if (this.attrValueLoaded.toLowerCase().startsWith("file:") || this.attrValueLoaded.toLowerCase().startsWith("http:") || this.attrValueLoaded.toLowerCase().startsWith("https:") || this.attrValueLoaded.toLowerCase().startsWith("ftp:") || this.attrValueLoaded.startsWith("/") || this.attrValueLoaded.startsWith("\\")) {
            this.displayPathError();
        } else {
            IFileEditorInput fileEditorInput = (IFileEditorInput)this.textEditor.getEditorInput();
            IFile editorFile = fileEditorInput.getFile();
            IProject currentProject = editorFile.getProject();
            IPath editorFilePath = editorFile.getFullPath();
            editorFilePath = editorFilePath.removeFirstSegments(1);
            IPath editorFileLocatedPath = (editorFilePath = editorFilePath.removeLastSegments(1)).append(this.attrValueLoaded);
            String streditorFileLocatedPath = editorFileLocatedPath.toString();
            IFile fullFileLoaded = currentProject.getFile(streditorFileLocatedPath);
            if (fullFileLoaded.exists()) {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)fullFileLoaded, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    this.displayEditorNotOpenError();
                }
            } else {
                this.displayAttributeError();
            }
        }
    }

    protected void displayAttributeError2() {
        VoicetoolsResourceHandler.displayErrorDialog("EditReferencedFileErrorTitle", "EditReferencedFileInvalidLocation");
    }

    protected void displayAttributeError() {
        VoicetoolsResourceHandler.displayErrorDialog("EditReferencedFileErrorTitle", "EditReferencedFileErrorFileNotFound");
    }

    protected void displayPathError() {
        VoicetoolsResourceHandler.displayErrorDialog("EditReferencedFileErrorTitle", "EditReferencedFileErrorPathNotResolved");
    }

    protected void displayEditorNotOpenError() {
        VoicetoolsResourceHandler.displayErrorDialog("EditReferencedFileErrorTitle", "EditReferencedFileErrorEditorNotOpen");
    }

    protected String[] getAttributeNames() {
        return new String[]{"src"};
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

