/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.editor.wizards;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import org.eclipse.vtp.catalog.registry.CatalogEntry;
import org.eclipse.vtp.editor.nls.VoicetoolsResourceHandler;

public class NewFileContentGenerator {
    protected static final String INDENT = "   ";
    private CatalogEntry dtd;

    public NewFileContentGenerator(CatalogEntry dtd) {
        this.dtd = dtd;
    }

    public CatalogEntry getDTD() {
        return this.dtd;
    }

    protected String getMimeType() {
        return "application/voicexml+xml";
    }

    protected void indent(PrintWriter p) {
        p.print(INDENT);
    }

    public void writeRootElement(PrintWriter p, boolean writeJSPPageDirective, String encodingString, String rootElementName) {
        p.print("<");
        p.print(rootElementName);
        this.writeVersionAttribute(p);
        if (rootElementName == "vxml") {
            this.writeNamespaceAttribute(p);
            this.writeLanguageAttribute(p);
        }
        this.addAdditionalAttributes1(p);
        p.println(">");
        if (writeJSPPageDirective) {
            this.writeJSPPageDirective(p, encodingString);
        }
        if (rootElementName == "vxml") {
            this.writeMetaTag(p);
        }
        this.writeComment(p);
        this.addAdditionalAttributes2(p);
        this.writeClosingTag(p, rootElementName);
    }

    protected void writeNamespaceAttribute(PrintWriter p) {
        String namespace = "http://www/w3/org/2001/vxml";
        if (namespace != null && namespace.length() > 0) {
            p.print(" xmlns=\"");
            p.print(namespace);
            p.print("\"");
        } else {
            p.print(" xmlns=\"");
            p.print("\"");
        }
    }

    protected void writeVersionAttribute(PrintWriter p) {
        p.print(" version=\"");
        p.print(this.dtd.getVersion());
        p.print("\"");
    }

    protected void writeLanguageAttribute(PrintWriter p) {
        String lang = this.getXmlLang();
        String country = this.getXmlCountry();
        if (lang != null && lang.length() > 0) {
            p.print(" xml:lang=\"");
            p.print(lang);
            p.print("-");
            p.print(country);
            p.print("\"");
        }
    }

    protected String getXmlLang() {
        return System.getProperty("user.language");
    }

    protected String getXmlCountry() {
        return System.getProperty("user.country");
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    protected void addAdditionalAttributes1(PrintWriter p) {
    }

    protected void addAdditionalAttributes2(PrintWriter p) {
    }

    public void writeDocType(PrintWriter p, String rootElementName, String contentType) {
        p.print("<!DOCTYPE ");
        p.print(rootElementName);
        p.print(" ");
        String publicKey = this.dtd.getKey();
        p.print("PUBLIC \"");
        p.print(publicKey);
        p.print("\" \"");
        String webUrl = this.dtd.getWebURL();
        if (webUrl != null && webUrl.length() > 0) {
            p.print(webUrl);
        } else {
            String uri = this.dtd.getURI();
            String shortName = uri.substring(uri.lastIndexOf(47) + 1);
            p.print(shortName);
        }
        p.println("\">");
        p.println();
    }

    protected void writeClosingTag(PrintWriter p, String rootElementName) {
        p.print("</");
        p.print(rootElementName);
        p.println(">");
    }

    public void writeComment(PrintWriter p) {
        this.indent(p);
        p.println(VoicetoolsResourceHandler.getString("NewFileWizards.UserMessage"));
        p.println();
        p.println();
    }

    public void writeMetaTag(PrintWriter p) {
        String name = "Generator";
        String content = "Eclipse";
        if (name != null && content != null && name.length() > 0 && content.length() > 0) {
            this.indent(p);
            p.print("<meta name=\"");
            p.print(name);
            p.print("\" content=\"");
            p.print(content);
            p.println("\"/>");
        }
    }

    public void writeJSPPageDirective(PrintWriter p, String encodingString) {
        p.print("<%@ page contentType=\" ");
        p.print(this.getMimeType());
        p.print("; charset=");
        p.print(encodingString);
        p.print("\" pageEncoding=\"");
        p.print(encodingString);
        p.println("\" %>");
    }

    public void writeXMLHeader(PrintWriter p) {
        p.print("<?xml version=\"1.0\" encoding =\"");
        p.print(this.getXMLEncoding());
        p.println("\"?>");
    }

    public String getXMLEncoding() {
        return "UTF-8";
    }

    public void setDTD(CatalogEntry dtd) {
        this.dtd = dtd;
    }

    public String getNewFileContent(boolean writePageDirective, String rootElementName, String contentType) {
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        this.writeXMLHeader(p);
        this.writeDocType(p, rootElementName, contentType);
        this.writeRootElement(p, writePageDirective, this.getXMLEncoding(), rootElementName);
        p.flush();
        return w.toString();
    }
}

