/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.editor.vxml.core.internal.contentmodel.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter {
    protected boolean formattingEnabled = true;
    protected boolean outputDoctypeEnabled = true;
    protected PrintWriter out;
    protected int indent = 0;

    public DOMWriter() throws UnsupportedEncodingException {
        this(System.out);
    }

    public DOMWriter(OutputStream outputSteam) {
        this.out = new PrintWriter(outputSteam);
    }

    public DOMWriter(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void setFormattingEnabled(boolean enabled) {
        this.formattingEnabled = enabled;
    }

    public boolean getFormattingEnabled() {
        return this.formattingEnabled;
    }

    public void setOutputDoctypeEnabled(boolean enabled) {
        this.outputDoctypeEnabled = enabled;
    }

    protected boolean doShow(Element element) {
        return true;
    }

    protected String createPrintableCharacterData(String string) {
        int ampersandIndex;
        String result = "";
        int index = 0;
        while ((ampersandIndex = string.indexOf("&", index)) != -1) {
            result = String.valueOf(result) + string.substring(index, ampersandIndex);
            result = String.valueOf(result) + "&amp;";
            index = ampersandIndex + 1;
        }
        result = String.valueOf(result) + string.substring(index);
        return result;
    }

    public void print(Node node) {
        if (node != null) {
            XMLVisitor visitor = new XMLVisitor();
            visitor.visitNode(node);
        }
        this.out.flush();
    }

    public void print(Document document, String grammarURL) {
        int lastSlashIndex;
        String systemId = null;
        if (grammarURL.endsWith("dtd") && (lastSlashIndex = Math.max(grammarURL.lastIndexOf("/"), grammarURL.lastIndexOf("\\"))) != -1) {
            systemId = grammarURL.substring(lastSlashIndex + 1);
        }
        this.print(document, "UTF-8", grammarURL, null, systemId);
    }

    public void print(Document document, String encoding, String grammarFileName, String publicId, String systemId) {
        this.out.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        if (grammarFileName.endsWith(".dtd")) {
            String docTypeLine = "<!DOCTYPE " + document.getDocumentElement().getNodeName() + " ";
            if (publicId != null) {
                docTypeLine = String.valueOf(docTypeLine) + "PUBLIC \"" + publicId + "\" ";
                if (systemId != null) {
                    docTypeLine = String.valueOf(docTypeLine) + "\"" + systemId + "\" ";
                }
                docTypeLine = String.valueOf(docTypeLine) + ">";
                this.out.println(docTypeLine);
            } else if (systemId != null) {
                docTypeLine = String.valueOf(docTypeLine) + "SYSTEM \"" + systemId + "\" >";
                this.out.println(docTypeLine);
            }
        }
        this.print(document);
    }

    public static String getDocumentTypeData(DocumentType doctype) {
        String data = doctype.getName();
        if (doctype.getPublicId() != null) {
            data = String.valueOf(data) + " PUBLIC \"" + doctype.getPublicId() + "\"";
            String systemId = doctype.getSystemId();
            if (systemId == null) {
                systemId = "";
            }
            data = String.valueOf(data) + " \"" + systemId + "\"";
        } else {
            data = String.valueOf(data) + " SYSTEM \"" + doctype.getSystemId() + "\"";
        }
        return data;
    }

    public void println() {
        if (this.formattingEnabled) {
            this.out.println();
        }
    }

    public void println(String string) {
        if (this.formattingEnabled) {
            this.out.println(string);
        } else {
            this.out.print(string);
        }
    }

    public void printIndent() {
        if (this.formattingEnabled) {
            int i = 0;
            while (i < this.indent) {
                this.out.print(" ");
                ++i;
            }
        }
    }

    public void print(String string) {
        this.out.print(string);
    }

    public class XMLVisitor {
        protected boolean currentElementHasChildElements = false;

        public void visitNode(Node node) {
            switch (node.getNodeType()) {
                case 2: {
                    this.visitAttr((Attr)node);
                    break;
                }
                case 4: {
                    this.visitCDATASection((CDATASection)node);
                    break;
                }
                case 8: {
                    this.visitComment((Comment)node);
                    break;
                }
                case 9: {
                    this.visitDocument((Document)node);
                    break;
                }
                case 10: {
                    this.visitDocumentType((DocumentType)node);
                    break;
                }
                case 1: {
                    this.visitElement((Element)node);
                    break;
                }
                case 7: {
                    this.visitProcessingInstruction((ProcessingInstruction)node);
                    break;
                }
                case 3: {
                    this.visitText((Text)node);
                }
            }
        }

        public void visitDocument(Document document) {
            this.visitChildNodesHelper(document);
        }

        public void visitDocumentType(DocumentType doctype) {
            if (DOMWriter.this.outputDoctypeEnabled) {
                String data = DOMWriter.getDocumentTypeData(doctype);
                DOMWriter.this.print("<!DOCTYPE " + data + ">");
            }
        }

        public void visitElement(Element element) {
            boolean isRootElement;
            if (!DOMWriter.this.doShow(element)) {
                return;
            }
            boolean parentElementHasChildNodes = this.currentElementHasChildElements;
            this.currentElementHasChildElements = this.hasChildElements(element);
            DOMWriter.this.printIndent();
            DOMWriter.this.print("<");
            DOMWriter.this.print(element.getNodeName());
            this.visitAttributesHelper(element);
            boolean hasChildNodes = element.getChildNodes().getLength() > 0;
            boolean bl = isRootElement = element.getParentNode().getNodeType() == 9;
            if (hasChildNodes || isRootElement) {
                if (this.currentElementHasChildElements || isRootElement) {
                    DOMWriter.this.println(">");
                } else {
                    DOMWriter.this.print(">");
                }
                DOMWriter.this.indent += 2;
                this.visitChildNodesHelper(element);
                DOMWriter.this.indent -= 2;
                if (this.currentElementHasChildElements || isRootElement) {
                    DOMWriter.this.printIndent();
                }
                DOMWriter.this.print("</");
                DOMWriter.this.print(element.getNodeName());
                DOMWriter.this.println(">");
            } else {
                DOMWriter.this.println("/>");
            }
            this.currentElementHasChildElements = parentElementHasChildNodes;
        }

        public void visitAttr(Attr attr) {
            DOMWriter.this.print(" ");
            DOMWriter.this.print(attr.getNodeName());
            DOMWriter.this.print("=\"");
            DOMWriter.this.print(DOMWriter.this.createPrintableCharacterData(attr.getValue()));
            DOMWriter.this.print("\"");
        }

        public void visitText(Text text) {
            if (this.currentElementHasChildElements) {
                DOMWriter.this.printIndent();
                DOMWriter.this.print(DOMWriter.this.createPrintableCharacterData(text.getNodeValue()));
                DOMWriter.this.println();
            } else {
                DOMWriter.this.print(DOMWriter.this.createPrintableCharacterData(text.getNodeValue()));
            }
        }

        public void visitCDATASection(CDATASection cdataSection) {
        }

        public void visitComment(Comment comment) {
            DOMWriter.this.printIndent();
            DOMWriter.this.print("<!--");
            DOMWriter.this.print(comment.getNodeValue());
            DOMWriter.this.println("-->");
        }

        public void visitProcessingInstruction(ProcessingInstruction pi) {
            DOMWriter.this.printIndent();
            DOMWriter.this.print("<?");
            DOMWriter.this.print(pi.getNodeName());
            DOMWriter.this.print(" ");
            DOMWriter.this.print(pi.getNodeValue());
            DOMWriter.this.println("?>");
        }

        public boolean hasChildElements(Node node) {
            boolean result = false;
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    result = true;
                    break;
                }
                ++i;
            }
            return result;
        }

        public void visitChildNodesHelper(Node node) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                this.visitNode(children.item(i));
                ++i;
            }
        }

        public void visitAttributesHelper(Node node) {
            NamedNodeMap map = node.getAttributes();
            int i = 0;
            while (i < map.getLength()) {
                this.visitNode(map.item(i));
                ++i;
            }
        }
    }
}

