/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.internal.dialer.nullphone;

import java.io.PrintStream;
import org.eclipse.vtp.internal.dialer.IVoipCall;
import org.eclipse.vtp.internal.dialer.IVoipConnection;
import org.eclipse.vtp.internal.dialer.IVoipDialer;
import org.eclipse.vtp.internal.dialer.IVoipDialerFactory;
import org.eclipse.vtp.internal.dialer.IVoipDialerListener;
import org.eclipse.vtp.internal.dialer.VoipDialerException;
import org.eclipse.vtp.internal.dialer.VoipDialerListener;

public class NullPhone
implements IVoipCall,
IVoipConnection,
IVoipDialer,
IVoipDialerFactory {
    private int currentStatus;
    private VoipDialerListener listener;
    private final int thisId;
    private final int thisRole;
    private static int idBase = 0;
    private static final int ROLE_DIALER = 0;
    private static final int ROLE_CONNECTION = 1;
    private static final int ROLE_CALL = 2;

    public NullPhone() {
        this(0);
    }

    private NullPhone(int role) {
        this.thisRole = role;
        this.thisId = ++idBase;
        switch (role) {
            case 0: {
                this.currentStatus = 2;
                break;
            }
            case 1: {
                this.currentStatus = 1;
                break;
            }
            case 2: {
                this.currentStatus = 1;
                break;
            }
        }
    }

    public IVoipDialer getDialer() {
        return this;
    }

    public int status() {
        return this.currentStatus;
    }

    public void sendDTMF(String dtmf) throws VoipDialerException {
        if (this.thisRole != 2) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, "Attempt to sendDTMF from non-call object (id: " + this.thisId + ")");
        }
        this.listener.dialerMessage("DTMF " + dtmf + " <" + this.thisId + ">");
    }

    public void sendDTMF(String dtmf, int pause) throws VoipDialerException {
        if (this.thisRole != 2) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, "Attempt to sendDTMF from non-call object (id: " + this.thisId + ")");
        }
        this.listener.dialerMessage("DTMF " + dtmf + " <" + this.thisId + "> (explicit pause of " + pause + "ms)");
    }

    public void hangUp() throws VoipDialerException {
        if (this.thisRole != 2) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, "Attempt to hangUp from non-call object (id: " + this.thisId + ")");
        }
        this.listener.dialerMessage("HANGUP <" + this.thisId + ">");
    }

    public IVoipCall dial(String number) throws VoipDialerException {
        if (this.thisRole != 1) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, "Attempt to dial from non-connection object (id: " + this.thisId + ")");
        }
        NullPhone callObj = new NullPhone(2);
        this.listener.dialerMessage("DIAL " + number + "<" + this.thisId + ">, new call has ID: " + callObj.thisId);
        return callObj;
    }

    public void disconnect() throws VoipDialerException {
        if (this.thisRole != 1) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, "Attempt to disconnect from non-connection object (id: " + this.thisId + ")");
        }
        this.listener.dialerMessage("DISCONNECT <" + this.thisId + ">");
    }

    public void initialize() throws VoipDialerException {
        this.initialize(new IVoipDialerListener(){

            public void dialerMessage(String msg) {
            }
        });
    }

    public void initialize(IVoipDialerListener theirListener) throws VoipDialerException {
        if (this.thisRole != 0) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, "Attempt to initialize from non-dialer object (id: " + this.thisId + ")");
        }
        this.currentStatus = 1;
        this.listener = new LocalListener(theirListener);
        this.listener.dialerMessage("INIT <" + this.thisId + ">");
    }

    public IVoipConnection connect() throws VoipDialerException {
        if (this.thisRole != 0) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, "Attempt to connect from non-dialer object (id: " + this.thisId + ")");
        }
        NullPhone connectionObj = new NullPhone(1);
        this.listener.dialerMessage("CONNECT <" + this.thisId + ">, new connection has ID: " + connectionObj.thisId);
        return connectionObj;
    }

    public void writeMessageLog(PrintStream dest) {
        String[] messageHistory = this.listener.messageHistory();
        int idx = 0;
        while (idx < messageHistory.length) {
            dest.println(messageHistory[idx]);
            ++idx;
        }
    }

    public IVoipConnection getConnection() {
        return new NullPhone(1);
    }

    private class LocalListener
    extends VoipDialerListener {
        private IVoipDialerListener theirListener = null;

        LocalListener() {
        }

        LocalListener(IVoipDialerListener otherListener) {
            this.theirListener = otherListener;
        }

        public void dialerMessage(String message) {
            super.dialerMessage(message);
            if (this.theirListener != null) {
                this.theirListener.dialerMessage(message);
            }
        }
    }
}

