/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.tellme;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.vtp.launching.IVoiceXMLBrowser;
import org.eclipse.vtp.launching.VoiceXMLBrowserProcess;
import org.eclipse.vtp.launching.VoiceXMLLogMessage;
import org.eclipse.vtp.launching.tellme.CallLog;
import org.eclipse.vtp.launching.tellme.CallState;
import org.eclipse.vtp.launching.tellme.LogItem;
import org.eclipse.vtp.launching.tellme.LogItemReader;
import org.eclipse.vtp.launching.tellme.StudioInteractions;
import org.eclipse.vtp.launching.tellme.TellmeBrowserException;
import org.eclipse.vtp.launching.tellme.TellmePlugin;

public class GetLogItems
implements Runnable {
    private static final SimpleDateFormat logDF = new SimpleDateFormat("MM/dd/yy HH:mm:ss", Locale.getDefault());
    private static final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private static final boolean DEBUGGING = TellmePlugin.getDefault().isDebugging();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StringBuffer logList;
        CallState.initLogFetch();
        IVoiceXMLBrowser activeBrowser = null;
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches == null) {
            CallState.reportLogFetchFail("Fatal problem, no launches in the LaunchManager");
            Object object = CallState.getSynch();
            synchronized (object) {
                CallState.setLogFetchDone();
                if (DEBUGGING) {
                    System.out.println(String.valueOf(time.format(new Date())) + "calling launchDone from logFetch on failure");
                    System.out.flush();
                }
                if (CallState.launchDone()) {
                    CallState.endLaunch();
                }
            }
            return;
        }
        int i = 0;
        while (i < launches.length) {
            IProcess[] t = launches[i].getProcesses();
            if (t != null && t.length > 0 && t[0] instanceof VoiceXMLBrowserProcess) {
                activeBrowser = ((VoiceXMLBrowserProcess)t[0]).getVoiceXMLBrowser();
            }
            ++i;
        }
        CallLog theLog = null;
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": GetLogItems started");
            System.out.flush();
        }
        if ((logList = CallState.getLogList()) == null) {
            CallState.reportLogFetchFail("No log created by Studio");
            Object object = CallState.getSynch();
            synchronized (object) {
                CallState.setLogFetchDone();
                if (DEBUGGING) {
                    System.out.println(String.valueOf(time.format(new Date())) + "calling launchDone from logFetch on failure (no log)");
                    System.out.flush();
                }
                if (CallState.launchDone()) {
                    CallState.endLaunch();
                }
            }
            return;
        }
        theLog = StudioInteractions.getFirstLogFromList(logList);
        try {
            LogItemReader theLogReader = StudioInteractions.getLogItemReader(theLog);
            LogItem theItem = theLogReader.nextLogItem();
            if (theItem == null) {
                DebugEvent[] event = new DebugEvent[]{new DebugEvent((Object)activeBrowser, 32, 3)};
                event[0].setData((Object)new VoiceXMLLogMessage(new Date(), "No log events returned from Studio"));
                DebugPlugin.getDefault().fireDebugEventSet(event);
                CallState.reportLogFetchFail("No log events returned from Studio");
                Object object = CallState.getSynch();
                synchronized (object) {
                    CallState.setLogFetchDone();
                    if (DEBUGGING) {
                        System.out.println(String.valueOf(time.format(new Date())) + "calling launchDone from logFetch on failure (no log events)");
                        System.out.flush();
                    }
                    if (CallState.launchDone()) {
                        CallState.endLaunch();
                    }
                }
                return;
            }
            Date logDate = null;
            while (theItem != null && !CallState.isStopping()) {
                if (DEBUGGING) {
                    System.out.println(String.valueOf(time.format(new Date())) + ": log item: \t" + theItem.getKind() + "\t" + theItem.getTime() + "\t" + theItem.getBody());
                    System.out.flush();
                }
                try {
                    logDate = logDF.parse(theItem.getTime());
                }
                catch (ParseException e) {
                    DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "Failed to parse datetime in log message", (Throwable)e));
                }
                DebugEvent[] event = new DebugEvent[]{new DebugEvent((Object)activeBrowser, 32, 3)};
                event[0].setData((Object)new VoiceXMLLogMessage(logDate, theItem.getBody()));
                DebugPlugin.getDefault().fireDebugEventSet(event);
                if (!"SESSION_DONE".equals(theItem.getBody())) {
                    theItem = theLogReader.nextLogItem();
                    continue;
                }
                break;
            }
        }
        catch (TellmeBrowserException e) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "Possible HTTP failure of some kind", (Throwable)e));
        }
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": no more log items");
            System.out.flush();
        }
        if (CallState.isStopping()) {
            CallState.reportLogFetchFail("Stop button pushed");
        } else if (theLog == null) {
            CallState.reportLogFetchFail("Failed to connect");
        } else {
            CallState.setCallID(theLog.getCallID());
            CallState.reportLogFetchSucceed("");
        }
        Object object = CallState.getSynch();
        synchronized (object) {
            CallState.setLogFetchDone();
            if (DEBUGGING) {
                System.out.println(String.valueOf(time.format(new Date())) + ": calling launchDone from logFetch at end");
                System.out.flush();
            }
            if (CallState.launchDone()) {
                CallState.endLaunch();
            }
        }
    }
}

