/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.tellme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.vtp.launching.tellme.CallState;
import org.eclipse.vtp.launching.tellme.GetLogItems;
import org.eclipse.vtp.launching.tellme.StudioInteractions;
import org.eclipse.vtp.launching.tellme.TellmePlugin;

public class GetLogListChange
implements Runnable {
    static final int WAIT_SECS = 30;
    private static final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private static final boolean DEBUGGING = TellmePlugin.getDefault().isDebugging();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CallState.initLogList();
        String logList0 = StudioInteractions.getListOfLogs().toString();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "While waiting for log list to start changing", (Throwable)e1));
        }
        StringBuffer logList = null;
        int waitLoops = 15;
        while ((logList = StudioInteractions.getListOfLogs()) != null && logList.toString().equals(logList0) && waitLoops-- != 0) {
            if (DEBUGGING) {
                System.out.println(String.valueOf(time.format(new Date())) + ": Check for log flow start again.");
                System.out.flush();
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "Waiting for log to begin flowing", (Throwable)e));
            }
            if (CallState.isStopping()) break;
        }
        if (CallState.isStopping()) {
            CallState.reportLogListFail("Stop button pushed");
            CallState.reportLogFetchFail("");
            Object object = CallState.getSynch();
            synchronized (object) {
                CallState.setLogListDone();
                CallState.setLogFetchDone();
                if (CallState.launchDone()) {
                    CallState.endLaunch();
                }
            }
            return;
        }
        if (waitLoops <= 0) {
            if (DEBUGGING) {
                System.out.println("waited too long for log to start streaming");
                System.out.flush();
            }
            CallState.reportLogListFail("No new log for call in 30 seconds");
            CallState.setLogList(null);
        } else {
            CallState.setLogList(logList);
            CallState.reportLogListSucceed("");
        }
        Object object = CallState.getSynch();
        synchronized (object) {
            CallState.setLogListDone();
        }
        new GetLogItems().run();
    }
}

