/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.tellme;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vtp.launching.tellme.LogItem;
import org.eclipse.vtp.launching.tellme.LogToken;

public class LogItemReader {
    private final BufferedReader myReader;
    private static final Pattern logLine = Pattern.compile("<div class=\"log_\\w+?\">\\s*\\[(.*?)\\]\\s(.*?)</div>");
    final Pattern htmlItem = Pattern.compile("<.*?>");
    final Pattern xmlChar = Pattern.compile("(&quot;)|(&apos;)|(&amp;)|(&gt;)|(&lt;)");
    final Pattern remTrash = Pattern.compile("\\[show detail *?\\]");

    public LogItemReader(InputStream httpStream) {
        this.myReader = new BufferedReader(new InputStreamReader(httpStream));
    }

    private LogToken extractToken() {
        StringBuffer accum = new StringBuffer();
        int ch = 0;
        try {
            ch = this.myReader.read();
            while (ch == 10 || ch == 13) {
                ch = this.myReader.read();
            }
        }
        catch (IOException iOException) {
            return new LogToken(8, "", false);
        }
        if (ch < 0) {
            return new LogToken(4, null, true);
        }
        accum.append((char)ch);
        if (ch == 60 && ch >= 0) {
            return this.readHtmlToken(accum, ch);
        }
        if (ch < 0) {
            return new LogToken(4, null, false);
        }
        return this.readTextToken(accum);
    }

    private LogToken readTextToken(StringBuffer accum) {
        block5: {
            try {
                this.myReader.mark(5);
                int ch = this.myReader.read();
                while (ch != 60 && ch >= 0) {
                    if (ch != 10 && ch != 13) {
                        accum.append((char)ch);
                    }
                    this.myReader.mark(5);
                    ch = this.myReader.read();
                }
                if (ch >= 0) {
                    this.myReader.reset();
                    break block5;
                }
                return new LogToken(4, accum.toString(), false);
            }
            catch (IOException iOException) {
                return new LogToken(8, accum.toString(), false);
            }
        }
        return new LogToken(2, accum.toString(), true);
    }

    private LogToken readHtmlToken(StringBuffer accum, int chr) {
        int ch = chr;
        try {
            ch = this.myReader.read();
            while (ch >= 0) {
                if (ch != 10 && ch != 13) {
                    accum.append((char)ch);
                }
                if (ch != 62) {
                    ch = this.myReader.read();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            return new LogToken(8, accum.toString(), false);
        }
        if (ch < 0) {
            return new LogToken(4, accum.append('>').toString(), false);
        }
        return new LogToken(1, accum.toString(), true);
    }

    public LogItem nextLogItem() {
        String type = null;
        StringBuffer accum = new StringBuffer();
        LogToken temp = null;
        while (!(temp = this.extractToken()).isDiv() && temp.getType() != 4 && temp.getType() != 8) {
        }
        if (temp.getType() == 4 || temp.getType() == 8) {
            return null;
        }
        accum.append(temp.getContent());
        type = temp.getLogType();
        while (!(temp = this.extractToken()).isEndDiv() && temp.getType() != 4 && temp.getType() != 8) {
            accum.append(temp.getContent());
        }
        accum.append(temp.getContent());
        if (temp.getType() == 4 || temp.getType() == 8) {
            return null;
        }
        Matcher matchLog = logLine.matcher(accum.toString());
        if (matchLog.matches()) {
            String logbody = this.massageLogBody(matchLog.group(2));
            return new LogItem(type, matchLog.group(1), logbody);
        }
        return new LogItem("error", null, accum.toString());
    }

    private String massageLogBody(String body) {
        Matcher htmlMatcher = this.htmlItem.matcher(body);
        StringBuffer acc = new StringBuffer();
        String interim = htmlMatcher.replaceAll("");
        Matcher trashMatcher = this.remTrash.matcher(interim);
        interim = trashMatcher.replaceAll("");
        Matcher xmlMatcher = this.xmlChar.matcher(interim);
        while (xmlMatcher.find()) {
            xmlMatcher.appendReplacement(acc, xmlMatcher.group(1) != null ? "\"" : (xmlMatcher.group(2) != null ? "'" : (xmlMatcher.group(3) != null ? "&" : (xmlMatcher.group(4) != null ? ">" : "<"))));
        }
        xmlMatcher.appendTail(acc);
        return acc.toString();
    }
}

