/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.tellme;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogToken {
    static final int HTML_TOKEN = 1;
    static final int TEXT_TOKEN = 2;
    static final int EOF_TOKEN = 4;
    static final int IOE_TOKEN = 8;
    private final int localtype;
    private final String localcontent;
    private final boolean localcomplete;
    private static final Pattern logDivPat = Pattern.compile("<div class=\"log_(\\w+?)\">");
    private static final Pattern logEndDivPat = Pattern.compile("</div>");
    private String logtype = "";

    public LogToken(int type, String content, boolean complete) {
        this.localtype = type;
        this.localcontent = content;
        this.localcomplete = complete;
    }

    public boolean isDiv() {
        this.logtype = "";
        if (this.localtype != 1) {
            return false;
        }
        Matcher divMatcher = logDivPat.matcher(this.localcontent);
        if (divMatcher.matches()) {
            this.logtype = divMatcher.group(1);
            return true;
        }
        return false;
    }

    public String getLogType() {
        return this.logtype;
    }

    public boolean isEndDiv() {
        if (this.localtype != 1) {
            return false;
        }
        return logEndDivPat.matcher(this.localcontent).matches();
    }

    public int getType() {
        return this.localtype;
    }

    public String getContent() {
        return this.localcontent;
    }

    public boolean getComplete() {
        return this.localcomplete;
    }
}

