/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.tellme;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.vtp.launching.tellme.CallLog;
import org.eclipse.vtp.launching.tellme.DisplayActions;
import org.eclipse.vtp.launching.tellme.LogItemReader;
import org.eclipse.vtp.launching.tellme.TellmeBrowserException;
import org.eclipse.vtp.launching.tellme.TellmePlugin;

public class StudioInteractions {
    protected static final String studioURLpath = "https://studio.tellme.com/mystudio/mystudio.pl";
    protected static final String studioLogListURL = "https://studio.tellme.com/mystudio/loglist.pl";
    protected static final String studioViewLogURL = "https://studio.tellme.com/mystudio/viewlog.pl";
    private static final boolean DEBUGGING = TellmePlugin.getDefault().isDebugging();
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private static String loginString = "";

    public static void studioScratchpadMode() {
        StudioInteractions.consumeStudioTransaction(studioURLpath, String.valueOf(loginString) + "&submit=yes&newmode=1", "Setting Scratchpad mode: ");
    }

    public static void sendApplicationURL(String appURL) {
        try {
            String studioURLquery = String.valueOf(loginString) + "&submit=yes&update.x=100&current_scratchpad_name=" + URLEncoder.encode("EclipseVTP", "UTF-8") + "&srv_scratchpad=" + URLEncoder.encode("<?xml version=\"1.0\" ?>\n<vxml version=\"2.1\">\n<form>\n<block>\n<goto next=\"" + appURL + "\"/>\n</block>\n</form>\n</vxml>", "UTF-8");
            StudioInteractions.consumeStudioTransaction(studioURLpath, studioURLquery, "Sending App URL: ");
        }
        catch (UnsupportedEncodingException e2) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "Error encoding URL to UTF-8", (Throwable)e2));
        }
    }

    public static StringBuffer getListOfLogs() {
        return StudioInteractions.captureStudioTransaction(studioLogListURL, loginString, "Getting List of Logs: ");
    }

    public static CallLog getFirstLogFromList(StringBuffer logList) {
        int startOfViewRef = -1;
        int endOfViewRef = -1;
        startOfViewRef = logList.indexOf("viewlog.pl?sessionid=");
        if (startOfViewRef == -1) {
            DisplayActions.showError("Problem fetching debug log", "No list of logs is available from Studio");
            return null;
        }
        endOfViewRef = logList.indexOf("\"", startOfViewRef);
        int callIDRef = logList.indexOf("<td ", endOfViewRef);
        callIDRef = logList.indexOf("<td ", callIDRef + 4);
        int endcallIDRef = logList.indexOf("<", callIDRef + 4);
        String callID = logList.substring(callIDRef + 16, endcallIDRef);
        String viewlog = logList.substring(startOfViewRef, endOfViewRef);
        String[] parts = viewlog.split("\\?");
        if (DEBUGGING) {
            System.out.println("**************************************************************");
            System.out.println("logviewing info: \n");
            System.out.println(viewlog);
        }
        return new CallLog(callID, String.valueOf(loginString) + "&" + parts[1]);
    }

    public static StringBuffer getTheLog(CallLog theLog) {
        return theLog == null ? new StringBuffer() : StudioInteractions.captureStudioTransaction(studioViewLogURL, theLog.getSessionID(), "Getting Log: ");
    }

    public static LogItemReader getLogItemReader(CallLog theLog) throws TellmeBrowserException {
        URL transactionURL = null;
        String urlQuery = theLog.getSessionID();
        String errormsg = "Getting log input stream: ";
        try {
            transactionURL = new URL(studioViewLogURL);
        }
        catch (MalformedURLException e1) {
            throw new TellmeBrowserException(e1.getMessage());
        }
        try {
            SSLContext sslCon = SSLContext.getInstance("SSL");
            sslCon.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslCon.getSocketFactory());
            HttpURLConnection connection = (HttpURLConnection)transactionURL.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-length", "" + urlQuery.length());
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(urlQuery);
            writer.flush();
            writer.close();
            int studioresponse = connection.getResponseCode();
            if (studioresponse != 200) {
                String err = String.valueOf(errormsg) + connection.getResponseMessage();
                DisplayActions.showError("Failed to connect to Tellme Studio", err);
                throw new TellmeBrowserException(err);
            }
            return new LogItemReader(connection.getInputStream());
        }
        catch (IOException e) {
            errormsg = e.getMessage();
        }
        catch (NoSuchAlgorithmException e) {
            errormsg = e.getMessage();
        }
        catch (KeyManagementException e) {
            errormsg = e.getMessage();
        }
        throw new TellmeBrowserException(errormsg);
    }

    public void consumeResponsePage(URLConnection connection) {
        StudioInteractions.handleResponsePage(connection, false);
    }

    public StringBuffer captureResponsePage(URLConnection connection) {
        return StudioInteractions.handleResponsePage(connection, true);
    }

    private static StringBuffer handleResponsePage(URLConnection connection, boolean keepPage) {
        StringWriter contentStore = new StringWriter();
        try {
            BufferedReader contentStream = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            PrintWriter contentWriter = new PrintWriter(contentStore);
            String line = contentStream.readLine();
            while (line != null) {
                if (keepPage) {
                    contentWriter.println(line);
                }
                line = contentStream.readLine();
            }
        }
        catch (IOException e) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "IO problem while reading html page from Studio", (Throwable)e));
        }
        return contentStore.getBuffer();
    }

    public static void consumeStudioTransaction(String urlPath, String urlQuery, String errmsg) {
        StudioInteractions.handleStudioTransaction(urlPath, urlQuery, false, errmsg);
    }

    public static StringBuffer captureStudioTransaction(String urlPath, String urlQuery, String errmsg) {
        return StudioInteractions.handleStudioTransaction(urlPath, urlQuery, true, errmsg);
    }

    protected static StringBuffer handleStudioTransaction(String urlPath, String urlQuery, boolean capturePage, String errormsg) {
        URL transactionURL = null;
        try {
            transactionURL = new URL(urlPath);
        }
        catch (MalformedURLException e1) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "This better never happen", (Throwable)e1));
        }
        try {
            SSLContext sslCon = SSLContext.getInstance("SSL");
            sslCon.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslCon.getSocketFactory());
            HttpURLConnection connection = (HttpURLConnection)transactionURL.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-length", "" + urlQuery.length());
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(urlQuery);
            writer.flush();
            writer.close();
            int studioresponse = connection.getResponseCode();
            if (studioresponse != 200) {
                String err = String.valueOf(errormsg) + connection.getResponseMessage();
                DisplayActions.showError("Failed to connect to Tellme Studio", err);
                return null;
            }
            return StudioInteractions.handleResponsePage(connection, capturePage);
        }
        catch (IOException e) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "Error while trying to read html from Studio", (Throwable)e));
        }
        catch (NoSuchAlgorithmException e) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "Error while trying to read html from Studio", (Throwable)e));
        }
        catch (KeyManagementException e) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, "Error while trying to read html from Studio", (Throwable)e));
        }
        return null;
    }

    protected static void setLogin(String loginstring) {
        loginString = loginstring;
    }
}

