/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.tellme.config;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.debug.ui.BrowserConfigurationUIListener;
import org.eclipse.vtp.debug.ui.IBrowserConfigurationUI;
import org.eclipse.vtp.launching.tellme.DisplayActions;
import org.eclipse.vtp.launching.tellme.TellmePlugin;

public class TellmeBrowserConfig
implements IBrowserConfigurationUI {
    protected Text devID = null;
    protected Label idlabel = null;
    protected Text devPIN = null;
    protected Label pinlabel = null;
    protected Text devEMAIL = null;
    protected Text devPSWD = null;
    protected Button noAutoLogin = null;
    private Group tellmeGroup = null;
    private final String phoneNumber;

    public TellmeBrowserConfig() {
        Preferences pluginPrefs = TellmePlugin.getDefault().getPluginPreferences();
        this.phoneNumber = pluginPrefs.getString("org.eclipse.vtp.launching.tellme.studio_phone");
    }

    public void drawConfigurationUI(Composite compUI, BrowserConfigurationUIListener callback) {
        final BrowserConfigurationUIListener localcallback = callback;
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                localcallback.contentsChanged();
            }
        };
        SelectionAdapter check = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button myWidget = (Button)event.widget;
                if (myWidget.getSelection()) {
                    TellmeBrowserConfig.this.devID.setEnabled(true);
                    TellmeBrowserConfig.this.idlabel.setEnabled(true);
                    TellmeBrowserConfig.this.devPIN.setEnabled(true);
                    TellmeBrowserConfig.this.pinlabel.setEnabled(true);
                } else {
                    TellmeBrowserConfig.this.devID.setEnabled(false);
                    TellmeBrowserConfig.this.idlabel.setEnabled(false);
                    TellmeBrowserConfig.this.devPIN.setEnabled(false);
                    TellmeBrowserConfig.this.pinlabel.setEnabled(false);
                }
                localcallback.contentsChanged();
            }
        };
        Text info = new Text(compUI, 8);
        GridData infoData = new GridData(768);
        infoData.verticalIndent = 20;
        info.setText("The URL above is published to Tellme Studio and the application it points to is run via a call through Skype.");
        this.tellmeGroup = new Group(compUI, 16);
        GridData groupgd = new GridData(768);
        groupgd.verticalIndent = 15;
        this.tellmeGroup.setLayoutData((Object)groupgd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.tellmeGroup.setLayout((Layout)layout);
        this.tellmeGroup.setText("Tellme Browser Configuration");
        Label email = new Label((Composite)this.tellmeGroup, 0);
        email.setText("Login email address:");
        email.setLayoutData((Object)new GridData());
        this.devEMAIL = new Text((Composite)this.tellmeGroup, 2052);
        GridData grid = new GridData(768);
        grid.grabExcessHorizontalSpace = true;
        this.devEMAIL.setLayoutData((Object)grid);
        this.devEMAIL.addModifyListener(listener);
        Label pswd = new Label((Composite)this.tellmeGroup, 0);
        pswd.setText("Login password:");
        pswd.setLayoutData((Object)new GridData());
        this.devPSWD = new Text((Composite)this.tellmeGroup, 0x400804);
        grid = new GridData(768);
        grid.grabExcessHorizontalSpace = true;
        this.devPSWD.setLayoutData((Object)grid);
        this.devPSWD.addModifyListener(listener);
        Composite loginControl = new Composite((Composite)this.tellmeGroup, 0);
        GridData loginCtrlLayout = new GridData(768);
        loginCtrlLayout.horizontalSpan = 4;
        loginControl.setLayoutData((Object)loginCtrlLayout);
        loginControl.setLayout((Layout)new RowLayout(256));
        this.noAutoLogin = new Button(loginControl, 32);
        this.noAutoLogin.setSelection(false);
        this.noAutoLogin.addSelectionListener((SelectionListener)check);
        Label box = new Label(loginControl, 0);
        box.setText(" Automatically send Developer ID && PIN when call starts");
        this.idlabel = new Label((Composite)this.tellmeGroup, 0);
        this.idlabel.setText("Developer ID:");
        this.idlabel.setLayoutData((Object)new GridData());
        this.idlabel.setEnabled(false);
        this.devID = new Text((Composite)this.tellmeGroup, 2052);
        grid = new GridData(768);
        grid.grabExcessHorizontalSpace = true;
        this.devID.setLayoutData((Object)grid);
        this.devID.addModifyListener(listener);
        this.devID.setEnabled(false);
        this.pinlabel = new Label((Composite)this.tellmeGroup, 0);
        this.pinlabel.setText("Developer PIN:");
        this.pinlabel.setLayoutData((Object)new GridData());
        this.pinlabel.setEnabled(false);
        this.devPIN = new Text((Composite)this.tellmeGroup, 0x400804);
        grid = new GridData(768);
        grid.grabExcessHorizontalSpace = true;
        this.devPIN.setLayoutData((Object)grid);
        this.devPIN.addModifyListener(listener);
        this.devPIN.setEnabled(false);
        Group tellmeInfoGroup = new Group(compUI, 24);
        GridLayout gl2 = new GridLayout();
        tellmeInfoGroup.setText("Getting Started");
        tellmeInfoGroup.setLayout((Layout)gl2);
        GridData groupgd2 = new GridData(1808);
        groupgd2.grabExcessHorizontalSpace = true;
        groupgd2.grabExcessVerticalSpace = true;
        tellmeInfoGroup.setLayoutData((Object)groupgd2);
        Text txt = new Text((Composite)tellmeInfoGroup, 66);
        GridData txtgd = new GridData(1808);
        txtgd.grabExcessVerticalSpace = true;
        txtgd.widthHint = 700;
        txt.setLayoutData((Object)txtgd);
        txt.setEditable(false);
        txt.setText("\nTellme Studio and the Tellme Voice Browser are provided as a developer service of Tellme Networks, Inc.\n\nTo use this service, register at http://studio.tellme.com (click on Join Studio)\n\t-  enter your email address and password, and your Developer ID and PIN in the text boxes above.\n\nThe Tellme VoiceXML Browser uses the Skype client to communicate with the voice application.\n\t-  obtain the Skype client from http://www.skype.com/ \n\t-  the Skype client must be running with a logged-in user before any voice application can be run.");
        compUI.pack();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.devEMAIL != null) {
            this.devEMAIL.setText("");
        }
        if (this.devPSWD != null) {
            this.devPSWD.setText("");
        }
        if (this.devID != null) {
            this.devID.setText("");
        }
        if (this.devPIN != null) {
            this.devPIN.setText("");
        }
        this.noAutoLogin.setSelection(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devID", this.devID.getText().trim());
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devPIN", this.devPIN.getText().trim());
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devEMAIL", this.devEMAIL.getText().trim());
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devPSWD", this.devPSWD.getText().trim());
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devNoAutoLogin", String.valueOf(this.noAutoLogin.getSelection()).trim());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.devID.setText(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devID", ""));
            this.devPIN.setText(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devPIN", ""));
            this.devEMAIL.setText(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devEMAIL", ""));
            this.devPSWD.setText(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devPSWD", ""));
            this.noAutoLogin.setSelection("true".equals(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devNoAutoLogin", "false")));
            if (this.noAutoLogin.getSelection()) {
                this.devID.setEnabled(true);
                this.devPIN.setEnabled(true);
                this.idlabel.setEnabled(true);
                this.pinlabel.setEnabled(true);
            }
        }
        catch (CoreException e) {
            DisplayActions.showError("Unable to initialize from launch configuration: " + e.getMessage());
        }
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        boolean valid;
        try {
            String devid = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devID", "").trim();
            String devpin = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devPIN", "").trim();
            String devemail = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devEMAIL", "").trim();
            String devpswd = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devPSWD", "").trim();
            String noautologin = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devNoAutoLogin", "false").trim();
            valid = devid.length() == 0 && "false".equals(noautologin) || devid.length() != 0 && devid.matches("\\d{1,5}");
            valid = valid && (devpin.length() == 0 && "false".equals(noautologin) || devpin.length() != 0 && devpin.matches("\\d{4,9}"));
            valid = valid && devemail.length() != 0 && devemail.indexOf(64) != -1;
            valid = valid && devpswd.length() != 0 && devpswd.matches("[\\w!-/:-@\\[-`{-~]{7,20}") && devpswd.matches(".*\\d.*");
        }
        catch (CoreException coreException) {
            valid = false;
        }
        return valid;
    }

    public void dispose() {
        if (this.tellmeGroup == null) {
            return;
        }
        this.tellmeGroup.dispose();
    }
}

