/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.editor.ccxml.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.vtp.catalog.registry.CatalogDefaultResolver;
import org.eclipse.vtp.catalog.registry.CatalogEntry;
import org.eclipse.vtp.editor.ccxml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.vtp.editor.ccxml.ui.internal.wizards.XMLWizardsMessages;
import org.eclipse.vtp.editor.wizards.NewModelWizard;

public class NewCCXMLModelWizard
extends NewModelWizard {

    public class CCXMLStartPage
    extends NewModelWizard.StartPage {
        public CCXMLStartPage(String pageName, String[] radioButtonLabel) {
            super((NewModelWizard)NewCCXMLModelWizard.this, pageName, radioButtonLabel);
            this.radioButtonLabel = radioButtonLabel;
            this.radioButton = new Button[radioButtonLabel.length];
        }

        public String getDefaultDTD() {
            CatalogEntry dtd = CatalogDefaultResolver.getDefaultEntryForContentType((String)"org.eclipse.vtp.editor.ccxml.core.ccxmlsource");
            if (dtd.getWebURL() != null) {
                return dtd.getWebURL();
            }
            return dtd.getURI();
        }
    }

    public class NewCCXMLFilePage
    extends NewModelWizard.NewFilePage {
        public String defaultName = "NewFile";
        public String defaultFileExtension = ".ccxml";
        public String[] filterExtensions = new String[]{"*.txt"};
        private List fValidExtensions = null;
        public String contentType = ContentTypeIdForXML.ContentTypeID_CCXML;

        public NewCCXMLFilePage(IStructuredSelection selection) {
            super((NewModelWizard)NewCCXMLModelWizard.this, selection);
        }

        protected String computeDefaultFileName() {
            int count = 0;
            String fileName = String.valueOf(this.defaultName) + this.defaultFileExtension;
            IPath containerFullPath = this.getContainerFullPath();
            if (containerFullPath != null) {
                while (true) {
                    IPath path = containerFullPath.append(fileName);
                    if (!ResourcesPlugin.getWorkspace().getRoot().exists(path)) break;
                    fileName = String.valueOf(this.defaultName) + ++count + this.defaultFileExtension;
                }
            }
            return fileName;
        }

        protected boolean validatePage() {
            String sameName;
            String fullFileName = this.getFileName();
            String fileExtension = new Path(fullFileName).getFileExtension();
            if (fileExtension != null && !this.getValidExtensions().contains(fileExtension)) {
                this.setErrorMessage(XMLWizardsMessages._ERROR_BAD_FILENAME_EXTENSION);
                return false;
            }
            fullFileName = String.valueOf(fullFileName) + this.defaultFileExtension;
            if (this.getContainerFullPath() != null && !this.getContainerFullPath().isEmpty() && this.getFileName().compareTo("") != 0) {
                Path fullPath = new Path(String.valueOf(this.getContainerFullPath().toString()) + '/' + fullFileName);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)fullPath);
                if (resource != null) {
                    this.setErrorMessage(XMLWizardsMessages._ERROR_FILE_ALREADY_EXISTS);
                    return false;
                }
            }
            if ((sameName = this.existsFileAnyCase(fullFileName)) != null) {
                this.setErrorMessage(String.valueOf(XMLWizardsMessages._ERROR_FILE_ALREADY_EXISTS) + " " + sameName);
                return false;
            }
            return super.validatePage();
        }

        public List getValidExtensions() {
            if (this.fValidExtensions == null) {
                IContentType type = Platform.getContentTypeManager().getContentType(this.contentType);
                this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
            }
            return this.fValidExtensions;
        }
    }
}

