/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/

package org.eclipse.vtp.dialer.skype;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class SkypePlugin extends Plugin {

    //The shared instance.
    private static SkypePlugin plugin;

    /**
     * The constructor.
     */
    public SkypePlugin() {
        super();
        plugin = this;
    }

    /**
     * This method is called upon plug-in activation
     */
    public void start(final BundleContext context) throws Exception {
        super.start(context);
        final Preferences prefs = plugin.getPluginPreferences();
        final boolean debugging =
            prefs.getBoolean("org.eclipse.vtp.dialer.skype.debugging");
        plugin.setDebugging(debugging);
    }

    /**
     * This method is called when the plug-in is stopped
     */
    public void stop(final BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    /**
     * Returns the shared instance.
     */
    public static SkypePlugin getDefault() {
        return plugin;
    }

}
