package org.eclipse.vtp.editor.actions;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;


/**
 * Abstract Base class for all voicetools action delegates. Its setActiveEditor method allows the same actions
 * to be used in the single page source editors as well as the multipage editors wrapping them.
 */
public abstract class AbstractVoiceToolsActionDelegate implements IEditorActionDelegate {

	private IEditorPart editor;
	private StructuredTextEditor textEditor = null;

	/**
	 * This method handles <em>both</em> the single page source editor 
	 * scenario <em>and</em> the multipage editor scenario
	 * @see org.eclipse.ui.IEditorActionDelegate#setActiveEditor(org.eclipse.jface.action.IAction, org.eclipse.ui.IEditorPart)
	 */
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		setEditor(targetEditor);
		if (targetEditor instanceof XMLMultiPageEditorPart) {
		    XMLMultiPageEditorPart editorPart = (XMLMultiPageEditorPart) targetEditor;
		    setTextEditor((StructuredTextEditor) editorPart.getAdapter(ITextEditor.class));
		} else if (targetEditor instanceof StructuredTextEditor)
		{
		    setTextEditor((StructuredTextEditor)targetEditor);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		// Do Nothing
	}

	protected void setEditor(IEditorPart editor) {
		this.editor = editor;
	}

	protected IEditorPart getEditor() {
		return editor;
	}
	
	protected void setTextEditor(StructuredTextEditor textEditor) {
		this.textEditor = textEditor;
	}

	protected StructuredTextEditor getTextEditor() {
		return this.textEditor;
	}
	
	/**
	 * answer whether I have an IEditorPart
	 * @return editor != null
	 */
	protected boolean hasEditor() {
		return editor != null;
	}
	
	/**
	 * answer whether I have an StructuredTextEditor
	 * @return textEditor != null
	 */
	protected boolean hasTextEditor() {
		return textEditor != null;
	}
	
	/**
	 * @return the Display of my textEditor control
	 */
	protected Display getDisplay() {
		if (textEditor == null) return null;
		return textEditor.getTextViewer().getControl().getDisplay();
	}
	
	/**
	 * Run the given Runnable while showing a busy cursor 
	 * in my associated editor
	 * @param runnable
	 */
	protected void runWhileBusy(Runnable runnable) {
		BusyIndicator.showWhile (getDisplay(), runnable);
	}
}
