/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/

package org.eclipse.vtp.internal.dialer;

/**
 * Interface for the listener object used when initializing a dialer instance.
 * 
 * The listener allows the dialer to communicate status messages back to the
 * user. This can be used to maintain logs, update displays, etc. Note that
 * the dialer will be running the software-phone in a separate thread. Thus,
 * the class implementing this interface should use synchronization blocks
 * around any data operations.
 * 
 * @author rjray
 */
public interface IVoipDialerListener {
	/**
	 * Send a message through this listener, to whatever context is using it
	 * to monitor the dialer object. Messages are simple strings.
	 * 
	 * @param message String containing the message string being sent
	 */
	void dialerMessage(String message);
}
