/*******************************************************************************
 * Copyright (c) 2006 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/

package org.eclipse.vtp.launching.tellme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;

/**
 * @author mgreenawalt
 * 
 */
public class GetLogListChange implements Runnable {
	final static int WAIT_SECS = 30;

	final private static SimpleDateFormat time = new SimpleDateFormat(
			"mm:ss.SSS", Locale.getDefault()); //$NON-NLS-1$

	final private static boolean DEBUGGING = TellmePlugin.getDefault()
			.isDebugging();

	public void run() {
		CallState.initLogList();

		final String logList0 = StudioInteractions.getListOfLogs().toString();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e1) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
					"While waiting for log list to start changing", e1));
		}
		StringBuffer logList = null;
		int waitLoops = WAIT_SECS / 2;
		while ((logList = StudioInteractions.getListOfLogs()) != null
				&& logList.toString().equals(logList0) && waitLoops-- != 0) {
			if (DEBUGGING) {
				System.out.println(time.format(new Date())
						+ ": Check for log flow start again."); //$NON-NLS-1$
				System.out.flush();
			}
			try {
				Thread.sleep(2000);
			} catch (InterruptedException e) {
				DebugPlugin.log(new Status(IStatus.ERROR,
						"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
						"Waiting for log to begin flowing", e));
			}
			if (CallState.isStopping()) {
				break;
			}
		}
		if (CallState.isStopping()) {
			CallState.reportLogListFail("Stop button pushed");
			CallState.reportLogFetchFail("");
			synchronized (CallState.getSynch()) {
				CallState.setLogListDone();
				CallState.setLogFetchDone();
				if (CallState.launchDone()){
					CallState.endLaunch();
				}
			}
			return;
		}
		if (waitLoops <= 0) {
			if (DEBUGGING) {
				System.out
						.println("waited too long for log to start streaming"); //$NON-NLS-1$
				System.out.flush();
			}
			CallState.reportLogListFail("No new log for call in " + WAIT_SECS
					+ " seconds");
			CallState.setLogList(null);

		} else {
			CallState.setLogList(logList);
			CallState.reportLogListSucceed("");
		}
		synchronized (CallState.getSynch()) {
			CallState.setLogListDone();
		}
		new GetLogItems().run();
		return;
	}

}
