/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/
package org.eclipse.vtp.launching.tellme;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.TrustManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.vtp.launching.tellme.CallLog;
import org.eclipse.vtp.launching.tellme.LogItemReader;
import org.eclipse.vtp.launching.tellme.TellmeBrowserException;

/**
 * 
 * 
 * @author rjray
 * @author mgreenawalt
 */
public class StudioInteractions {
	// studioURL is path to the studio platform. attached
	protected final static String studioURLpath = "https://studio.tellme.com/mystudio/mystudio.pl";

	protected final static String studioLogListURL = "https://studio.tellme.com/mystudio/loglist.pl";

	protected final static String studioViewLogURL = "https://studio.tellme.com/mystudio/viewlog.pl";

	private final static boolean DEBUGGING = TellmePlugin.getDefault()
			.isDebugging();

	public static void studioScratchpadMode() {
		consumeStudioTransaction(studioURLpath, loginString
				+ "&submit=yes&newmode=1", "Setting Scratchpad mode: ");
	}

	public static void sendApplicationURL(final String appURL) {
		try {
			final String studioURLquery = loginString
					+ "&submit=yes&update.x=100&current_scratchpad_name="
					+ URLEncoder.encode("EclipseVTP", "UTF-8")
					+ "&srv_scratchpad="
					+ URLEncoder.encode(
							"<?xml version=\"1.0\" ?>\n<vxml version=\"2.1\">\n"
									+ "<form>\n<block>\n<goto next=\"" + appURL
									+ "\"/>\n</block>\n</form>\n</vxml>",
							"UTF-8");
			consumeStudioTransaction(studioURLpath, studioURLquery,
					"Sending App URL: ");
		} catch (UnsupportedEncodingException e2) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR,
					"Error encoding URL to UTF-8", e2));
		}
	}

	public static StringBuffer getListOfLogs() {
		return captureStudioTransaction(studioLogListURL, loginString,
				"Getting List of Logs: ");
	}

	public static CallLog getFirstLogFromList(final StringBuffer logList) {
		int startOfViewRef = -1;
		int endOfViewRef = -1;

		startOfViewRef = logList.indexOf("viewlog.pl?sessionid=");
		if (startOfViewRef == -1) {
			DisplayActions.showError("Problem fetching debug log",
					"No list of logs is available from Studio");
			return null;
		}
		endOfViewRef = logList.indexOf("\"", startOfViewRef);
		int callIDRef = logList.indexOf("<td ", endOfViewRef);
		callIDRef = logList.indexOf("<td ", callIDRef + 4);
		final int endcallIDRef = logList.indexOf("<", callIDRef + 4);
		final String callID = logList.substring(callIDRef + 16, endcallIDRef);
		// at this point, startOfViewRef and endOfViewRef determine the log
		// reference
		final String viewlog = logList.substring(startOfViewRef, endOfViewRef);
		final String[] parts = viewlog.split("\\?");
		if (DEBUGGING) {
			System.out
					.println("**************************************************************");
			System.out.println("logviewing info: \n");
			System.out.println(viewlog);
			// for (int k = 0; k < parts.length; k++) {
			// System.out.println("parts[" + k + "]=" + parts[k]);
			// }
		}

		return new CallLog(callID, loginString + "&" + parts[1]);
	}

	public static StringBuffer getTheLog(final CallLog theLog) {
		return (theLog == null) ? new StringBuffer()
				: captureStudioTransaction(studioViewLogURL, theLog
						.getSessionID(), "Getting Log: ");
	}

	public static LogItemReader getLogItemReader(final CallLog theLog)
			throws TellmeBrowserException {
		URL transactionURL = null;
		final String urlQuery = theLog.getSessionID();
		String errormsg = "Getting log input stream: ";
		try {
			transactionURL = new URL(studioViewLogURL);
		} catch (MalformedURLException e1) {
			throw new TellmeBrowserException(e1.getMessage());
		}
		/* sun.net.www.protocol.http. */HttpURLConnection connection;
		try { // make GET request to Studio to set mode to Application URL tab

			final SSLContext sslCon = SSLContext.getInstance("SSL");
			sslCon.init(null, trustAllCerts, new java.security.SecureRandom());
			HttpsURLConnection.setDefaultSSLSocketFactory(sslCon
					.getSocketFactory());

			connection = (/* sun.net.www.protocol.http. */HttpURLConnection) transactionURL
					.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST");
			connection.setUseCaches(false);
			connection.setRequestProperty("Content-type",
					"application/x-www-form-urlencoded");
			connection.setRequestProperty("Content-length", ""
					+ urlQuery.length());

			// send the post data
			final OutputStreamWriter writer = new OutputStreamWriter(connection
					.getOutputStream());
			writer.write(urlQuery);
			writer.flush();
			writer.close();
			final int studioresponse = connection.getResponseCode();
			if (studioresponse != HttpURLConnection.HTTP_OK) {
				final String err = errormsg + connection.getResponseMessage();
				DisplayActions.showError("Failed to connect to Tellme Studio",
						err);

				throw new TellmeBrowserException(err);
			}

			return new LogItemReader(connection.getInputStream());
		} catch (IOException e) {
			errormsg = e.getMessage();
		} catch (NoSuchAlgorithmException e) {
			errormsg = e.getMessage();
		} catch (KeyManagementException e) {
			errormsg = e.getMessage();
		}

		throw new TellmeBrowserException(errormsg);

	}

	// **************************************************************************************
	public void consumeResponsePage(final URLConnection connection) {
		handleResponsePage(connection, false);
	}

	public StringBuffer captureResponsePage(final URLConnection connection) {
		return handleResponsePage(connection, true);
	}

	private static StringBuffer handleResponsePage(
			final URLConnection connection, final boolean keepPage) {
		BufferedReader contentStream;
		final StringWriter contentStore = new StringWriter();

		try {
			contentStream = new BufferedReader(new InputStreamReader(connection
					.getInputStream()));
			// contentStore will wind up containing the html text
			final PrintWriter contentWriter = new PrintWriter(contentStore);

			String line = contentStream.readLine();
			while (line != null) {
				if (keepPage) {
					contentWriter.println(line);
				}
				line = contentStream.readLine();
			}
		} catch (IOException e) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR,
					"IO problem while reading html page from Studio", e));
		}

		return contentStore.getBuffer();
	}

	public static void consumeStudioTransaction(final String urlPath,
			final String urlQuery, final String errmsg) {
		handleStudioTransaction(urlPath, urlQuery, false, errmsg);
	}

	public static StringBuffer captureStudioTransaction(final String urlPath,
			final String urlQuery, final String errmsg) {
		return handleStudioTransaction(urlPath, urlQuery, true, errmsg);
	}

	// Create a trust manager that does not validate certificate chains
	static private TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() {
		public java.security.cert.X509Certificate[] getAcceptedIssuers() {
			return null;
		}

		public void checkClientTrusted(
				final java.security.cert.X509Certificate[] certs,
				final String authType) {
		}

		public void checkServerTrusted(
				final java.security.cert.X509Certificate[] certs,
				final String authType) {
		}
	} };

	// Install the all-trusting trust manager

	protected static StringBuffer handleStudioTransaction(final String urlPath,
			final String urlQuery, final boolean capturePage,
			final String errormsg) {
		URL transactionURL = null;
		try {
			transactionURL = new URL(urlPath);
		} catch (MalformedURLException e1) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR,
					"This better never happen", e1));
		}
		/* sun.net.www.protocol.http. */HttpURLConnection connection;
		try { // make GET request to Studio to set mode to Application URL tab

			final SSLContext sslCon = SSLContext.getInstance("SSL");
			sslCon.init(null, trustAllCerts, new java.security.SecureRandom());
			HttpsURLConnection.setDefaultSSLSocketFactory(sslCon
					.getSocketFactory());

			connection = (/* sun.net.www.protocol.http. */HttpURLConnection) transactionURL
					.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST");
			connection.setUseCaches(false);
			connection.setRequestProperty("Content-type",
					"application/x-www-form-urlencoded");
			connection.setRequestProperty("Content-length", ""
					+ urlQuery.length());

			// send the post data
			final OutputStreamWriter writer = new OutputStreamWriter(connection
					.getOutputStream());
			writer.write(urlQuery);
			writer.flush();
			writer.close();
			final int studioresponse = connection.getResponseCode();
			if (studioresponse != HttpURLConnection.HTTP_OK) {
				final String err = errormsg + connection.getResponseMessage();
				DisplayActions.showError("Failed to connect to Tellme Studio",
						err);

				return null;
			}

			return handleResponsePage(connection, capturePage);
		} catch (IOException e) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR,
					"Error while trying to read html from Studio", e));
		} catch (NoSuchAlgorithmException e) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR,
					"Error while trying to read html from Studio", e));
		} catch (KeyManagementException e) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR,
					"Error while trying to read html from Studio", e));
		}

		return null;
	}

	protected static void setLogin(final String loginstring) {
		loginString = loginstring;
	}

	private static String loginString = "";

}
