package org.eclipse.vtp.launching.tellme.config;

/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/

public interface ITellmeVoiceXMLBrowserConstants {
    /**
     * Property identifying the Studio phone number to use.
     */
    String STUDIO_PHONE = "org.eclipse.vtp.launching.tellme.studio_phone";

    /**
     * Property for Launch Configuration to specify the ID of the developer
     * using the Tellme Studio
     */
    String DEVELOPER_ID = "org.eclipse.vtp.launching.tellme.devID";

    /**
     * Property for Launch Configuration to specify the PIN number of the
     * developer using the Tellme Studio
     */

    String DEVELOPER_PIN = "org.eclipse.vtp.launching.tellme.devPIN";
    
    /**
     * Property for Launch Configuration to specify the email login name
     * of the user on Studio web page
     */
    String DEVELOPER_EMAIL = "org.eclipse.vtp.launching.tellme.devEMAIL";
    
    /**
     * Property for Launch Configuration to specify the password
     * of the user on Studio web page
     */
    String DEVELOPER_PSWD = "org.eclipse.vtp.launching.tellme.devPSWD";
    
    /**
     * Property for Launch Configuration to specify the password
     * of the user on Studio web page
     */
    String NO_AUTO_LOGIN = "org.eclipse.vtp.launching.tellme.devNoAutoLogin";
       
}
