package org.eclipse.vtp.catalog;
/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class CatalogPlugin extends AbstractUIPlugin {

	/**
	 * Plugin ID 
	 */
	public static final String ID = "org.eclipse.vtp.catalog"; //$NON-NLS-1$

	/**
	 * The shared instance.
	 */ 
	private static CatalogPlugin plugin;

	/**
	 * The constructor.
	 */
	public CatalogPlugin() {
		super();
		plugin = this;
	}

	/**
	 * This method is called when the plug-in is stopped
	 * @param context the BundleContext
	 * @throws Exception because the super implementation does
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 * @return the singleton instance
	 */
	public static CatalogPlugin getDefault() {
		return plugin;
	}

	/**
	 * Get Icon from the image registry
	 * @param iconName relative path name of the icon
	 * @return the resulting Image
	 */
	public Image getImage(String iconName) {
		ImageRegistry imageRegistry = getImageRegistry();

		if (imageRegistry.get(iconName) != null) {
			return imageRegistry.get(iconName);
		} else {
			imageRegistry.put(iconName, ImageDescriptor.createFromFile(
					getClass(), iconName));
			return imageRegistry.get(iconName);
		}
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
	}
	
	
}
