/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/
package org.eclipse.vtp.dialer.skype;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.eclipse.vtp.internal.dialer.IVoipDialer;
import org.eclipse.vtp.internal.dialer.IVoipDialerFactory;
import org.eclipse.vtp.internal.dialer.VoipDialerException;

/**
 * Factory class to provide object instances that implement the IVoipDialer
 * interface to classes loading this plug-in.
 * 
 * @author rjray
 */
public class SkypeDialerFactory implements IVoipDialerFactory {
	private final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS",		//$NON-NLS-1$
			Locale.getDefault());

	private static final boolean DEBUGGING = SkypePlugin.getDefault()
			.isDebugging();

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.vtp.dialer.IVoipDialerFactory#getDialer()
	 */
	public IVoipDialer getDialer() throws VoipDialerException {
		final IVoipDialer dialer = SkypeDialer.instance();
		if (DEBUGGING) {
			System.out.println(time.format(new Date()) + ": SkypeDialerFactory.getDialer() called");		//$NON-NLS-1$
			System.out.flush();
		}
		dialer.initialize();
		return dialer;
	}
}
