/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Jens Lukowski/Innoopract - initial renaming/restructuring
 *     
 *******************************************************************************/
package org.eclipse.vtp.editor.ccxml.ui.internal.actions;

import org.eclipse.vtp.editor.actions.ActionContributorXML;



/**
 * XMLEditorActionContributor
 * 
 * This class should not be used inside multi page editor's
 * ActionBarContributor, since cascaded init() call from the
 * ActionBarContributor will causes exception and it leads to lose whole
 * toolbars.
 * 
 * Instead, use SourcePageActionContributor for source page contributor of
 * multi page editor.
 * 
 * Note that this class is still valid for single page editor.
 */
public class ActionContributorCCXML extends ActionContributorXML {
	private static final String[] EDITOR_IDS = {"org.eclipse.core.runtime.ccxml.source3", "org.eclipse.core.runtime.ccxml.source4"}; //$NON-NLS-1$ //$NON-NLS-2$

	public ActionContributorCCXML() {
		super();
	}
	

	protected String[] getExtensionIDs() {
		return EDITOR_IDS;
	}	
}
