package org.eclipse.vtp.editor.srgxml.ui.internal.wizards;
/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.vtp.catalog.registry.CatalogDefaultResolver;
import org.eclipse.vtp.catalog.registry.CatalogEntry;
import org.eclipse.vtp.editor.srgxml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.vtp.editor.wizards.NewModelWizard;




public class NewSRGXMLModelWizard extends NewModelWizard
{

	  /**
	   * StartPage
	   */
	  public class SRGXMLStartPage extends StartPage
	  {

	    public SRGXMLStartPage(String pageName, String[] radioButtonLabel)
	    {
	      super(pageName, radioButtonLabel);
	      this.radioButtonLabel = radioButtonLabel;
	      radioButton = new Button[radioButtonLabel.length];
	    }

	    
//	  CN - Get Default DTD based on Preference Page     
	  	public String getDefaultDTD() {
			CatalogEntry dtd = CatalogDefaultResolver.getDefaultEntryForContentType("org.eclipse.vtp.editor.srgxml.core.srgxmlsource"); //$NON-NLS-1$
			if (dtd.getWebURL() != null)
				return dtd.getWebURL();
			else
				return dtd.getURI();
	  	}   
	  }	
	
  /**
   *  NewFilePage
   */
  public class NewSRGXMLFilePage extends NewFilePage
  {
	    public String defaultName = "NewFile"; //$NON-NLS-1$
	    public String defaultFileExtension = ".grxml"; //$NON-NLS-1$
	    public String[] filterExtensions = { "*.txt"}; //$NON-NLS-1$
		private List fValidExtensions = null;
		public String contentType = ContentTypeIdForXML.ContentTypeID_SRGXML;

	    public NewSRGXMLFilePage(IStructuredSelection selection)
	    {
	      super(selection); //$NON-NLS-1$
	    }	  

	    protected String computeDefaultFileName()
	    {
	      int count = 0;
	      String fileName = defaultName + defaultFileExtension;
	      IPath containerFullPath = getContainerFullPath();
	      if (containerFullPath != null)
	      {
	        while (true)
	        {
	          IPath path = containerFullPath.append(fileName);
	          if (ResourcesPlugin.getWorkspace().getRoot().exists(path))
	          {
	            count++;
	            fileName = defaultName + count + defaultFileExtension;
	          }
	          else
	          {
	            break;
	          }
	        }
	      }
	      return fileName;
	    }

// CN This is needed to make sure that we get the proper Error messages	    
	    protected boolean validatePage() {
			String fullFileName = getFileName();
			String fileExtension = (new Path(fullFileName)).getFileExtension();
			if (fileExtension != null && (!getValidExtensions().contains(fileExtension))) {
				setErrorMessage(XMLWizardsMessages._ERROR_BAD_FILENAME_EXTENSION);
				return false;
			}
			// no fileExtension, let's check for this file with an .lxml
			// extension
			fullFileName += defaultFileExtension; //$NON-NLS-1$
			if ((getContainerFullPath() != null) && (getContainerFullPath().isEmpty() == false) && (getFileName().compareTo("") != 0)) //$NON-NLS-1$
			{
				Path fullPath = new Path(getContainerFullPath().toString() + '/' + fullFileName);
				IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath);
				if (resource != null) {
					setErrorMessage(XMLWizardsMessages._ERROR_FILE_ALREADY_EXISTS);
					return false;
				}
			}

			// check for file should be case insensitive
			String sameName = existsFileAnyCase(fullFileName);
			if (sameName != null) {
				//ISSUE: is qualitifedFileName not needed, or is it supposed to be used in error message?
				//String qualifiedFileName = getContainerFullPath().toString() + '/' + fullFileName;
				setErrorMessage(XMLWizardsMessages._ERROR_FILE_ALREADY_EXISTS + " " + sameName); //$NON-NLS-1$
				return false;
			}

			return super.validatePage();
		}	    
    
	    
	/**
	 * Get list of valid extensions for XML Content type
	 * 
	 * @return List
	 */
	public List getValidExtensions() {
		if (fValidExtensions == null) {
			IContentType type = Platform.getContentTypeManager().getContentType(contentType);
			fValidExtensions = new ArrayList(Arrays.asList(type.getFileSpecs(IContentType.FILE_EXTENSION_SPEC)));
		}
		return fValidExtensions;
	}
  }
  
}

