package org.eclipse.vtp.catalog.nls;
/*******************************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/


import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.vtp.catalog.Logger;


/**
 * Utility class to access externalized (translatable) strings
 * 
 */
public final class CatalogResourceHandler {

	/**
	 * plugin id for the online documentation
	 */
	public static final String DOC_ROOT = "org.eclipse.vtp.doc"; //$NON-NLS-1$
	
	/**
	 * cached instance
	 */
	private static ResourceBundle fgResourceBundle;
	
	/**
	 * Name of resource bundle
	 */
	public static final String RESOURCE_BUNDLE = "org.eclipse.vtp.catalog.nls.CatalogResources";  //$NON-NLS-1$

	/**
	 * Hide constructor
	 */
	private CatalogResourceHandler() { }
	
	/**
	 * Returns the resource bundle used by all classes in this Project
	 * @return The resource bundle for this plugin
	 */
	public static ResourceBundle getResourceBundle() {
		try {
			return ResourceBundle.getBundle(RESOURCE_BUNDLE);
		} catch (MissingResourceException e) {
			Logger.logException(e);
		}
		return null;
	}

	/**
	 * Look up the value of the given key in this plugin's resource bundle
	 * @param key	property name
	 * @return	value if found, or !key! if not found
	 */
	public static String getString(String key) {
		if (fgResourceBundle == null) {
			fgResourceBundle = getResourceBundle();
		}

		if (fgResourceBundle != null) {
			try {
				return fgResourceBundle.getString(key);
			} catch (MissingResourceException e) {
				return "!" + key + "!"; //$NON-NLS-2$//$NON-NLS-1$
			}
		} else {
			return "!" + key + "!"; //$NON-NLS-2$//$NON-NLS-1$
		}
	}

	/**
	 * Use MessageFormat to substitute parameters in the property value
	 * @param key		key to look up using getString(String)
	 * @param args		objects to replace parameters with 
	 * @return formatted message with parameters replaced
	 * @see java.text.MessageFormat
	 */
	public static String getString(String key, Object[] args) {

		try {
			return MessageFormat.format(getString(key), args);
		} catch (IllegalArgumentException e) {
			return getString(key);
		}

	}
}