/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EvaluationContextManager
implements IWindowListener,
IDebugContextListener {
    private static EvaluationContextManager fgManager;
    private static final String DEBUGGER_ACTIVE;
    private static final String INSTANCE_OF_IJAVA_STACK_FRAME;
    private Map fContextsByPage = null;
    private IWorkbenchWindow fActiveWindow;
    static /* synthetic */ Class class$0;

    static {
        DEBUGGER_ACTIVE = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".debuggerActive";
        INSTANCE_OF_IJAVA_STACK_FRAME = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".instanceof.IJavaStackFrame";
    }

    private EvaluationContextManager() {
        DebugContextManager.getDefault().addDebugContextListener((IDebugContextListener)this);
    }

    public static void startup() {
        Runnable r = new Runnable(){

            public void run() {
                if (fgManager == null) {
                    fgManager = new EvaluationContextManager(null);
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        fgManager.windowOpened(windows[i]);
                        ++i;
                    }
                    workbench.addWindowListener((IWindowListener)fgManager);
                    fgManager.fActiveWindow = workbench.getActiveWorkbenchWindow();
                }
            }
        };
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.fActiveWindow = window;
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    private void setContext(IWorkbenchPage page, IJavaStackFrame frame, boolean instOf) {
        if (this.fContextsByPage == null) {
            this.fContextsByPage = new HashMap();
        }
        this.fContextsByPage.put(page, frame);
        System.setProperty(DEBUGGER_ACTIVE, "true");
        if (instOf) {
            System.setProperty(INSTANCE_OF_IJAVA_STACK_FRAME, "true");
        } else {
            System.setProperty(INSTANCE_OF_IJAVA_STACK_FRAME, "false");
        }
    }

    private void removeContext(IWorkbenchPage page) {
        if (this.fContextsByPage != null) {
            this.fContextsByPage.remove(page);
            if (this.fContextsByPage.isEmpty()) {
                System.setProperty(DEBUGGER_ACTIVE, "false");
                System.setProperty(INSTANCE_OF_IJAVA_STACK_FRAME, "false");
            }
        }
    }

    private static IJavaStackFrame getContext(IWorkbenchPage page) {
        if (fgManager != null && EvaluationContextManager.fgManager.fContextsByPage != null) {
            return (IJavaStackFrame)EvaluationContextManager.fgManager.fContextsByPage.get(page);
        }
        return null;
    }

    public static IJavaStackFrame getEvaluationContext(IWorkbenchPart part) {
        IWorkbenchPage page = part.getSite().getPage();
        IJavaStackFrame frame = EvaluationContextManager.getContext(page);
        if (frame == null) {
            return EvaluationContextManager.getEvaluationContext(page.getWorkbenchWindow());
        }
        return frame;
    }

    public static IJavaStackFrame getEvaluationContext(IWorkbenchWindow window) {
        ArrayList alreadyVisited = new ArrayList();
        if (window == null) {
            window = EvaluationContextManager.fgManager.fActiveWindow;
        }
        return EvaluationContextManager.getEvaluationContext(window, alreadyVisited);
    }

    private static IJavaStackFrame getEvaluationContext(IWorkbenchWindow window, List alreadyVisited) {
        IWorkbenchPage activePage = window.getActivePage();
        IJavaStackFrame frame = null;
        if (activePage != null) {
            frame = EvaluationContextManager.getContext(activePage);
        }
        if (frame == null) {
            IWorkbenchPage[] pages = window.getPages();
            int i = 0;
            while (i < pages.length) {
                if (activePage != pages[i] && (frame = EvaluationContextManager.getContext(pages[i])) != null) {
                    return frame;
                }
                ++i;
            }
            alreadyVisited.add(window);
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i2 = 0;
            while (i2 < windows.length) {
                if (!alreadyVisited.contains(windows[i2]) && (frame = EvaluationContextManager.getEvaluationContext(windows[i2], alreadyVisited)) != null) {
                    return frame;
                }
                ++i2;
            }
            return null;
        }
        return frame;
    }

    public void contextActivated(ISelection selection, IWorkbenchPart part) {
        if (part != null) {
            Object element;
            IStructuredSelection ss;
            IWorkbenchPage page = part.getSite().getPage();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
                boolean instOf;
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IJavaStackFrame frame = (IJavaStackFrame)iAdaptable.getAdapter((Class)clazz);
                boolean bl = instOf = element instanceof IJavaStackFrame || element instanceof IJavaThread;
                if (frame != null && frame.getLaunch().getAttribute(ScrapbookLauncher.SCRAPBOOK_LAUNCH) == null) {
                    this.setContext(page, frame, instOf);
                    return;
                }
            }
            this.removeContext(page);
        }
    }

    public void contextChanged(ISelection selection, IWorkbenchPart part) {
    }

    /* synthetic */ EvaluationContextManager(EvaluationContextManager evaluationContextManager) {
        this();
    }
}

