/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class BreakpointLocationVerifierJob
extends Job {
    private IDocument fDocument;
    private IJavaLineBreakpoint fBreakpoint;
    private int fLineNumber;
    private String fTypeName;
    private IType fType;
    private boolean fBestMatch;
    private IResource fResource;
    private IEditorPart fEditorPart;
    private IEditorStatusLine fStatusLine;
    static /* synthetic */ Class class$0;

    public BreakpointLocationVerifierJob(IDocument document, IJavaLineBreakpoint breakpoint, int lineNumber, boolean bestMatch, String typeName, IType type, IResource resource, IEditorPart editorPart) {
        super(ActionMessages.BreakpointLocationVerifierJob_breakpoint_location);
        this.fDocument = document;
        this.fBreakpoint = breakpoint;
        this.fLineNumber = lineNumber;
        this.fBestMatch = bestMatch;
        this.fTypeName = typeName;
        this.fType = type;
        this.fResource = resource;
        this.fEditorPart = editorPart;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fStatusLine = (IEditorStatusLine)editorPart.getAdapter((Class)clazz);
        this.setSystem(true);
    }

    public IStatus run(IProgressMonitor monitor) {
        ASTParser parser = ASTParser.newParser((int)3);
        char[] source = this.fDocument.get().toCharArray();
        parser.setSource(source);
        IJavaElement javaElement = JavaCore.create((IResource)this.fResource);
        IJavaProject project = null;
        if (javaElement != null) {
            Hashtable options = JavaCore.getDefaultOptions();
            project = javaElement.getJavaProject();
            String compilerCompliance = "1.5";
            String compilerSource = "1.5";
            if (project != null) {
                compilerCompliance = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
                compilerSource = project.getOption("org.eclipse.jdt.core.compiler.source", true);
            }
            options.put("org.eclipse.jdt.core.compiler.compliance", compilerCompliance);
            options.put("org.eclipse.jdt.core.compiler.source", compilerSource);
            parser.setCompilerOptions((Map)options);
        }
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
        ValidBreakpointLocationLocator locator = new ValidBreakpointLocationLocator(compilationUnit, this.fLineNumber, false, this.fBestMatch);
        compilationUnit.accept((ASTVisitor)locator);
        if (locator.isBindingsRequired() && javaElement != null) {
            String unitName = null;
            if (this.fType == null) {
                String name = this.fResource.getName();
                if (JavaCore.isJavaLikeFileName((String)name)) {
                    unitName = name;
                }
            } else if (this.fType.isBinary()) {
                String className = this.fType.getClassFile().getElementName();
                int nameLength = className.indexOf(36);
                if (nameLength < 0) {
                    nameLength = className.indexOf(46);
                }
                unitName = String.valueOf(className.substring(0, nameLength)) + ".java";
            } else {
                unitName = this.fType.getCompilationUnit().getElementName();
            }
            if (unitName != null) {
                parser = ASTParser.newParser((int)3);
                parser.setSource(source);
                parser.setProject(project);
                parser.setUnitName(unitName);
                parser.setResolveBindings(true);
                compilationUnit = (CompilationUnit)parser.createAST(null);
                locator = new ValidBreakpointLocationLocator(compilationUnit, this.fLineNumber, true, this.fBestMatch);
                compilationUnit.accept((ASTVisitor)locator);
            }
        }
        int lineNumber = locator.getLineLocation();
        String typeName = locator.getFullyQualifiedTypeName();
        try {
            switch (locator.getLocationType()) {
                case 1: {
                    return this.manageLineBreakpoint(typeName, lineNumber);
                }
                case 2: {
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    new ToggleBreakpointAdapter().toggleMethodBreakpoints((IWorkbenchPart)this.fEditorPart, (ISelection)new TextSelection(locator.getMemberOffset(), 0));
                    break;
                }
                case 3: {
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    new ToggleBreakpointAdapter().toggleWatchpoints((IWorkbenchPart)this.fEditorPart, (ISelection)new TextSelection(locator.getMemberOffset(), 0));
                    break;
                }
                default: {
                    this.report(ActionMessages.BreakpointLocationVerifierJob_not_valid_location);
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                }
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
    }

    public IStatus manageLineBreakpoint(String typeName, int lineNumber) {
        try {
            boolean breakpointExist;
            boolean differentLineNumber = lineNumber != this.fLineNumber;
            IJavaLineBreakpoint breakpoint = JDIDebugModel.lineBreakpointExists((IResource)this.fResource, (String)typeName, (int)lineNumber);
            boolean bl = breakpointExist = breakpoint != null;
            if (this.fBreakpoint == null) {
                if (breakpointExist) {
                    if (differentLineNumber) {
                        this.report(ActionMessages.BreakpointLocationVerifierJob_not_valid_location);
                        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                    }
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpointRemoved, null);
                }
                this.createNewBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
            }
            if (differentLineNumber) {
                if (breakpointExist) {
                    this.report(ActionMessages.BreakpointLocationVerifierJob_not_valid_location);
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                }
                this.replaceBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.BreakpointLocationVerifierJob_breakpointMovedToValidPosition, null);
            }
            if (!typeName.equals(this.fTypeName)) {
                this.replaceBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.BreakpointLocationVerifierJob_breakpointSetToRightType, null);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
    }

    private void replaceBreakpoint(int lineNumber, String typeName) throws CoreException {
        this.createNewBreakpoint(lineNumber, typeName);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
    }

    private void createNewBreakpoint(int lineNumber, String typeName) throws CoreException {
        HashMap newAttributes = new HashMap(10);
        if (this.fType != null) {
            try {
                IRegion line = this.fDocument.getLineInformation(lineNumber - 1);
                int start = line.getOffset();
                int end = start + line.getLength() - 1;
                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(newAttributes, (IJavaElement)this.fType, start, end);
            }
            catch (BadLocationException ble) {
                JDIDebugUIPlugin.log(ble);
            }
        }
        JDIDebugModel.createLineBreakpoint((IResource)this.fResource, (String)typeName, (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, newAttributes);
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (BreakpointLocationVerifierJob.this.fStatusLine != null) {
                    BreakpointLocationVerifierJob.this.fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }
}

