/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.dialogs.SelectionDialog;

public class AddClassPrepareBreakpointAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow workbenchWindow;

    private void createBreakpoints(Object[] selection) {
        try {
            int i = 0;
            while (i < selection.length) {
                final IType type = (IType)selection[i];
                final IResource resource = BreakpointUtils.getBreakpointResource((IMember)type);
                final HashMap map = new HashMap(10);
                BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)type);
                int kind = 0;
                if (!type.isClass()) {
                    kind = 1;
                }
                IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
                boolean exists = false;
                int j = 0;
                while (j < breakpoints.length) {
                    IJavaBreakpoint breakpoint = (IJavaBreakpoint)breakpoints[j];
                    if (breakpoint instanceof IJavaClassPrepareBreakpoint && breakpoint.getTypeName().equals(type.getFullyQualifiedName())) {
                        exists = true;
                        break;
                    }
                    ++j;
                }
                if (!exists) {
                    ISourceRange range = type.getNameRange();
                    int start = -1;
                    int end = -1;
                    if (range != null) {
                        start = range.getOffset();
                        end = start + range.getLength();
                    }
                    final int finalKind = kind;
                    final int finalStart = start;
                    final int finalEnd = end;
                    new Job(BreakpointMessages.AddClassPrepareBreakpointAction_2){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                JDIDebugModel.createClassPrepareBreakpoint((IResource)resource, (String)type.getFullyQualifiedName(), (int)finalKind, (int)finalStart, (int)finalEnd, (boolean)true, (Map)map);
                                return Status.OK_STATUS;
                            }
                            catch (CoreException e) {
                                return e.getStatus();
                            }
                        }
                    }.schedule();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(BreakpointMessages.AddClassPrepareBreakpointAction_3, e.getStatus());
        }
    }

    public void run(IAction action) {
        Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)this.workbenchWindow, (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)true, (String)"", null);
            dialog.setTitle(BreakpointMessages.AddClassPrepareBreakpointAction_0);
            dialog.setMessage(BreakpointMessages.AddClassPrepareBreakpointAction_1);
            if (dialog.open() == 0) {
                this.createBreakpoints(dialog.getResult());
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        this.workbenchWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.workbenchWindow = window;
    }
}

