/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchShortcut;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableContext;

public class JavaApplicationLaunchShortcut
extends JavaLaunchShortcut {
    static /* synthetic */ Class class$0;

    private IJavaElement[] getJavaElements(Object[] objects) {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IAdaptable) {
                IJavaElement element;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    IType type;
                    if (element instanceof IMember && (type = ((IMember)element).getDeclaringType()) != null) {
                        element = type;
                    }
                    list.add(element);
                }
            }
            ++i;
        }
        return list.toArray(new IJavaElement[list.size()]);
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setMappedResources(new IResource[]{type.getJavaProject().getProject()});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            this.reportErorr(exception);
        }
        return config;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
    }

    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        try {
            IJavaElement[] javaElements = this.getJavaElements(elements);
            MainMethodSearchEngine engine = new MainMethodSearchEngine();
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (boolean)false);
            return engine.searchMainMethods(context, scope, true);
        }
        catch (InvocationTargetException e) {
            throw (CoreException)e.getTargetException();
        }
    }

    protected String getTypeSelectionTitle() {
        return LauncherMessages.JavaApplicationLaunchShortcut_0;
    }

    protected String getEditorEmptyMessage() {
        return LauncherMessages.JavaApplicationLaunchShortcut_1;
    }

    protected String getSelectionEmptyMessage() {
        return LauncherMessages.JavaApplicationLaunchShortcut_2;
    }
}

