/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.languages.en;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import org.eclipse.vtp.framework.media.language.DefaultTranslator;
import org.eclipse.vtp.framework.media.language.TranslatorOutput;

public class EnglishTranslator
extends DefaultTranslator {
    private static final String ORDINALS_GROUP = "Ordinals";
    private static final String COMMON_GROUP = "Common";
    private static final String MONEY_GROUP = "Money";
    private static final String TIME_GROUP = "Time";
    private static final String NUMBERS_GROUP = "Numbers";
    private static final String MONTHS_GROUP = "Months";
    private static final String DAYS_GROUP = "Days";
    private static final String AND = "And";
    private static final String[] DAYS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String AM = "a.m.";
    private static final String PM = "p.m.";
    private static final Currency USD_CURRENCY = Currency.getInstance("USD");
    private static final BigDecimal ZERO = new BigDecimal("0");
    private static final BigDecimal NEGATIVE_ONE = new BigDecimal("-1");
    private static final String DOLLAR = "Dollar";
    private static final String DOLLARS = "Dollars";
    private static final String CENT = "Cent";
    private static final String CENTS = "Cents";
    private static final String NEGATIVE = "Negative";
    private static final String HUNDRED = "Hundred";
    private static final String THOUSAND = "Thousand";
    private static final String MILLION = "Million";
    private static final String BILLION = "Billion";
    private static final String HUNDREDTH = "Hundredth";
    private static final String THOUSANDTH = "Thousandth";
    private static final String MILLIONTH = "Millionth";
    private static final String BILLIONTH = "Billionth";
    static /* synthetic */ Class class$0;

    public static URL getDescriptor() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.framework.languages.en.EnglishTranslator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResource("/META-INF/openVXML/language.xml");
    }

    public void translateDate(Date date, Locale locale, TranslatorOutput out) {
        Calendar cal = Calendar.getInstance(locale);
        cal.setTime(date);
        out.prompt(DAYS[cal.get(7) - 1], DAYS_GROUP);
        out.prompt(MONTHS[cal.get(2)], MONTHS_GROUP);
        this.translateOrdinal(cal.get(5), locale, out);
        int year = cal.get(1);
        if (year < 1000 || year % 1000 < 100) {
            this.translateNumber(year, locale, out);
        } else {
            this.translateNumber(year / 100, locale, out);
            if (year % 100 < 10) {
                out.prompt(HUNDRED, NUMBERS_GROUP);
            }
            this.translateNumber(year % 100, locale, out);
        }
    }

    public void translateTime(Date time, boolean showTimeZone, Locale locale, TranslatorOutput out) {
        Calendar cal = Calendar.getInstance(locale);
        cal.setTime(time);
        int hour = cal.get(10);
        this.translateNumber(hour == 0 ? 12 : hour, locale, out);
        int minute = cal.get(12);
        if (minute > 0) {
            this.translateNumber(minute, locale, out);
        }
        out.prompt(cal.get(9) == 0 ? AM : PM, TIME_GROUP);
        if (showTimeZone) {
            out.characters(cal.getTimeZone().getID());
        }
    }

    public void translateMoney(BigDecimal money, Currency currency, Locale locale, TranslatorOutput out) {
        if (USD_CURRENCY.equals(currency)) {
            int cents;
            if (money.compareTo(ZERO) < 0) {
                out.prompt(NEGATIVE, NUMBERS_GROUP);
                money = money.multiply(NEGATIVE_ONE);
            }
            this.translateNumber(money.intValue(), locale, out);
            out.prompt(money.intValue() == 1 ? DOLLAR : DOLLARS, MONEY_GROUP);
            String str = money.toString();
            if (str.indexOf(46) >= 0 && (cents = Integer.parseInt(str.substring(str.indexOf(46) + 1))) > 0) {
                out.prompt(AND, COMMON_GROUP);
                this.translateNumber(cents, locale, out);
                out.prompt(cents == 1 ? CENT : CENTS, MONEY_GROUP);
            }
        } else {
            super.translateMoney(money, currency, locale, out);
        }
    }

    public void translateNumber(int number, Locale locale, TranslatorOutput out) {
        int thousands;
        int millions;
        int billions;
        if (number == 0) {
            out.prompt("0", NUMBERS_GROUP);
            return;
        }
        if (number < 0) {
            out.prompt(NEGATIVE, NUMBERS_GROUP);
            number *= -1;
        }
        if ((billions = number / 1000000000) > 0) {
            this.translateNumberInHundreds(billions, locale, out);
            out.prompt(BILLION, NUMBERS_GROUP);
            number -= billions * 1000000000;
        }
        if ((millions = number / 1000000) > 0) {
            this.translateNumberInHundreds(millions, locale, out);
            out.prompt(MILLION, NUMBERS_GROUP);
            number -= millions * 1000000;
        }
        if ((thousands = number / 1000) > 0) {
            this.translateNumberInHundreds(thousands, locale, out);
            out.prompt(THOUSAND, NUMBERS_GROUP);
            number -= thousands * 1000;
        }
        if (number > 0) {
            this.translateNumberInHundreds(number, locale, out);
        }
    }

    public void translateOrdinal(int ordinal, Locale locale, TranslatorOutput out) {
        int hundreds;
        int thousands;
        int millions;
        int billions;
        if (ordinal == 0) {
            out.prompt("0th", ORDINALS_GROUP);
            return;
        }
        if (ordinal < 0) {
            out.prompt(NEGATIVE, NUMBERS_GROUP);
            ordinal *= -1;
        }
        if ((billions = ordinal / 1000000000) > 0) {
            this.translateNumberInHundreds(billions, locale, out);
            if ((ordinal -= billions * 1000000000) == 0) {
                out.prompt(BILLIONTH, ORDINALS_GROUP);
            } else {
                out.prompt(BILLION, NUMBERS_GROUP);
            }
        }
        if ((millions = ordinal / 1000000) > 0) {
            this.translateNumberInHundreds(millions, locale, out);
            if ((ordinal -= millions * 1000000) == 0) {
                out.prompt(MILLIONTH, ORDINALS_GROUP);
            } else {
                out.prompt(MILLION, NUMBERS_GROUP);
            }
        }
        if ((thousands = ordinal / 1000) > 0) {
            this.translateNumberInHundreds(thousands, locale, out);
            if ((ordinal -= thousands * 1000) == 0) {
                out.prompt(THOUSANDTH, ORDINALS_GROUP);
            } else {
                out.prompt(THOUSAND, NUMBERS_GROUP);
            }
        }
        if ((hundreds = ordinal / 100) > 0) {
            this.translateNumberInHundreds(hundreds, locale, out);
            if ((ordinal -= hundreds * 100) == 0) {
                out.prompt(HUNDREDTH, ORDINALS_GROUP);
            } else {
                out.prompt(HUNDRED, NUMBERS_GROUP);
            }
        }
        if (ordinal % 10 == 0) {
            out.prompt(String.valueOf(String.valueOf(ordinal)) + "th", ORDINALS_GROUP);
        } else {
            int tens = ordinal / 10;
            if (tens > 1) {
                this.translateNumberInHundreds(tens * 10, locale, out);
                ordinal -= tens * 10;
            }
            switch (ordinal - ordinal / 10) {
                case 1: {
                    out.prompt("1st", ORDINALS_GROUP);
                    break;
                }
                case 2: {
                    out.prompt("2nd", ORDINALS_GROUP);
                    break;
                }
                case 3: {
                    out.prompt("3rd", ORDINALS_GROUP);
                    break;
                }
                default: {
                    out.prompt(String.valueOf(String.valueOf(ordinal)) + "th", ORDINALS_GROUP);
                }
            }
        }
    }

    public void translateLetter(char letter, Locale locale, TranslatorOutput out) {
        if (Character.isWhitespace(letter)) {
            return;
        }
        out.text(" ");
        if (Character.isDigit(letter)) {
            this.translateNumber(Integer.parseInt(String.valueOf(letter)), locale, out);
            return;
        }
        out.prompt(String.valueOf(letter).toLowerCase(locale), "Letters");
        out.text(" ");
    }

    private void translateNumberInHundreds(int number, Locale locale, TranslatorOutput out) {
        int hundreds = number / 100;
        if (hundreds > 0) {
            out.prompt(String.valueOf(hundreds), NUMBERS_GROUP);
            out.prompt(HUNDRED, NUMBERS_GROUP);
            number -= hundreds * 100;
        }
        if (number > 19) {
            out.prompt(String.valueOf(number - number % 10), NUMBERS_GROUP);
            number %= 10;
        }
        if (number > 0) {
            out.prompt(String.valueOf(number), NUMBERS_GROUP);
        }
    }
}

