/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.internal.validation;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.html.core.internal.Logger;
import org.eclipse.wst.html.core.internal.validate.HTMLValidationAdapterFactory;
import org.eclipse.wst.html.internal.validation.HTMLValidationReporter;
import org.eclipse.wst.html.internal.validation.HTMLValidationResult;
import org.eclipse.wst.html.internal.validation.LocalizedMessage;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Text;

public class HTMLValidator
implements IValidatorJob,
ISourceValidator {
    private static final String ORG_ECLIPSE_JST_JSP_CORE_JSPSOURCE = "org.eclipse.jst.jsp.core.jspsource";
    private static final String ORG_ECLIPSE_WST_HTML_CORE_HTMLSOURCE = "org.eclipse.wst.html.core.htmlsource";
    private IDocument fDocument;
    static /* synthetic */ Class class$0;

    static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && (resource.getName().charAt(0) != '.' || resource.getType() != 2)) continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void cleanup(IReporter reporter) {
    }

    protected IDOMModel getModel(IProject project, IFile file) {
        if (project == null || file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (!this.canHandle(file)) {
            return null;
        }
        IStructuredModel model = null;
        IModelManager manager = StructuredModelManager.getModelManager();
        try {
            try {
                model = manager.getModelForRead(file);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                model = manager.getModelForRead(file, new String(), null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
        if (model == null) {
            return null;
        }
        if (!(model instanceof IDOMModel)) {
            this.releaseModel(model);
            return null;
        }
        return (IDOMModel)model;
    }

    protected HTMLValidationReporter getReporter(IReporter reporter, IFile file, IDOMModel model) {
        return new HTMLValidationReporter((IValidator)this, reporter, file, (IStructuredModel)model);
    }

    private boolean canHandle(IFile file) {
        boolean result = false;
        if (file != null) {
            try {
                IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                IContentDescription contentDescription = file.getContentDescription();
                IContentType htmlContentType = contentTypeManager.getContentType(ORG_ECLIPSE_WST_HTML_CORE_HTMLSOURCE);
                if (contentDescription != null) {
                    IContentType fileContentType = contentDescription.getContentType();
                    if (htmlContentType != null) {
                        if (fileContentType.isKindOf(htmlContentType)) {
                            result = true;
                        } else {
                            IContentType jspContentType = contentTypeManager.getContentType(ORG_ECLIPSE_JST_JSP_CORE_JSPSOURCE);
                            if (jspContentType != null) {
                                result = fileContentType.isKindOf(jspContentType);
                            }
                        }
                    }
                } else if (htmlContentType != null) {
                    result = htmlContentType.isAssociatedWith(file.getName());
                }
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    private boolean hasHTMLFeature(IDOMDocument document) {
        DocumentTypeAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (DocumentTypeAdapter)document.getAdapterFor((Object)clazz)) == null) {
            return false;
        }
        return adapter.hasFeature("HTML");
    }

    protected void releaseModel(IStructuredModel model) {
        if (model != null) {
            model.releaseFromRead();
        }
    }

    public void validate(IValidationContext helper, IReporter reporter) {
        if (helper == null) {
            return;
        }
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        String[] deltaArray = helper.getURIs();
        if (deltaArray != null && deltaArray.length > 0) {
            this.validateDelta(helper, reporter);
        } else {
            this.validateFull(helper, reporter);
        }
    }

    /*
     * Exception decompiling
     */
    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 383->387)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private IndexedRegion getCoveringNode(IRegion dirtyRegion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 87->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IndexedRegion getLargest(IStructuredDocumentRegion[] sdRegions) {
        if (sdRegions == null || sdRegions.length == 0) {
            return null;
        }
        IndexedRegion currentLargest = this.getCorrespondingNode(sdRegions[0]);
        int i = 0;
        while (i < sdRegions.length) {
            if (!sdRegions[i].isDeleted()) {
                IndexedRegion corresponding = this.getCorrespondingNode(sdRegions[i]);
                if (currentLargest instanceof Text) {
                    currentLargest = corresponding;
                }
                if (corresponding != null && !(corresponding instanceof Text) && corresponding.getStartOffset() <= currentLargest.getStartOffset() && corresponding.getEndOffset() >= currentLargest.getEndOffset()) {
                    currentLargest = corresponding;
                }
            }
            ++i;
        }
        return currentLargest;
    }

    /*
     * Exception decompiling
     */
    protected IndexedRegion getCorrespondingNode(IStructuredDocumentRegion sdRegion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 57->60)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void connect(IDocument document) {
        this.fDocument = document;
    }

    public void disconnect(IDocument document) {
    }

    protected HTMLValidationResult validate(IDOMModel model, IFile file) {
        URIResolver res;
        IProject prj = null;
        if (file != null) {
            prj = file.getProject();
        }
        if (prj == null && model != null && (res = model.getResolver()) != null) {
            prj = res.getProject();
        }
        WorkbenchReporter reporter = new WorkbenchReporter(prj, (IProgressMonitor)new NullProgressMonitor());
        return this.validate((IReporter)reporter, file, model);
    }

    private HTMLValidationResult validate(IReporter reporter, IFile file, IDOMModel model) {
        if (file == null || model == null) {
            return null;
        }
        IDOMDocument document = model.getDocument();
        if (document == null) {
            return null;
        }
        if (!this.hasHTMLFeature(document)) {
            return null;
        }
        HTMLValidationAdapterFactory factory = HTMLValidationAdapterFactory.getInstance();
        ValidationAdapter adapter = (ValidationAdapter)factory.adapt((INodeNotifier)document);
        if (adapter == null) {
            return null;
        }
        HTMLValidationReporter rep = this.getReporter(reporter, file, model);
        rep.clear();
        adapter.setReporter((ValidationReporter)rep);
        if (reporter != null) {
            String fileName = "";
            IPath filePath = file.getFullPath();
            if (filePath != null) {
                fileName = filePath.toString();
            }
            Object[] args = new String[]{fileName};
            LocalizedMessage mess = new LocalizedMessage(4, NLS.bind((String)HTMLUIMessages.MESSAGE_HTML_VALIDATION_MESSAGE_UI_, (Object[])args));
            mess.setParams((String[])args);
            reporter.displaySubtask((IValidator)this, (IMessage)mess);
        }
        adapter.validate((IndexedRegion)document);
        return rep.getResult();
    }

    private void validateContainer(IValidationContext helper, IReporter reporter, IContainer container) {
        try {
            IResource[] resourceArray = container.members(false);
            int i = 0;
            while (i < resourceArray.length) {
                IResource resource = resourceArray[i];
                if (resource != null) {
                    if (resource instanceof IFile) {
                        this.validateFile(helper, reporter, (IFile)resource);
                    } else if (resource instanceof IContainer) {
                        this.validateContainer(helper, reporter, (IContainer)resource);
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private void validateDelta(IValidationContext helper, IReporter reporter) {
        String[] deltaArray = helper.getURIs();
        int i = 0;
        while (i < deltaArray.length) {
            IResource resource;
            String delta = deltaArray[i];
            if (delta != null && (resource = this.getResource(delta)) != null && resource instanceof IFile) {
                this.validateFile(helper, reporter, (IFile)resource);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateFile(IValidationContext helper, IReporter reporter, IFile file) {
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        if (!HTMLValidator.shouldValidate(file)) {
            return;
        }
        IDOMModel model = this.getModel(file.getProject(), file);
        if (model == null) {
            return;
        }
        try {
            this.validate(reporter, file, model);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.releaseModel((IStructuredModel)model);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.releaseModel((IStructuredModel)model);
            return;
        }
    }

    private void validateFull(IValidationContext helper, IReporter reporter) {
        IProject project = null;
        String[] fileDelta = helper.getURIs();
        if (helper instanceof IWorkbenchContext) {
            IWorkbenchContext wbHelper = (IWorkbenchContext)helper;
            project = wbHelper.getProject();
        } else {
            project = this.getResource(fileDelta[0]).getProject();
        }
        if (project == null) {
            return;
        }
        this.validateContainer(helper, reporter, (IContainer)project);
    }

    public IResource getResource(String delta) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(delta));
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        IStatus status = Status.OK_STATUS;
        try {
            this.validate(helper, reporter);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        return status;
    }
}

