/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptorManager;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public final class NavigatorActivationService
implements INavigatorActivationService {
    private static final String ACTIVATED_EXTENSIONS = ".activatedExtensions";
    private static final NavigatorContentDescriptorManager CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorManager.getInstance();
    private static final INavigatorContentDescriptor[] NO_DESCRIPTORS = new INavigatorContentDescriptor[0];
    private static final String DELIM = ";";
    private final Set activatedExtensions = new HashSet();
    private final ListenerList listeners = new ListenerList();
    private INavigatorContentService contentService;

    public NavigatorActivationService(INavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.revertExtensionActivations();
    }

    public boolean isNavigatorExtensionActive(String aNavigatorExtensionId) {
        return this.activatedExtensions.contains(aNavigatorExtensionId);
    }

    public void setActive(String aNavigatorExtensionId, boolean toEnable) {
        boolean currentlyActive = this.isNavigatorExtensionActive(aNavigatorExtensionId);
        if (currentlyActive == toEnable) {
            return;
        }
        if (toEnable) {
            this.activatedExtensions.add(aNavigatorExtensionId);
        } else {
            this.activatedExtensions.remove(aNavigatorExtensionId);
        }
        this.notifyListeners(new String[]{aNavigatorExtensionId}, toEnable);
    }

    public void setActive(String[] aNavigatorExtensionIds, boolean toEnable) {
        if (toEnable) {
            int i = 0;
            while (i < aNavigatorExtensionIds.length) {
                this.activatedExtensions.add(aNavigatorExtensionIds[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < aNavigatorExtensionIds.length) {
                this.activatedExtensions.remove(aNavigatorExtensionIds[i]);
                ++i;
            }
        }
        this.notifyListeners(aNavigatorExtensionIds, toEnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistExtensionActivations() {
        Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
        Set set = this.activatedExtensions;
        synchronized (set) {
            Iterator activatedExtensionsIterator = this.activatedExtensions.iterator();
            StringBuffer preferenceValue = new StringBuffer();
            while (activatedExtensionsIterator.hasNext()) {
                preferenceValue.append(activatedExtensionsIterator.next()).append(DELIM);
            }
            preferences.setValue(this.getPreferenceKey(), preferenceValue.toString());
        }
        NavigatorPlugin.getDefault().savePluginPreferences();
    }

    public void addExtensionActivationListener(IExtensionActivationListener aListener) {
        this.listeners.add((Object)aListener);
    }

    public void removeExtensionActivationListener(IExtensionActivationListener aListener) {
        this.listeners.remove((Object)aListener);
    }

    private void notifyListeners(String[] navigatorExtensionIds, boolean toEnable) {
        Object[] listenerArray = this.listeners.getListeners();
        int i = 0;
        while (i < listenerArray.length) {
            ((IExtensionActivationListener)listenerArray[i]).onExtensionActivation(this.contentService.getViewerId(), navigatorExtensionIds, toEnable);
            ++i;
        }
    }

    private Set revertExtensionActivations() {
        Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
        String activatedExtensionsString = preferences.getString(this.getPreferenceKey());
        if (activatedExtensionsString != null && activatedExtensionsString.length() > 0) {
            String[] contentExtensionIds = activatedExtensionsString.split(DELIM);
            int i = 0;
            while (i < contentExtensionIds.length) {
                this.activatedExtensions.add(contentExtensionIds[i]);
                ++i;
            }
        } else {
            NavigatorContentDescriptor[] contentDescriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            int i = 0;
            while (i < contentDescriptors.length) {
                if (contentDescriptors[i].isActiveByDefault()) {
                    this.activatedExtensions.add(contentDescriptors[i].getId());
                }
                ++i;
            }
        }
        return this.activatedExtensions;
    }

    private String getPreferenceKey() {
        return String.valueOf(this.contentService.getViewerId()) + ACTIVATED_EXTENSIONS;
    }

    public INavigatorContentDescriptor[] activateExtensions(String[] extensionIds, boolean toDeactivateAllOthers) {
        HashSet<NavigatorContentDescriptor> activatedDescriptors = new HashSet<NavigatorContentDescriptor>();
        this.setActive(extensionIds, true);
        int extId = 0;
        while (extId < extensionIds.length) {
            activatedDescriptors.add(CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(extensionIds[extId]));
            ++extId;
        }
        if (toDeactivateAllOthers) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            ArrayList<NavigatorContentDescriptor> descriptorList = new ArrayList<NavigatorContentDescriptor>(Arrays.asList(descriptors));
            int descriptorIndx = 0;
            while (descriptorIndx < descriptors.length) {
                int extId2 = 0;
                while (extId2 < extensionIds.length) {
                    if (descriptors[descriptorIndx].getId().equals(extensionIds[extId2])) {
                        descriptorList.remove(descriptors[descriptorIndx]);
                    }
                    ++extId2;
                }
                ++descriptorIndx;
            }
            String[] deactivatedExtensions = new String[descriptorList.size()];
            int i = 0;
            while (i < descriptorList.size()) {
                INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)descriptorList.get(i);
                deactivatedExtensions[i] = descriptor.getId();
                ++i;
            }
            this.setActive(deactivatedExtensions, false);
        }
        if (activatedDescriptors.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return activatedDescriptors.toArray(new NavigatorContentDescriptor[activatedDescriptors.size()]);
    }

    public INavigatorContentDescriptor[] deactivateExtensions(String[] extensionIds, boolean toEnableAllOthers) {
        HashSet<NavigatorContentDescriptor> activatedDescriptors = new HashSet<NavigatorContentDescriptor>();
        this.setActive(extensionIds, false);
        if (toEnableAllOthers) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            ArrayList<NavigatorContentDescriptor> descriptorList = new ArrayList<NavigatorContentDescriptor>(Arrays.asList(descriptors));
            int descriptorIndx = 0;
            while (descriptorIndx < descriptors.length) {
                int extId = 0;
                while (extId < extensionIds.length) {
                    if (descriptors[descriptorIndx].getId().equals(extensionIds[extId])) {
                        descriptorList.remove(descriptors[descriptorIndx]);
                    }
                    ++extId;
                }
                ++descriptorIndx;
            }
            String[] activatedExtensions = new String[descriptorList.size()];
            int i = 0;
            while (i < descriptorList.size()) {
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)descriptorList.get(i);
                activatedExtensions[i] = descriptor.getId();
                activatedDescriptors.add(descriptor);
                ++i;
            }
            this.setActive(activatedExtensions, true);
        }
        if (activatedDescriptors.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return activatedDescriptors.toArray(new NavigatorContentDescriptor[activatedDescriptors.size()]);
    }
}

