/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.dialer.skype;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vtp.dialer.skype.ISkDialerListener;
import org.eclipse.vtp.dialer.skype.Messages;
import org.eclipse.vtp.dialer.skype.PhoneException;
import org.eclipse.vtp.dialer.skype.SkDialer;
import org.eclipse.vtp.dialer.skype.SkypePlugin;
import org.eclipse.vtp.internal.dialer.IVoipCall;
import org.eclipse.vtp.internal.dialer.IVoipConnection;
import org.eclipse.vtp.internal.dialer.IVoipDialerListener;
import org.eclipse.vtp.internal.dialer.VoipDialerException;

public class SkypeCall
implements IVoipCall {
    private static final int AWAITING_RESPONSE = 32;
    private static final int DEFAULT_DTMF_DELAY = 200;
    private final IVoipDialerListener userListener;
    private final SkDialer skDialer;
    private final IVoipConnection connection;
    private int callStatus;
    private String callLastMessage;
    final SkypeCall objRef = this;
    private boolean statusChangeOccurred = false;
    private int callId;
    private int failureReason = 0;
    private static final String[] failureStrings = new String[]{Messages.SkypeCall_0, Messages.SkypeCall_1, Messages.SkypeCall_2, Messages.SkypeCall_3, Messages.SkypeCall_4, Messages.SkypeCall_5, Messages.SkypeCall_6, Messages.SkypeCall_7, Messages.SkypeCall_8, Messages.SkypeCall_9, Messages.SkypeCall_10, Messages.SkypeCall_11, Messages.SkypeCall_12};
    private static final Map failureMap = new HashMap();
    private static final boolean DEBUGGING = SkypePlugin.getDefault().isDebugging();
    SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());

    static {
        failureMap.put("REFUSED", "");
        failureMap.put("MISSED", "");
        failureMap.put("CANCELLED", "");
        failureMap.put("BUSY", "");
        failureMap.put("UNPLACED", "");
        failureMap.put("FAILED", "");
    }

    SkypeCall(IVoipDialerListener listener, SkDialer dialer, IVoipConnection myconnection) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(this.time.format(new Date())) + ": SkypeCall create");
            System.out.flush();
        }
        this.userListener = listener;
        this.skDialer = dialer;
        this.callStatus = 32;
        this.callLastMessage = "";
        this.statusChangeOccurred = false;
        this.connection = myconnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dialNumber(String number) throws VoipDialerException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(this.time.format(new Date())) + ": SkypeCall.dialNumber() called");
            System.out.flush();
        }
        ISkDialerListener skListener = this.getListener();
        this.skDialer.setListener(skListener);
        try {
            this.skDialer.sendMessage("#tellme CALL " + number);
        }
        catch (PhoneException pe) {
            this.callStatus = 16;
            this.skDialer.setListener(null);
            throw new VoipDialerException(this.userListener, String.valueOf(Messages.SkypeCall_33) + number, (Throwable)pe);
        }
        SkypeCall skypeCall = this.objRef;
        synchronized (skypeCall) {
            if (DEBUGGING) {
                System.out.println(String.valueOf(this.time.format(new Date())) + ": SkypeCall.dialNumber inside 60-second wait.");
                System.out.flush();
            }
            if (!this.statusChangeOccurred) {
                try {
                    this.objRef.wait(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.statusChangeOccurred) {
                throw new VoipDialerException(this.userListener, Messages.SkypeCall_22);
            }
            this.statusChangeOccurred = false;
        }
        if (this.callStatus == 8) {
            throw new VoipDialerException(this.userListener, Messages.SkypeCall_23);
        }
        if (this.callStatus == 16) {
            if ("FAILED".equals(this.callLastMessage)) {
                throw new VoipDialerException(this.userListener, String.valueOf(Messages.SkypeCall_25) + this.failReason());
            }
            throw new VoipDialerException(this.userListener, Messages.SkypeCall_26);
        }
    }

    private ISkDialerListener getListener() {
        final Pattern initial = Pattern.compile("^#tellme CALL (\\d+) STATUS ROUTING");
        final Pattern statusLine = Pattern.compile("CALL (\\d+) STATUS (\\w+)");
        final Pattern failreason = Pattern.compile("CALL (\\d+) FAILUREREASON (\\d+)");
        ISkDialerListener skListener = new ISkDialerListener(){
            int callNum = 0;
            int msgNum = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receiveMessage(String message) {
                Matcher match;
                if (DEBUGGING) {
                    System.out.println(String.valueOf(SkypeCall.this.time.format(new Date())) + ": Listener: " + message);
                }
                if ("SKYPE DEAD".equals(message)) {
                    SkypeCall skypeCall = SkypeCall.this.objRef;
                    synchronized (skypeCall) {
                        SkypeCall.this.objRef.callStatus = 8;
                        SkypeCall.this.objRef.callLastMessage = message;
                        SkypeCall.this.skDialer.setListener(null);
                        SkypeCall.this.objRef.statusChangeOccurred = true;
                        SkypeCall.this.objRef.notifyAll();
                    }
                }
                if (this.callNum == 0) {
                    match = initial.matcher(message);
                    if (match.matches()) {
                        this.callNum = Integer.parseInt(match.group(1));
                        SkypeCall skypeCall = SkypeCall.this.objRef;
                        synchronized (skypeCall) {
                            SkypeCall.this.objRef.callId = this.callNum;
                            SkypeCall.this.objRef.callLastMessage = "ROUTING";
                        }
                    }
                } else {
                    match = statusLine.matcher(message);
                    if (match.matches()) {
                        this.msgNum = Integer.parseInt(match.group(1));
                        if (this.msgNum == this.callNum) {
                            String status = match.group(2);
                            if (status.equals("INPROGRESS")) {
                                SkypeCall skypeCall = SkypeCall.this.objRef;
                                synchronized (skypeCall) {
                                    SkypeCall.this.objRef.callStatus = 2;
                                    SkypeCall.this.objRef.callLastMessage = status;
                                    SkypeCall.this.objRef.statusChangeOccurred = true;
                                    SkypeCall.this.objRef.notifyAll();
                                }
                            } else if (status.equals("FINISHED")) {
                                SkypeCall skypeCall = SkypeCall.this.objRef;
                                synchronized (skypeCall) {
                                    SkypeCall.this.objRef.callStatus = 4;
                                    SkypeCall.this.objRef.callLastMessage = status;
                                    SkypeCall.this.skDialer.setListener(null);
                                    SkypeCall.this.objRef.statusChangeOccurred = true;
                                    SkypeCall.this.objRef.notifyAll();
                                }
                            } else if (failureMap.containsKey(status)) {
                                SkypeCall skypeCall = SkypeCall.this.objRef;
                                synchronized (skypeCall) {
                                    SkypeCall.this.objRef.callStatus = 16;
                                    SkypeCall.this.objRef.callLastMessage = status;
                                    SkypeCall.this.skDialer.setListener(null);
                                    SkypeCall.this.objRef.statusChangeOccurred = true;
                                    SkypeCall.this.objRef.notifyAll();
                                }
                            }
                        }
                    } else {
                        match = failreason.matcher(message);
                        if (match.matches()) {
                            this.msgNum = Integer.parseInt(match.group(1));
                            if (this.msgNum == this.callNum) {
                                SkypeCall.this.failureReason = Integer.parseInt(match.group(2));
                            }
                        }
                    }
                }
            }
        };
        return skListener;
    }

    public String lastMessage() {
        return this.callLastMessage;
    }

    public int status() {
        return this.callStatus;
    }

    public void sendDTMF(String dtmf) throws VoipDialerException {
        this.sendDTMF(dtmf, 200);
    }

    public void sendDTMF(String dtmf, int pause) throws VoipDialerException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(this.time.format(new Date())) + ": SkypeCall.sendDTMF() called");
            System.out.flush();
        }
        if (this.callStatus != 2) {
            throw new VoipDialerException(this.userListener, Messages.SkypeCall_27);
        }
        Pattern validDTMF = Pattern.compile("^[0-9#\\*]*$");
        Matcher dtmfMatcher = validDTMF.matcher(dtmf);
        if (!dtmfMatcher.matches()) {
            throw new VoipDialerException(this.userListener, String.valueOf(Messages.SkypeCall_28) + dtmf + Messages.SkypeCall_29);
        }
        if (dtmf.length() > 0) {
            char[] dtmfChars = dtmf.toCharArray();
            try {
                this.skDialer.sendMessage("SET CALL " + this.callId + " DTMF " + dtmfChars[0]);
            }
            catch (PhoneException pe) {
                throw new VoipDialerException(this.userListener, Messages.SkypeCall_30, (Throwable)pe);
            }
            int idx = 1;
            while (idx < dtmfChars.length) {
                try {
                    Thread.sleep(pause);
                    this.skDialer.sendMessage("SET CALL " + this.callId + " DTMF " + dtmfChars[idx]);
                }
                catch (PhoneException pe) {
                    throw new VoipDialerException(this.userListener, Messages.SkypeCall_31, (Throwable)pe);
                }
                catch (InterruptedException ex) {
                    throw new VoipDialerException(this.userListener, (Throwable)ex);
                }
                ++idx;
            }
        }
    }

    public void hangUp() throws VoipDialerException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(this.time.format(new Date())) + ": SkypeCall.hangUp() called");
            System.out.flush();
        }
        try {
            this.skDialer.sendMessage("SET CALL " + this.callId + " STATUS FINISHED");
        }
        catch (PhoneException pe) {
            throw new VoipDialerException(this.userListener, Messages.SkypeCall_32, (Throwable)pe);
        }
        this.callStatus = 4;
    }

    public IVoipConnection getConnection() {
        return this.connection;
    }

    private String failReason() {
        return failureStrings[this.failureReason];
    }
}

