/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.dialer.skype;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.vtp.dialer.skype.Messages;
import org.eclipse.vtp.dialer.skype.PhoneException;
import org.eclipse.vtp.dialer.skype.SkDialer;
import org.eclipse.vtp.dialer.skype.SkypeConnection;
import org.eclipse.vtp.dialer.skype.SkypePlugin;
import org.eclipse.vtp.internal.dialer.IVoipConnection;
import org.eclipse.vtp.internal.dialer.IVoipDialer;
import org.eclipse.vtp.internal.dialer.IVoipDialerListener;
import org.eclipse.vtp.internal.dialer.VoipDialerException;

public class SkypeDialer
implements IVoipDialer {
    private IVoipDialerListener userListener;
    private int dialerStatus;
    private final SkDialer skDialer = SkDialer.getDialer();
    private final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private static final boolean DEBUGGING = SkypePlugin.getDefault().isDebugging();
    private static final SkypeDialer singleton;
    private static boolean initialized;

    static {
        initialized = false;
        singleton = new SkypeDialer();
    }

    private SkypeDialer() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(this.time.format(new Date())) + ": SkypeDialer create");
            System.out.flush();
        }
        this.dialerStatus = 2;
    }

    public static SkypeDialer instance() {
        return singleton;
    }

    public void initialize() throws VoipDialerException {
        this.initialize(new IVoipDialerListener(){

            public void dialerMessage(String msg) {
            }
        });
    }

    public void initialize(IVoipDialerListener listener) throws VoipDialerException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(this.time.format(new Date())) + ": SkypeDialer.initialize() called");
            System.out.flush();
        }
        this.userListener = listener;
        try {
            this.skDialer.initializeSkDialer(null);
        }
        catch (PhoneException pe) {
            throw new VoipDialerException(listener, pe.getMessage(), (Throwable)pe);
        }
        this.dialerStatus = 1;
    }

    public IVoipConnection connect() throws VoipDialerException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(this.time.format(new Date())) + ": SkypeDialer.connect() called");
            System.out.flush();
        }
        this.dialerStatus = 4;
        SkypeConnection newConnection = new SkypeConnection(this.userListener, this.skDialer);
        newConnection.connect();
        this.dialerStatus = 1;
        return newConnection;
    }

    public int status() {
        return this.dialerStatus;
    }

    protected void finalize() throws VoipDialerException, Throwable {
        if (DEBUGGING) {
            System.out.println(String.valueOf(this.time.format(new Date())) + ": SkypeDialer.finalize() called");
            new Exception("where from?").printStackTrace(System.out);
            System.out.flush();
        }
        try {
            this.skDialer.destroySkDialer();
        }
        catch (PhoneException pe) {
            throw new VoipDialerException(this.userListener, Messages.Unable_to_destroy_SkDialer, (Throwable)pe);
        }
        super.finalize();
    }
}

