/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.derby.internal.ui.connection.dialogs;

import org.eclipse.wst.rdb.derby.internal.ui.connection.dialogs.AbstractDerbyConnectionProvider;
import org.eclipse.wst.rdb.derby.internal.ui.connection.dialogs.AbstractDerbyUrl;

public class DerbyUniversalNewConnectionProvider
extends AbstractDerbyConnectionProvider {
    protected static final String DRIVER_CLASS_NAME = "com.ibm.db2.jcc.DB2Driver";
    protected static final String RETURN_MESSAGES = ":retrieveMessagesFromServerOnGetMessage=true;";

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    protected void updateURL() {
        String url = "jdbc:derby:net://" + this.hostCombo.getText() + ":" + this.portCombo.getText() + "/" + this.encodeDatabaseName(this.databaseCombo.getText()) + RETURN_MESSAGES;
        this.urlDisplay.setText(url);
        this.connectionInformation.setURL(url);
    }

    protected String encodeDatabaseName(String name) {
        String processedName = name;
        processedName = String.valueOf(processedName) + (!this.createCheck.getSelection() ? "" : ";create=true");
        if (this.displayUpgrade) {
            processedName = String.valueOf(processedName) + (!this.upgradeCheck.getSelection() ? "" : ";upgrade=true");
        }
        if (name.indexOf(47) > -1 || name.indexOf(92) > -1) {
            processedName = "\"" + processedName + "\"";
        }
        return processedName;
    }

    protected String decodeDatabaseName(String name) {
        String processedName = name;
        if (name.indexOf(34) > -1) {
            String remainingName = name.substring(name.indexOf(34) + 1);
            processedName = remainingName.substring(0, remainingName.indexOf(34));
        } else if (name.indexOf(58) > -1) {
            processedName = name.substring(0, name.indexOf(58));
        }
        return processedName;
    }

    public void loadProperties() {
        this.removeListeners();
        String rawURL = this.connectionInformation.getURL();
        if (rawURL.indexOf("create=true") <= -1) {
            this.createCheck.setSelection(false);
        } else {
            rawURL = rawURL.replaceFirst(";create=true", "");
            this.createCheck.setSelection(true);
        }
        if (this.displayUpgrade) {
            if (rawURL.indexOf("upgrade=true") <= -1) {
                this.upgradeCheck.setSelection(false);
            } else {
                rawURL = rawURL.replaceFirst(";upgrade=true", "");
                this.upgradeCheck.setSelection(true);
            }
        }
        DerbyUniversalJDBCURL url = new DerbyUniversalJDBCURL(rawURL);
        this.locationCombo.setText(this.connectionInformation.getLoadingPath());
        this.hostCombo.setText(url.getNode());
        this.portCombo.setText(url.getPort());
        this.databaseCombo.setText(url.getDatabaseName());
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    protected class DerbyUniversalJDBCURL
    extends AbstractDerbyUrl {
        public DerbyUniversalJDBCURL(String url) {
            super(url);
        }

        protected void parseURL(String url) {
            try {
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                this.subprotocol = String.valueOf(this.subprotocol) + remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 3);
                this.node = remainingURL.substring(0, remainingURL.indexOf(47));
                if (this.node.indexOf(58) > -1) {
                    this.port = this.node.substring(this.node.indexOf(58) + 1);
                    this.node = this.node.substring(0, this.node.indexOf(58));
                }
                remainingURL = remainingURL.substring(remainingURL.indexOf(47) + 1);
                this.databaseName = DerbyUniversalNewConnectionProvider.this.decodeDatabaseName(remainingURL);
            }
            catch (Exception exception) {}
        }
    }
}

