/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.desktop.core.project.IMediaContainer;
import org.eclipse.vtp.desktop.core.project.IMediaFile;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.IMediaResource;

public class MediaFileChooserDialog
extends Dialog {
    private IMediaFilesFolder[] folders;
    private String value = null;
    private TreeViewer viewer;

    public MediaFileChooserDialog(Shell parentShell, IMediaFilesFolder[] folders, String initialValue) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.folders = folders;
        this.value = initialValue;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Select a File");
        this.getShell().pack();
        this.getShell().setSize(250, 300);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.viewer = new TreeViewer(composite, 772);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new FilesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FilesLabelProvider());
        this.viewer.setSorter((ViewerSorter)new FilesSorter());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null || selection.isEmpty()) {
                    MediaFileChooserDialog.this.getButton(0).setEnabled(false);
                } else {
                    MediaFileChooserDialog.this.getButton(0).setEnabled(selection.getFirstElement() instanceof IMediaFile);
                }
            }
        });
        this.viewer.setInput((Object)this.folders);
        this.viewer.setAutoExpandLevel(1);
        return composite;
    }

    protected void okPressed() {
        this.value = ((IMediaFile)((IStructuredSelection)this.viewer.getSelection()).getFirstElement()).getMediaPath();
        super.okPressed();
    }

    public String getValue() {
        return this.value;
    }

    private final class FilesContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private FilesContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            if (!(parent instanceof IMediaFilesFolder[])) {
                return new Object[0];
            }
            IMediaFilesFolder[] roots = (IMediaFilesFolder[])parent;
            ArrayList results = new ArrayList();
            int i = 0;
            while (i < roots.length) {
                try {
                    results.addAll(roots[i].listMediaResources());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
                ++i;
            }
            return results.toArray();
        }

        public Object getParent(Object child) {
            return child instanceof IMediaResource ? ((IMediaResource)child).getParent() : null;
        }

        public Object[] getChildren(Object parent) {
            if (!(parent instanceof IMediaContainer)) {
                return new Object[0];
            }
            try {
                return ((IMediaContainer)parent).listMediaResources().toArray();
            }
            catch (CoreException e) {
                e.printStackTrace();
                return new Object[0];
            }
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof IMediaContainer;
        }

        public void dispose() {
        }
    }

    private final class FilesLabelProvider
    extends LabelProvider {
        private FilesLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof IMediaResource) {
                return ((IMediaResource)obj).getName();
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (obj instanceof IMediaContainer) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (obj instanceof IMediaFile) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return null;
        }
    }

    private final class FilesSorter
    extends ViewerSorter {
        private FilesSorter() {
        }

        public int category(Object element) {
            if (element instanceof IMediaContainer) {
                return 1;
            }
            if (element instanceof IMediaFile) {
                return 2;
            }
            return 3;
        }
    }
}

