/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.dialogs;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.ui.app.dialogs.MediaFileChooserDialog;
import org.eclipse.vtp.desktop.ui.app.dialogs.PromptChooserDialog;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.DatePrompt;
import org.eclipse.vtp.framework.media.prompts.DateTimePrompt;
import org.eclipse.vtp.framework.media.prompts.DigitsPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.MoneyPrompt;
import org.eclipse.vtp.framework.media.prompts.NumberPrompt;
import org.eclipse.vtp.framework.media.prompts.OrdinalPrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.prompts.TimePrompt;
import org.eclipse.vtp.framework.media.prompts.VariablePrompt;

public class PromptDialog
extends Dialog {
    private final DateFormat dateFormat = DateFormat.getDateInstance(3);
    private final DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 3);
    private final DateFormat timeFormat = DateFormat.getTimeInstance(3);
    private Element element = null;
    private Prompt prompt = null;
    private boolean simplePromptsOnly = false;
    private boolean variablePrompts = false;
    private IMediaFilesFolder[] folders = null;
    private Map promptOptions = null;
    private Combo type = null;
    private Group contents = null;
    private StackLayout stack = null;
    private int charactersIndex = 0;
    private Composite charactersContent = null;
    private Text charactersText = null;
    private int dateIndex = 0;
    private Composite dateContent = null;
    private Text dateText = null;
    private int dateTimeIndex = 0;
    private Composite dateTimeContent = null;
    private Text dateTimeText = null;
    private Button dateTimeZone = null;
    private int digitsIndex = 0;
    private Composite digitsContent = null;
    private Text digitsText = null;
    private int fileIndex = 0;
    private Composite fileContent = null;
    private Text fileText = null;
    private Button fileBrowse = null;
    private int moneyIndex = 0;
    private Composite moneyContent = null;
    private Text moneyText = null;
    private int numberIndex = 0;
    private Composite numberContent = null;
    private Text numberText = null;
    private int ordinalIndex = 0;
    private Composite ordinalContent = null;
    private Text ordinalText = null;
    private int referenceIndex = 0;
    private Composite referenceContent = null;
    private Text referenceText = null;
    private Button referenceBrowse = null;
    private int textIndex = 0;
    private Composite textContent = null;
    private Text textText = null;
    private int timeIndex = 0;
    private Composite timeContent = null;
    private Text timeText = null;
    private Button timeZone = null;
    private int variableIndex = 0;
    private Composite variableContent = null;
    private TreeViewer variableTree = null;
    private Combo variableType = null;

    public PromptDialog(Shell parentShell, boolean simplePromptsOnly, boolean variablePrompts, IMediaFilesFolder[] folders, Map promptOptions, Prompt prompt, Element element) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.simplePromptsOnly = simplePromptsOnly;
        this.variablePrompts = variablePrompts;
        this.folders = folders;
        this.promptOptions = promptOptions;
        this.prompt = prompt;
        this.element = element;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Edit the Prompt Information");
        this.getShell().pack();
        this.getShell().setSize(300, 275);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite root = new Composite(composite, 0);
        root.setLayoutDeferred(true);
        root.setLayout((Layout)new GridLayout(2, false));
        root.setLayoutData((Object)new GridData(1808));
        new Label(root, 0).setText("Type:");
        this.type = new Combo(root, 12);
        this.type.setLayoutData((Object)new GridData(768));
        int i = -1;
        this.type.add("Characters");
        ++i;
        this.charactersIndex = i++;
        if (!this.simplePromptsOnly) {
            this.type.add("Date");
            this.dateIndex = i++;
            this.type.add("Date & Time");
            this.dateTimeIndex = i++;
            this.type.add("Digits");
            this.digitsIndex = i;
        }
        this.type.add("Audio File");
        ++i;
        this.fileIndex = i++;
        if (!this.simplePromptsOnly) {
            this.type.add("Money");
            this.moneyIndex = i++;
            this.type.add("Number");
            this.numberIndex = i++;
            this.type.add("Ordinal");
            this.ordinalIndex = i;
        }
        this.type.add("Reference");
        ++i;
        this.referenceIndex = i++;
        this.type.add("Text");
        this.textIndex = i++;
        if (!this.simplePromptsOnly) {
            this.type.add("Time");
            this.timeIndex = i;
        }
        if (this.variablePrompts) {
            this.type.add("Variable");
            this.variableIndex = ++i;
        }
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.charactersIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.charactersContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.dateIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.dateContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.dateTimeIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.dateTimeContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.digitsIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.digitsContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.fileIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.fileContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.moneyIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.moneyContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.numberIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.numberContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.ordinalIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.ordinalContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.referenceIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.referenceContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.textIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.textContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.timeIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.timeContent;
                } else if (PromptDialog.this.type.getSelectionIndex() == PromptDialog.this.variableIndex) {
                    ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.variableContent;
                }
                PromptDialog.this.contents.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.contents = new Group(root, 0);
        this.contents.setText("Content");
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.contents.setLayoutData((Object)gridData);
        this.stack = new StackLayout();
        this.contents.setLayout((Layout)this.stack);
        this.charactersContent = new Composite((Composite)this.contents, 0);
        this.charactersContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.charactersContent, 0).setText("Characters:");
        this.charactersText = new Text(this.charactersContent, 2052);
        this.charactersText.setLayoutData((Object)new GridData(768));
        this.dateContent = new Composite((Composite)this.contents, 0);
        this.dateContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.dateContent, 0).setText("Date:");
        this.dateText = new Text(this.dateContent, 2052);
        this.dateText.setLayoutData((Object)new GridData(768));
        this.dateTimeContent = new Composite((Composite)this.contents, 0);
        this.dateTimeContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.dateTimeContent, 0).setText("Date & Time:");
        this.dateTimeText = new Text(this.dateTimeContent, 2052);
        this.dateTimeText.setLayoutData((Object)new GridData(768));
        this.dateTimeZone = new Button(this.dateTimeContent, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.dateTimeZone.setLayoutData((Object)gridData);
        this.dateTimeZone.setText("Show Time Zone");
        this.digitsContent = new Composite((Composite)this.contents, 0);
        this.digitsContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.digitsContent, 0).setText("Digits:");
        this.digitsText = new Text(this.digitsContent, 2052);
        this.digitsText.setLayoutData((Object)new GridData(768));
        this.fileContent = new Composite((Composite)this.contents, 0);
        this.fileContent.setLayout((Layout)new GridLayout(3, false));
        new Label(this.fileContent, 0).setText("File:");
        this.fileText = new Text(this.fileContent, 2052);
        this.fileText.setLayoutData((Object)new GridData(768));
        this.fileText.setEditable(false);
        this.fileBrowse = new Button(this.fileContent, 8);
        this.fileBrowse.setText("Browse...");
        this.fileBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MediaFileChooserDialog dialog = new MediaFileChooserDialog(PromptDialog.this.getShell(), PromptDialog.this.folders, PromptDialog.this.fileText.getText());
                if (dialog.open() != 0) {
                    return;
                }
                PromptDialog.this.fileText.setText(dialog.getValue());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.moneyContent = new Composite((Composite)this.contents, 0);
        this.moneyContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.moneyContent, 0).setText("Money:");
        this.moneyText = new Text(this.moneyContent, 2052);
        this.moneyText.setLayoutData((Object)new GridData(768));
        this.numberContent = new Composite((Composite)this.contents, 0);
        this.numberContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.numberContent, 0).setText("Number:");
        this.numberText = new Text(this.numberContent, 2052);
        this.numberText.setLayoutData((Object)new GridData(768));
        this.ordinalContent = new Composite((Composite)this.contents, 0);
        this.ordinalContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.ordinalContent, 0).setText("Ordinal:");
        this.ordinalText = new Text(this.ordinalContent, 2052);
        this.ordinalText.setLayoutData((Object)new GridData(768));
        this.referenceContent = new Composite((Composite)this.contents, 0);
        this.referenceContent.setLayout((Layout)new GridLayout(3, false));
        new Label(this.referenceContent, 0).setText("Prompt:");
        this.referenceText = new Text(this.referenceContent, 2052);
        this.referenceText.setLayoutData((Object)new GridData(768));
        this.referenceText.setEditable(false);
        this.referenceBrowse = new Button(this.referenceContent, 8);
        this.referenceBrowse.setText("Browse...");
        this.referenceBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String ref = PromptDialog.this.referenceText.getText();
                int at = ref.indexOf(64);
                PromptChooserDialog dialog = new PromptChooserDialog(PromptDialog.this.getShell(), ref.substring(at + 1), at >= 0 ? ref.substring(0, at) : "", PromptDialog.this.promptOptions);
                if (dialog.open() != 0) {
                    return;
                }
                ref = dialog.getName();
                if (dialog.getContainer().length() > 0) {
                    ref = String.valueOf(ref) + "@" + dialog.getContainer();
                }
                PromptDialog.this.referenceText.setText(ref);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.textContent = new Composite((Composite)this.contents, 0);
        this.textContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.textContent, 0).setText("Text:");
        this.textText = new Text(this.textContent, 2626);
        this.textText.setLayoutData((Object)new GridData(1808));
        this.timeContent = new Composite((Composite)this.contents, 0);
        this.timeContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.timeContent, 0).setText("Time:");
        this.timeText = new Text(this.timeContent, 2052);
        this.timeText.setLayoutData((Object)new GridData(768));
        this.timeZone = new Button(this.timeContent, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.timeZone.setLayoutData((Object)gridData);
        this.timeZone.setText("Show Time Zone");
        this.variableContent = new Composite((Composite)this.contents, 0);
        this.variableContent.setLayout((Layout)new GridLayout(2, false));
        new Label(this.variableContent, 0).setText("Variable:");
        this.variableTree = new TreeViewer(this.variableContent, 2820);
        this.variableTree.getControl().setLayoutData((Object)new GridData(768));
        this.variableTree.setContentProvider((IContentProvider)new VariableContentProvider());
        this.variableTree.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        new Label(this.variableContent, 0).setText("Interpret as: ");
        this.variableTree.setInput((Object)this);
        this.variableType = new Combo(this.variableContent, 12);
        this.variableType.setLayoutData((Object)new GridData(768));
        int j = 0;
        while (j < 5) {
            this.variableType.add(VariablePrompt.getTypeName((int)j));
            ++j;
        }
        this.variableType.select(4);
        this.prompt.accept(new Prompt.Visitor(){

            public Object charactersPrompt(CharactersPrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.charactersIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.charactersContent;
                PromptDialog.this.charactersText.setText(arg0.getCharacters());
                return null;
            }

            public Object datePrompt(DatePrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.dateIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.dateContent;
                PromptDialog.this.dateText.setText(PromptDialog.this.dateFormat.format(arg0.getValue()));
                return null;
            }

            public Object dateTimePrompt(DateTimePrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.dateTimeIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.dateTimeContent;
                PromptDialog.this.dateTimeText.setText(PromptDialog.this.dateTimeFormat.format(arg0.getValue()));
                if (arg0.isShowingTimeZone()) {
                    PromptDialog.this.dateTimeZone.setSelection(true);
                }
                return null;
            }

            public Object digitsPrompt(DigitsPrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.digitsIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.digitsContent;
                PromptDialog.this.digitsText.setText(arg0.getContent());
                return null;
            }

            public Object filePrompt(FilePrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.fileIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.fileContent;
                PromptDialog.this.fileText.setText(arg0.getPath());
                return null;
            }

            public Object moneyPrompt(MoneyPrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.moneyIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.moneyContent;
                PromptDialog.this.moneyText.setText(arg0.getValue().toString());
                return null;
            }

            public Object numberPrompt(NumberPrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.numberIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.numberContent;
                PromptDialog.this.numberText.setText(String.valueOf(arg0.getValue()));
                return null;
            }

            public Object ordinalPrompt(OrdinalPrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.ordinalIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.ordinalContent;
                PromptDialog.this.ordinalText.setText(String.valueOf(arg0.getValue()));
                return null;
            }

            public Object referencePrompt(ReferencePrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.referenceIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.referenceContent;
                String ref = arg0.getName();
                if (arg0.getContainer().length() > 0) {
                    ref = String.valueOf(ref) + "@" + arg0.getContainer();
                }
                PromptDialog.this.referenceText.setText(ref);
                return null;
            }

            public Object textPrompt(TextPrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.textIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.textContent;
                PromptDialog.this.textText.setText(arg0.getContent());
                return null;
            }

            public Object timePrompt(TimePrompt arg0) {
                PromptDialog.this.type.select(PromptDialog.this.timeIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.timeContent;
                PromptDialog.this.timeText.setText(PromptDialog.this.timeFormat.format(arg0.getValue()));
                if (arg0.isShowingTimeZone()) {
                    PromptDialog.this.timeZone.setSelection(true);
                }
                return null;
            }

            public Object variablePrompt(VariablePrompt variablePrompt) {
                PromptDialog.this.type.select(PromptDialog.this.variableIndex);
                ((PromptDialog)PromptDialog.this).stack.topControl = PromptDialog.this.variableContent;
                ObjectDefinition var = PromptDialog.this.getObjectDefinitionFromVariables(variablePrompt.getVariable());
                if (var != null) {
                    PromptDialog.this.variableTree.setSelection((ISelection)new StructuredSelection((Object)var));
                }
                PromptDialog.this.variableType.select(variablePrompt.getType());
                return null;
            }
        });
        root.setLayoutDeferred(false);
        return composite;
    }

    public ObjectDefinition getObjectDefinitionFromVariables(String name) {
        ObjectDefinition ret = null;
        List vars = this.element == null ? Collections.EMPTY_LIST : this.element.getVariables();
        int i = 0;
        while (i < vars.size()) {
            Variable v;
            String varName = name;
            boolean sub = false;
            if (name.indexOf(".") != -1) {
                varName = name.substring(0, name.indexOf("."));
                sub = true;
            }
            if ((v = (Variable)vars.get(i)).getName().equals(varName)) {
                if (sub) {
                    ret = this.getObjectDefinitionFromFields(name.substring(name.indexOf(".") + 1), v);
                } else {
                    ret = v;
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public ObjectDefinition getObjectDefinitionFromFields(String name, ObjectDefinition parent) {
        ObjectDefinition ret = null;
        List fields = parent.getFields();
        int i = 0;
        while (i < fields.size()) {
            ObjectField of;
            String varName = name;
            boolean sub = false;
            if (name.indexOf(46) != -1) {
                varName = name.substring(0, name.indexOf("."));
                sub = true;
            }
            if ((of = (ObjectField)fields.get(i)).getName().equals(varName)) {
                if (sub) {
                    ret = this.getObjectDefinitionFromFields(name.substring(name.indexOf(".") + 1), of);
                } else {
                    ret = of;
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    protected void okPressed() {
        if (this.type.getSelectionIndex() == this.charactersIndex) {
            this.prompt = new CharactersPrompt(this.charactersText.getText());
        } else if (this.type.getSelectionIndex() == this.dateIndex) {
            Date date = new Date();
            try {
                date = this.dateFormat.parse(this.dateText.getText());
            }
            catch (Exception exception) {}
            this.prompt = new DatePrompt(date);
        } else if (this.type.getSelectionIndex() == this.dateTimeIndex) {
            Date dateTime = new Date();
            try {
                dateTime = this.dateTimeFormat.parse(this.dateTimeText.getText());
            }
            catch (Exception exception) {}
            this.prompt = new DateTimePrompt(dateTime, this.dateTimeZone.getSelection());
        } else if (this.type.getSelectionIndex() == this.digitsIndex) {
            this.prompt = new DigitsPrompt(this.digitsText.getText());
        } else if (this.type.getSelectionIndex() == this.fileIndex) {
            this.prompt = new FilePrompt(this.fileText.getText());
        } else if (this.type.getSelectionIndex() == this.moneyIndex) {
            BigDecimal bd = new BigDecimal(0.0);
            try {
                bd = new BigDecimal(this.moneyText.getText());
            }
            catch (Exception exception) {}
            this.prompt = new MoneyPrompt(bd);
        } else if (this.type.getSelectionIndex() == this.numberIndex) {
            int n = 0;
            try {
                n = Integer.parseInt(this.numberText.getText());
            }
            catch (Exception exception) {}
            this.prompt = new NumberPrompt(n);
        } else if (this.type.getSelectionIndex() == this.ordinalIndex) {
            int o = 0;
            try {
                o = Integer.parseInt(this.ordinalText.getText());
            }
            catch (Exception exception) {}
            this.prompt = new OrdinalPrompt(o);
        } else if (this.type.getSelectionIndex() == this.referenceIndex) {
            String str = this.referenceText.getText();
            this.prompt = str.indexOf(64) >= 0 ? new ReferencePrompt(str.substring(0, str.indexOf(64)), str.substring(str.indexOf(64) + 1)) : new ReferencePrompt(str);
        } else if (this.type.getSelectionIndex() == this.textIndex) {
            this.prompt = new TextPrompt(this.textText.getText());
        } else if (this.type.getSelectionIndex() == this.timeIndex) {
            Date time = new Date();
            try {
                time = this.timeFormat.parse(this.timeText.getText());
            }
            catch (Exception exception) {}
            this.prompt = new TimePrompt(time, this.timeZone.getSelection());
        } else if (this.type.getSelectionIndex() == this.variableIndex) {
            IStructuredSelection sel = (IStructuredSelection)this.variableTree.getSelection();
            this.prompt = sel.isEmpty() ? new VariablePrompt("", this.variableType.getSelectionIndex()) : new VariablePrompt(((ObjectDefinition)sel.getFirstElement()).getPath(), this.variableType.getSelectionIndex());
        }
        super.okPressed();
    }

    public Prompt getResult() {
        return this.prompt;
    }

    private class VariableContentProvider
    implements ITreeContentProvider {
        private VariableContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ObjectDefinition) {
                ObjectDefinition v = (ObjectDefinition)parentElement;
                return v.getFields().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Variable) {
                return null;
            }
            return ((ObjectField)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((ObjectDefinition)element).getFields().size() > 0;
        }

        public Object[] getElements(Object inputElement) {
            return PromptDialog.this.element == null ? new Object[]{} : PromptDialog.this.element.getVariables().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class VariableLabelProvider
    implements ILabelProvider {
        private VariableLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((ObjectDefinition)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

