/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.dialogs;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.ui.app.dialogs.PromptDialog;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.DatePrompt;
import org.eclipse.vtp.framework.media.prompts.DateTimePrompt;
import org.eclipse.vtp.framework.media.prompts.DigitsPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.MoneyPrompt;
import org.eclipse.vtp.framework.media.prompts.NumberPrompt;
import org.eclipse.vtp.framework.media.prompts.OrdinalPrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.prompts.TimePrompt;
import org.eclipse.vtp.framework.media.prompts.VariablePrompt;

public class PromptSequenceDialog
extends Dialog {
    private final DateFormat dateFormat = DateFormat.getDateInstance(3);
    private final DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 3);
    private final DateFormat timeFormat = DateFormat.getTimeInstance(3);
    private Element element = null;
    private String name;
    private boolean nameEditable;
    private Map promptListsByLocale;
    private boolean simplePromptsOnly;
    private boolean variablePrompts;
    private IMediaFilesFolder[] folders;
    private Map promptOptions;
    private Text nameText = null;
    private TreeViewer langTree = null;
    private IStructuredSelection langSelection = StructuredSelection.EMPTY;
    private TableViewer entriesTable = null;
    private IStructuredSelection entrySelection = StructuredSelection.EMPTY;
    private ToolItem addEntry = null;
    private ToolItem editEntry = null;
    private ToolItem deleteEntry = null;
    private ToolItem moveUp = null;
    private ToolItem moveDown = null;

    public PromptSequenceDialog(Shell parentShell, String name, boolean nameEditable, Map promptListsByLocale, boolean simplePromptsOnly, boolean variablePrompts, IMediaFilesFolder[] folders, Map promptOptions, Element element) {
        super(parentShell);
        this.name = name;
        this.nameEditable = nameEditable;
        this.promptListsByLocale = promptListsByLocale;
        this.simplePromptsOnly = simplePromptsOnly;
        this.variablePrompts = variablePrompts;
        this.folders = folders;
        this.promptOptions = promptOptions;
        this.element = element;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Configure Prompts");
        this.getButton(0).setEnabled(this.name.length() > 0);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite root = new Composite(composite, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 480;
        gd.heightHint = 275;
        root.setLayoutData((Object)gd);
        root.setLayout((Layout)new GridLayout(2, false));
        new Label(root, 0).setText("Name:");
        this.nameText = new Text(root, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.name);
        this.nameText.setEditable(this.nameEditable);
        if (this.nameEditable) {
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PromptSequenceDialog.this.getButton(0).setEnabled(PromptSequenceDialog.this.nameText.getText().length() > 0);
                }
            });
        }
        SashForm sash = new SashForm(root, 256);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        sash.setLayoutData((Object)gd);
        Group langGroup = new Group((Composite)sash, 0);
        langGroup.setText("Languages");
        langGroup.setLayoutData((Object)new GridData(1808));
        langGroup.setLayout((Layout)new GridLayout(1, true));
        this.langTree = new TreeViewer((Composite)langGroup, 772);
        this.langTree.getControl().setLayoutData((Object)new GridData(1808));
        this.langTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PromptSequenceDialog.this.langSelection = (IStructuredSelection)PromptSequenceDialog.this.langTree.getSelection();
                PromptSequenceDialog.this.langSelectionChanged();
            }
        });
        LangContentProvider lcp = new LangContentProvider();
        this.langTree.setContentProvider((IContentProvider)lcp);
        this.langTree.setLabelProvider((IBaseLabelProvider)lcp);
        this.langTree.setSorter(new ViewerSorter());
        this.langTree.setInput(this.promptListsByLocale.keySet());
        Group entriesGroup = new Group((Composite)sash, 0);
        entriesGroup.setText("Entries");
        entriesGroup.setLayoutData((Object)new GridData(1808));
        entriesGroup.setLayout((Layout)new GridLayout(1, true));
        ToolBar entriesToolBar = new ToolBar((Composite)entriesGroup, 0);
        entriesToolBar.setLayoutData((Object)new GridData(768));
        this.addEntry = this.newToolItem(entriesToolBar, 8, "New Entry", "IMG_OBJ_FILE", new Runnable(){

            public void run() {
                PromptSequenceDialog.this.newEntry();
            }
        });
        this.editEntry = this.newToolItem(entriesToolBar, 8, "Edit Entry", "IMG_OBJS_INFO_TSK", new Runnable(){

            public void run() {
                PromptSequenceDialog.this.editEntry();
            }
        });
        this.deleteEntry = this.newToolItem(entriesToolBar, 8, "Delete Entry", "IMG_TOOL_DELETE", new Runnable(){

            public void run() {
                PromptSequenceDialog.this.deleteEntry();
            }
        });
        this.moveUp = this.newToolItem(entriesToolBar, 8, "Move Up", "IMG_TOOL_BACK", new Runnable(){

            public void run() {
                PromptSequenceDialog.this.moveUp();
            }
        });
        this.moveDown = this.newToolItem(entriesToolBar, 8, "Move Down", "IMG_TOOL_FORWARD", new Runnable(){

            public void run() {
                PromptSequenceDialog.this.moveDown();
            }
        });
        this.entriesTable = new TableViewer((Composite)entriesGroup, 770);
        this.entriesTable.getControl().setLayoutData((Object)new GridData(1808));
        this.entriesTable.getTable().setHeaderVisible(true);
        new TableColumn(this.entriesTable.getTable(), 0).setText("Type");
        new TableColumn(this.entriesTable.getTable(), 0).setText("Content");
        this.entriesTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PromptSequenceDialog.this.entrySelection = (IStructuredSelection)PromptSequenceDialog.this.entriesTable.getSelection();
                PromptSequenceDialog.this.entrySelectionChanged();
            }
        });
        EntriesContentProvider ecp = new EntriesContentProvider();
        this.entriesTable.setContentProvider((IContentProvider)ecp);
        this.entriesTable.setLabelProvider((IBaseLabelProvider)ecp);
        this.entriesTable.getTable().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int left = ((PromptSequenceDialog)PromptSequenceDialog.this).entriesTable.getTable().getSize().x;
                int chunk = left / PromptSequenceDialog.this.entriesTable.getTable().getColumnCount();
                int i = 1;
                while (i < PromptSequenceDialog.this.entriesTable.getTable().getColumnCount()) {
                    PromptSequenceDialog.this.entriesTable.getTable().getColumn(i).setWidth(chunk);
                    left -= chunk;
                    ++i;
                }
                PromptSequenceDialog.this.entriesTable.getTable().getColumn(0).setWidth(left);
            }
        });
        if (!this.promptListsByLocale.isEmpty()) {
            this.langTree.setSelection((ISelection)new StructuredSelection(this.promptListsByLocale.keySet().iterator().next()));
        } else {
            this.langTree.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        sash.setWeights(new int[]{30, 70});
        Locale selected = new Locale(Locale.getDefault().getLanguage());
        if (!this.promptListsByLocale.containsKey(selected)) {
            selected = (Locale)this.promptListsByLocale.keySet().iterator().next();
        }
        this.langTree.setSelection((ISelection)new StructuredSelection((Object)selected));
        return composite;
    }

    private void langSelectionChanged() {
        if (this.langSelection.size() == 0) {
            this.entriesTable.setInput((Object)Collections.EMPTY_LIST);
        } else {
            this.entriesTable.setInput(this.promptListsByLocale.get(this.langSelection.getFirstElement()));
        }
        this.entriesTable.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private void entrySelectionChanged() {
        if (this.langSelection.size() == 0) {
            this.addEntry.setEnabled(false);
            this.editEntry.setEnabled(false);
            this.deleteEntry.setEnabled(false);
            this.moveUp.setEnabled(false);
            this.moveDown.setEnabled(false);
            return;
        }
        this.addEntry.setEnabled(true);
        this.editEntry.setEnabled(this.entrySelection.size() == 1);
        this.deleteEntry.setEnabled(this.entrySelection.size() > 0);
        this.moveUp.setEnabled(this.entrySelection.size() == 1);
        this.moveDown.setEnabled(this.entrySelection.size() == 1);
    }

    private void newEntry() {
        int index = this.entrySelection.isEmpty() ? ((List)this.entriesTable.getInput()).size() : ((List)this.entriesTable.getInput()).indexOf(this.entrySelection.getFirstElement()) + 1;
        PromptDialog dialog = new PromptDialog(this.getShell(), this.simplePromptsOnly, this.variablePrompts, this.folders, this.promptOptions, (Prompt)new TextPrompt(), this.element);
        if (dialog.open() != 0) {
            return;
        }
        ((List)this.entriesTable.getInput()).add(index, dialog.getResult());
        this.entriesTable.insert((Object)dialog.getResult(), index);
    }

    private void editEntry() {
        Prompt selected = (Prompt)this.entrySelection.getFirstElement();
        PromptDialog dialog = new PromptDialog(this.getShell(), this.simplePromptsOnly, this.variablePrompts, this.folders, this.promptOptions, selected, this.element);
        if (dialog.open() != 0) {
            return;
        }
        int index = ((List)this.entriesTable.getInput()).indexOf(selected);
        ((List)this.entriesTable.getInput()).remove(index);
        ((List)this.entriesTable.getInput()).add(index, dialog.getResult());
        this.entriesTable.remove((Object)selected);
        this.entriesTable.insert((Object)dialog.getResult(), index);
    }

    private void deleteEntry() {
        ArrayList toRemove = new ArrayList(this.entrySelection.toList());
        boolean success = false;
        success = toRemove.size() == 1 ? MessageDialog.openConfirm((Shell)this.getShell(), (String)"Delete Entry", (String)"Are you sure you want to remove the selected entry?") : MessageDialog.openConfirm((Shell)this.getShell(), (String)"Delete Entries", (String)("Are you sure you want to remove the " + toRemove.size() + " selected entries?"));
        if (!success) {
            return;
        }
        ((List)this.entriesTable.getInput()).removeAll(toRemove);
        this.entriesTable.remove(toRemove.toArray());
    }

    private void moveUp() {
        Prompt selected = (Prompt)this.entrySelection.getFirstElement();
        int index = this.entriesTable.getTable().getSelectionIndex();
        if (index <= 0) {
            return;
        }
        ((List)this.entriesTable.getInput()).remove(index);
        ((List)this.entriesTable.getInput()).add(index - 1, selected);
        this.entriesTable.refresh();
        this.entriesTable.getTable().setSelection(index - 1);
    }

    private void moveDown() {
        Prompt selected = (Prompt)this.entrySelection.getFirstElement();
        int index = this.entriesTable.getTable().getSelectionIndex();
        if (index < 0 || index == ((List)this.entriesTable.getInput()).size() - 1) {
            return;
        }
        ((List)this.entriesTable.getInput()).remove(index);
        ((List)this.entriesTable.getInput()).add(index + 1, selected);
        this.entriesTable.refresh();
        this.entriesTable.getTable().setSelection(index + 1);
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public Map getPromptListsByLocale() {
        return this.promptListsByLocale;
    }

    protected ToolItem newToolItem(ToolBar bar, int style, String text, String imageId, Runnable action) {
        return this.newToolItem(bar, style, text, PlatformUI.getWorkbench().getSharedImages().getImage(imageId), action);
    }

    protected ToolItem newToolItem(ToolBar bar, int style, String text, Image image, final Runnable action) {
        ToolItem item = new ToolItem(bar, style);
        item.setToolTipText(text);
        item.setImage(image);
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return item;
    }

    private final class LangContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private Map localeTree = new HashMap();

        private LangContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Locale parent;
            Locale locale;
            this.localeTree.clear();
            if (!(newInput instanceof Set)) {
                return;
            }
            HashSet locales = new HashSet((Set)newInput);
            ArrayList<Locale> languages = new ArrayList<Locale>(locales.size());
            Iterator i = locales.iterator();
            while (i.hasNext()) {
                locale = (Locale)i.next();
                if (!"".equals(locale.getCountry())) continue;
                languages.add(locale);
                i.remove();
            }
            this.localeTree.put(null, languages);
            i = locales.iterator();
            while (i.hasNext()) {
                locale = (Locale)i.next();
                if (!"".equals(locale.getVariant())) continue;
                parent = new Locale(locale.getLanguage());
                ArrayList<Locale> countries = (ArrayList<Locale>)this.localeTree.get(parent);
                if (countries == null) {
                    countries = new ArrayList<Locale>();
                    this.localeTree.put(parent, countries);
                }
                countries.add(locale);
                i.remove();
            }
            i = locales.iterator();
            while (i.hasNext()) {
                locale = (Locale)i.next();
                parent = new Locale(locale.getLanguage(), locale.getCountry());
                ArrayList<Locale> variants = (ArrayList<Locale>)this.localeTree.get(parent);
                if (variants == null) {
                    variants = new ArrayList<Locale>();
                    this.localeTree.put(parent, variants);
                }
                variants.add(locale);
                i.remove();
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(null);
        }

        public Object[] getChildren(Object parentElement) {
            return this.localeTree.containsKey(parentElement) ? ((Collection)this.localeTree.get(parentElement)).toArray() : new Object[]{};
        }

        public Object getParent(Object element) {
            if (element instanceof Locale) {
                Locale locale = (Locale)element;
                if ("".equals(locale.getCountry())) {
                    return null;
                }
                if ("".equals(locale.getVariant())) {
                    return new Locale(locale.getLanguage());
                }
                return new Locale(locale.getLanguage(), locale.getCountry());
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.localeTree.containsKey(element);
        }

        public String getText(Object element) {
            if (element instanceof Locale) {
                Locale locale = (Locale)element;
                if ("".equals(locale.getCountry())) {
                    return locale.getDisplayLanguage();
                }
                if ("".equals(locale.getVariant())) {
                    return locale.getDisplayCountry();
                }
                return locale.getDisplayVariant();
            }
            return null;
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
    }

    private final class EntriesContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider,
    Prompt.Visitor {
        private boolean visitForType;

        private EntriesContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof List) {
                return ((List)parent).toArray();
            }
            return new Object[0];
        }

        public String getColumnText(Object obj, int index) {
            switch (index) {
                case 0: {
                    this.visitForType = true;
                    return ((Prompt)obj).accept((Prompt.Visitor)this).toString();
                }
                case 1: {
                    this.visitForType = false;
                    return ((Prompt)obj).accept((Prompt.Visitor)this).toString();
                }
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return null;
        }

        public void dispose() {
        }

        public Object charactersPrompt(CharactersPrompt arg0) {
            return this.visitForType ? "Characters" : arg0.getCharacters();
        }

        public Object datePrompt(DatePrompt arg0) {
            return this.visitForType ? "Date" : PromptSequenceDialog.this.dateFormat.format(arg0.getValue());
        }

        public Object dateTimePrompt(DateTimePrompt arg0) {
            return this.visitForType ? "Date & Time" : PromptSequenceDialog.this.dateTimeFormat.format(arg0.getValue());
        }

        public Object digitsPrompt(DigitsPrompt arg0) {
            return this.visitForType ? "Digits" : arg0.getContent();
        }

        public Object filePrompt(FilePrompt arg0) {
            return this.visitForType ? "File" : arg0.getPath();
        }

        public Object moneyPrompt(MoneyPrompt arg0) {
            return this.visitForType ? "Money" : String.valueOf(arg0.getCurrency().getSymbol()) + arg0.getValue().toString();
        }

        public Object numberPrompt(NumberPrompt arg0) {
            return this.visitForType ? "Number" : String.valueOf(arg0.getValue());
        }

        public Object ordinalPrompt(OrdinalPrompt arg0) {
            return this.visitForType ? "Ordinal" : String.valueOf(arg0.getValue());
        }

        public Object referencePrompt(ReferencePrompt arg0) {
            return this.visitForType ? "Reference" : String.valueOf(arg0.getName()) + "@" + arg0.getContainer();
        }

        public Object textPrompt(TextPrompt arg0) {
            return this.visitForType ? "Text" : arg0.getContent();
        }

        public Object timePrompt(TimePrompt arg0) {
            return this.visitForType ? "Time" : PromptSequenceDialog.this.timeFormat.format(arg0.getValue());
        }

        public Object variablePrompt(VariablePrompt variablePrompt) {
            return this.visitForType ? "Variable" : variablePrompt.getVariable();
        }
    }
}

