/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.localdata.ILocalDomain;
import org.eclipse.vtp.desktop.core.localdata.ILocalModule;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroup;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroupVersion;
import org.eclipse.vtp.desktop.core.localdata.ILocalVendor;
import org.eclipse.vtp.desktop.ui.app.dialogs.ComponentPropertiesDialog;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelPage;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationStartElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationTransferElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComparisonElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.DatabaseQueryElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.DisconnectElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.FieldElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.ForEachElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.MediaLibraryPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.ModuleElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.PlayPromptElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.Selectable;
import org.eclipse.vtp.desktop.ui.app.editor.model.TransferElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIConnector;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.VariableAssignmentElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeEntryElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeExitElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.builtins.attacheddata.PutAttachedDataElementFactory;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.GraphicUpdateEvent;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.GraphicUpdateListener;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.PropertiesListener;
import org.eclipse.vtp.desktop.ui.shared.actions.util.DynamicMenuManager;
import org.eclipse.vtp.desktop.ui.shared.actions.util.ProvisioningModelActionManager;
import org.eclipse.vtp.desktop.ui.shared.dialogs.ContentPage;

public class ApplicationViewer
implements PaintListener,
MouseListener,
MouseMoveListener,
KeyListener,
GraphicUpdateListener,
PropertiesListener {
    public static final int POINTER_TOOL = 0;
    public static final int CONNECTOR_TOOL = 1;
    private int currentTool;
    public Map resourceMap = new HashMap();
    private Canvas canvas = null;
    private ScrolledComposite sc = null;
    private ProvisioningModelActionManager pmam = null;
    private Action toggleLinePointAction;
    private DeleteObjectAction deleteAction;
    private ShowPropertiesAction propAction;
    private ModuleElementFactory moduleFactory = new ModuleElementFactory();
    private DisconnectElementFactory disconnectFactory = new DisconnectElementFactory();
    private TransferElementFactory transferFactory = new TransferElementFactory();
    private ApplicationTransferElementFactory appTransferFactory = new ApplicationTransferElementFactory();
    private PlayPromptElementFactory playPromptFactory = new PlayPromptElementFactory();
    private MenuElementFactory menuFactory = new MenuElementFactory();
    private WormholeExitElementFactory wormholeExitFactory = new WormholeExitElementFactory();
    private WormholeEntryElementFactory wormholeEntryFactory = new WormholeEntryElementFactory();
    private DatabaseQueryElementFactory databaseQueryFactory = new DatabaseQueryElementFactory();
    private WebServiceCallElementFactory webServiceCallFactory = new WebServiceCallElementFactory();
    private ForEachElementFactory forEachFactory = new ForEachElementFactory();
    private FieldElementFactory fieldFactory = new FieldElementFactory();
    private PutAttachedDataElementFactory putAttachedDataFactory = new PutAttachedDataElementFactory();
    private ComparisonElementFactory comparisonFactory = new ComparisonElementFactory();
    private VariableAssignmentElementFactory assignmentFactory = new VariableAssignmentElementFactory();
    private ApplicationModelPage currentPage;
    private Map sessionsByBrandNames;
    private Color white = null;
    private Color dialogFrameColor;
    private Color dialogSideBarColor;
    private Font font;
    private int lastMouseX;
    private int lastMouseY;

    public ApplicationViewer(ApplicationModelPage page) {
        this.currentPage = page;
        this.currentPage.addGraphicListener(this);
        this.currentPage.addPropertiesListener(this);
        this.currentTool = 0;
        this.pmam = new ProvisioningModelActionManager();
        this.deleteAction = new DeleteObjectAction();
        this.propAction = new ShowPropertiesAction();
        this.toggleLinePointAction = new ToggleLinePointAction();
    }

    public void createPartControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FillLayout());
        this.sc = new ScrolledComposite(comp, 768);
        this.sc.getVerticalBar().setIncrement(10);
        this.sc.getVerticalBar().setPageIncrement(15);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setMinSize(100, 100);
        this.white = (Color)this.resourceMap.get("COLOR_WHITE");
        if (this.white == null) {
            this.white = new Color((Device)Display.getCurrent(), 255, 255, 255);
            this.resourceMap.put("COLOR_WHITE", this.white);
        }
        this.canvas = new Canvas((Composite)this.sc, 0x20000000);
        this.canvas.setBackground(this.white);
        this.sc.setAlwaysShowScrollBars(false);
        this.sc.setContent((Control)this.canvas);
        this.sc.setMinSize(this.currentPage.getGraphSize());
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
        this.canvas.addKeyListener((KeyListener)this);
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ApplicationViewer.this.white.dispose();
            }
        });
        this.hookContextMenu();
    }

    public void setFont(Font font) {
        this.font = font;
        this.currentPage.setFont(font);
        if (this.canvas != null) {
            this.canvas.redraw();
        }
    }

    public ApplicationModelPage getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(ApplicationModelPage currentPage) {
        this.currentPage.removeGraphicListener(this);
        this.currentPage.removePropertiesListener(this);
        this.currentPage = currentPage;
        this.currentPage.addGraphicListener(this);
        this.currentPage.addPropertiesListener(this);
        if (this.font != null) {
            currentPage.setFont(this.font);
        }
        this.sc.setMinSize(currentPage.getGraphSize());
        this.sc.setOrigin(0, 0);
        this.canvas.redraw();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.canvas);
        this.canvas.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
        this.pmam.fillContextMenu(manager);
        List selectedObjects = this.currentPage.getSelectedObjects();
        if (selectedObjects.size() < 1) {
            DynamicMenuManager dmm = new DynamicMenuManager("Insert module");
            dmm.setParent((IContributionManager)manager);
            dmm.setEnabled(true);
            manager.add((IContributionItem)dmm);
            dmm.add((IContributionItem)new Separator("BuiltIns"));
            DynamicMenuManager builtInManager = new DynamicMenuManager("Standard");
            builtInManager.setParent((IContributionManager)dmm);
            builtInManager.setEnabled(true);
            dmm.appendToGroup("BuiltIns", (IContributionItem)builtInManager);
            builtInManager.add((IAction)new InsertAction("Application Transfer"));
            builtInManager.add((IAction)new InsertAction("Comparison"));
            builtInManager.add((IAction)new InsertAction("Database Query"));
            builtInManager.add((IAction)new InsertAction("Disconnect"));
            builtInManager.add((IAction)new InsertAction("Field"));
            builtInManager.add((IAction)new InsertAction("For Each"));
            builtInManager.add((IAction)new InsertAction("Menu"));
            builtInManager.add((IAction)new InsertAction("Play Prompt"));
            builtInManager.add((IAction)new InsertAction("Transfer"));
            builtInManager.add((IAction)new InsertAction("Variable Assignment"));
            builtInManager.add((IAction)new InsertAction("Web Service Call"));
            builtInManager.add((IAction)new InsertAction("Wormhole Entry"));
            builtInManager.add((IAction)new InsertAction("Wormhole Exit"));
            dmm.add((IContributionItem)new Separator("ThirdParty"));
            ILocalDomain localDomain = DesktopCorePlugin.getDefault().getLocalDomain();
            List vendors = localDomain.getVendors();
            Iterator iterator = vendors.iterator();
            while (iterator.hasNext()) {
                ILocalVendor localVendor = (ILocalVendor)iterator.next();
                String v = localVendor.getName();
                DynamicMenuManager thirdPartyManager = new DynamicMenuManager(v);
                thirdPartyManager.setParent((IContributionManager)dmm);
                thirdPartyManager.setEnabled(true);
                dmm.appendToGroup("ThirdParty", (IContributionItem)thirdPartyManager);
                List moduleGroups = localVendor.getModuleGroups();
                Iterator mgi = moduleGroups.iterator();
                while (mgi.hasNext()) {
                    ILocalModuleGroup localModuleGroup = (ILocalModuleGroup)mgi.next();
                    String mg = localModuleGroup.getName();
                    DynamicMenuManager moduleGroupManager = new DynamicMenuManager(mg);
                    moduleGroupManager.setParent((IContributionManager)thirdPartyManager);
                    moduleGroupManager.setEnabled(true);
                    thirdPartyManager.add((IContributionItem)moduleGroupManager);
                    List moduleGroupVersions = localModuleGroup.getVersions();
                    if (moduleGroupVersions.size() == 1) {
                        ILocalModuleGroupVersion localModuleGroupVersion = (ILocalModuleGroupVersion)moduleGroupVersions.get(0);
                        List modules = localModuleGroupVersion.getModules();
                        ArrayList<ILocalModule> sorted = new ArrayList<ILocalModule>();
                        sorted.addAll(modules);
                        int i = 0;
                        while (i < sorted.size() - 1) {
                            int j = 0;
                            while (j < sorted.size() - 1 - i) {
                                ILocalModule a = (ILocalModule)sorted.get(j);
                                ILocalModule b = (ILocalModule)sorted.get(j + 1);
                                if (a.getName().compareTo(b.getName()) > 0) {
                                    sorted.set(j, b);
                                    sorted.set(j + 1, a);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        Iterator mi = sorted.iterator();
                        while (mi.hasNext()) {
                            ILocalModule localModule = (ILocalModule)mi.next();
                            moduleGroupManager.add((IAction)new InsertAction(localModule));
                        }
                        continue;
                    }
                    Iterator mgvi = moduleGroupVersions.iterator();
                    while (mgvi.hasNext()) {
                        ILocalModuleGroupVersion localModuleGroupVersion = (ILocalModuleGroupVersion)moduleGroupVersions.get(0);
                        String mgv = localModuleGroupVersion.getVersionNumber();
                        DynamicMenuManager moduleGroupVersionManager = new DynamicMenuManager(mgv);
                        moduleGroupVersionManager.setParent((IContributionManager)moduleGroupManager);
                        moduleGroupVersionManager.setEnabled(true);
                        moduleGroupManager.add((IContributionItem)moduleGroupVersionManager);
                        List modules = localModuleGroupVersion.getModules();
                        ArrayList<ILocalModule> sorted = new ArrayList<ILocalModule>();
                        sorted.addAll(modules);
                        int i = 0;
                        while (i < sorted.size() - 1) {
                            int j = 0;
                            while (j < sorted.size() - 1 - i) {
                                ILocalModule a = (ILocalModule)sorted.get(j);
                                ILocalModule b = (ILocalModule)sorted.get(j + 1);
                                if (a.getName().compareTo(b.getName()) > 0) {
                                    sorted.set(j, b);
                                    sorted.set(j + 1, a);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        Iterator mi = sorted.iterator();
                        while (mi.hasNext()) {
                            ILocalModule localModule = (ILocalModule)mi.next();
                            moduleGroupVersionManager.add((IAction)new InsertAction(localModule));
                        }
                    }
                }
            }
        } else {
            if (selectedObjects.size() > 1 && selectedObjects.get(0) instanceof UIElement) {
                DynamicMenuManager alignmentManager = new DynamicMenuManager("Align Edges");
                alignmentManager.setParent((IContributionManager)manager);
                alignmentManager.setEnabled(true);
                manager.add((IContributionItem)alignmentManager);
                alignmentManager.add((IAction)new AlignSelectionAction(1));
                alignmentManager.add((IAction)new AlignSelectionAction(2));
                alignmentManager.add((IAction)new AlignSelectionAction(4));
                alignmentManager.add((IAction)new AlignSelectionAction(8));
                DynamicMenuManager centerManager = new DynamicMenuManager("Align Centers");
                centerManager.setParent((IContributionManager)manager);
                centerManager.setEnabled(true);
                manager.add((IContributionItem)centerManager);
                centerManager.add((IAction)new CenterSelectionAction(1));
                centerManager.add((IAction)new CenterSelectionAction(2));
                if (selectedObjects.size() > 2) {
                    DynamicMenuManager spaceManager = new DynamicMenuManager("Space Evenly");
                    spaceManager.setParent((IContributionManager)manager);
                    spaceManager.setEnabled(true);
                    manager.add((IContributionItem)spaceManager);
                    spaceManager.add((IAction)new SpaceSelectionAction(1));
                    spaceManager.add((IAction)new SpaceSelectionAction(2));
                }
            }
            if (selectedObjects.get(0) instanceof UIElement) {
                if (selectedObjects.size() > 1 || !(((UIElement)selectedObjects.get(0)).getElement() instanceof ApplicationStartElement)) {
                    manager.add((IAction)this.deleteAction);
                }
            } else {
                manager.add((IAction)this.deleteAction);
            }
            if (selectedObjects.size() == 1) {
                if (selectedObjects.get(0) instanceof UIConnector) {
                    manager.add((IAction)this.toggleLinePointAction);
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.propAction);
            }
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    public int getCurrentTool() {
        return this.currentTool;
    }

    public Color getDialogFrameColor() {
        return this.dialogFrameColor;
    }

    public void setDialogFrameColor(Color dialogFrameColor) {
        this.dialogFrameColor = dialogFrameColor;
    }

    public Color getDialogSideBarColor() {
        return this.dialogSideBarColor;
    }

    public void setDialogSideBarColor(Color dialogSideBarColor) {
        this.dialogSideBarColor = dialogSideBarColor;
    }

    public void addElement(Element element) {
        this.currentPage.addElement(element, this.sc.getOrigin().x + 40, this.sc.getOrigin().y + 40);
    }

    public void setSessionsByBrandNames(Map sessions) {
        this.sessionsByBrandNames = sessions;
    }

    public void setCurrentTool(int currentTool) {
        this.currentTool = currentTool;
    }

    public void showProperties() {
        List selectedObjects = this.currentPage.getSelectedObjects();
        if (selectedObjects.size() == 1) {
            List panels = this.currentPage.getSelectedObjectProperties((Selectable)selectedObjects.get(0));
            if (selectedObjects.get(0) instanceof UIElement && ((UIElement)selectedObjects.get(0)).getElement().getMediaProvider() != null && ((UIElement)selectedObjects.get(0)).getElement().getMediaProvider().hasMediaContent()) {
                MediaLibraryPropertiesPanel mepp = new MediaLibraryPropertiesPanel(((UIElement)selectedObjects.get(0)).getElement());
                mepp.setModel(this.currentPage.getModel());
                mepp.setMediaProvider(((UIElement)selectedObjects.get(0)).getElement().getMediaProvider());
                mepp.setSessionsByBrandNames(this.sessionsByBrandNames);
                panels.add(mepp);
            }
            if (panels != null && panels.size() > 0) {
                ComponentPropertiesDialog propDialog = new ComponentPropertiesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.currentPage);
                if (this.dialogFrameColor != null) {
                    propDialog.setFrameColor(this.dialogFrameColor);
                }
                if (this.dialogSideBarColor != null) {
                    propDialog.setSideBarColor(this.dialogSideBarColor);
                }
                propDialog.setTitle("Element Properties");
                int i = 0;
                while (i < panels.size()) {
                    propDialog.addPage((ContentPage)panels.get(i));
                    ++i;
                }
                propDialog.open();
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        this.lastMouseX = e.x;
        this.lastMouseY = e.y;
        this.canvas.setFocus();
        this.currentPage.processMouseDown(this.currentTool, e);
    }

    public void mouseUp(MouseEvent e) {
        this.currentPage.processMouseUp(this.currentTool, e);
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.lastMouseX = e.x;
        this.lastMouseY = e.y;
        this.currentPage.processMouseUp(this.currentTool, e);
        this.showProperties();
    }

    public void mouseMove(MouseEvent e) {
        this.currentPage.processMouseMove(this.currentTool, e);
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 127 && this.currentPage.getSelectedObjects().size() > 0) {
            if (this.currentPage.getSelectedObjects().get(0) instanceof UIElement) {
                if (this.currentPage.getSelectedObjects().size() > 1 || !(((UIElement)this.currentPage.getSelectedObjects().get(0)).getElement() instanceof ApplicationStartElement)) {
                    this.doDelete();
                }
            } else {
                this.doDelete();
            }
        }
    }

    private void doDelete() {
        MessageBox confirmationDialog = new MessageBox(this.canvas.getShell(), 200);
        if (this.currentPage.getSelectedObjects().size() > 1) {
            confirmationDialog.setMessage("Are you sure you want to delete these elements?");
        } else {
            confirmationDialog.setMessage("Are you sure you want to delete this element?");
        }
        int result = confirmationDialog.open();
        if (result == 64) {
            this.currentPage.deleteSelectedObjects();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void paintControl(PaintEvent e) {
        Rectangle clientArea = this.sc.getClientArea();
        Point origin = this.sc.getOrigin();
        e.gc.setAntialias(1);
        e.gc.setTextAntialias(1);
        this.currentPage.paint(origin, new Point(clientArea.width + origin.x, clientArea.height + origin.y), e.gc);
    }

    public void graphicUpdate(GraphicUpdateEvent e) {
        Rectangle clientArea = this.canvas.getClientArea();
        Rectangle currentFocusArea = new Rectangle(this.sc.getOrigin().x, this.sc.getOrigin().y, this.sc.getClientArea().width, this.sc.getClientArea().height);
        if (e.focusArea != null && e.focusArea.height > currentFocusArea.height) {
            e.focusArea.y -= (e.focusArea.height - currentFocusArea.height) / 2 + 1;
            e.focusArea.height -= currentFocusArea.height;
        }
        if (e.focusArea != null && e.focusArea.width > currentFocusArea.width) {
            e.focusArea.x -= (e.focusArea.width - currentFocusArea.width) / 2 + 1;
            e.focusArea.width -= currentFocusArea.width;
        }
        Point newOrigin = this.sc.getOrigin();
        this.sc.setLayoutDeferred(true);
        if (clientArea.width != e.clientArea.x || clientArea.height != e.clientArea.y) {
            this.sc.setMinSize(e.clientArea.x, e.clientArea.y);
        }
        if (!(e.focusArea == null || currentFocusArea.contains(e.focusArea.x, e.focusArea.y) && currentFocusArea.contains(e.focusArea.x + e.focusArea.width, e.focusArea.y + e.focusArea.height))) {
            boolean focusChange = false;
            if (e.focusArea.x < newOrigin.x) {
                newOrigin.x = e.focusArea.x;
                focusChange = true;
            } else if (e.focusArea.x + e.focusArea.width > newOrigin.x + currentFocusArea.width) {
                newOrigin.x = e.focusArea.x + e.focusArea.width - currentFocusArea.width;
                focusChange = true;
            }
            if (e.focusArea.y < newOrigin.y) {
                newOrigin.y = e.focusArea.y;
                focusChange = true;
            } else if (e.focusArea.y + e.focusArea.height > newOrigin.y + currentFocusArea.height) {
                newOrigin.y = e.focusArea.y + e.focusArea.height - currentFocusArea.height;
                focusChange = true;
            }
            if (focusChange) {
                this.sc.setOrigin(newOrigin);
            }
        }
        this.canvas.redraw();
        this.canvas.update();
        this.sc.setLayoutDeferred(false);
    }

    public void elementAdded(MediaProvider mediaProvider) {
    }

    public void elementRemoved(MediaProvider mediaProvider) {
    }

    public void elementSelected(MediaProvider mediaProvider) {
    }

    public void displayProperties() {
        if (this.currentPage.getSelectedObjects().size() > 0) {
            this.canvas.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ApplicationViewer.this.canvas.isVisible()) {
                        ApplicationViewer.this.showProperties();
                    }
                }
            });
        }
    }

    private class InsertAction
    extends Action {
        Object target;

        public InsertAction(Object target) {
            this.setText(target instanceof ILocalModule ? ((ILocalModule)target).getName() : (target instanceof String[] ? ((String[])target)[4] : target.toString()));
            this.target = target;
        }

        public void run() {
            Element newElement = null;
            if (this.target instanceof String[]) {
                newElement = ApplicationViewer.this.moduleFactory.create(Display.getCurrent(), this.target);
            } else if (this.target instanceof ILocalModule) {
                newElement = ApplicationViewer.this.moduleFactory.create(Display.getCurrent(), this.target);
            } else if (this.target instanceof String) {
                String type = (String)this.target;
                if (type.equals("Transfer")) {
                    newElement = ApplicationViewer.this.transferFactory.create(Display.getCurrent(), "0000");
                }
                if (type.equals("Application Transfer")) {
                    newElement = ApplicationViewer.this.appTransferFactory.create(Display.getCurrent(), "http://www.example.com/");
                } else if (type.equals("Disconnect")) {
                    newElement = ApplicationViewer.this.disconnectFactory.create(Display.getCurrent(), "");
                } else if (type.equals("Play Prompt")) {
                    newElement = ApplicationViewer.this.playPromptFactory.create(Display.getCurrent(), "");
                } else if (type.equals("Menu")) {
                    newElement = ApplicationViewer.this.menuFactory.create(Display.getCurrent(), "Menu");
                } else if (type.equals("Wormhole Exit")) {
                    newElement = ApplicationViewer.this.wormholeExitFactory.create(Display.getCurrent(), ApplicationViewer.this.currentPage.getModel());
                } else if (type.equals("Wormhole Entry")) {
                    newElement = ApplicationViewer.this.wormholeEntryFactory.create(Display.getCurrent(), ApplicationViewer.this.currentPage.getModel());
                } else if (type.equals("Database Query")) {
                    newElement = ApplicationViewer.this.databaseQueryFactory.create(Display.getCurrent(), ApplicationViewer.this.currentPage.getModel());
                } else if (type.equals("Web Service Call")) {
                    newElement = ApplicationViewer.this.webServiceCallFactory.create(Display.getCurrent(), ApplicationViewer.this.currentPage.getModel());
                } else if (type.equals("For Each")) {
                    newElement = ApplicationViewer.this.forEachFactory.create(Display.getCurrent(), ApplicationViewer.this.currentPage.getModel());
                } else if (type.equals("Field")) {
                    newElement = ApplicationViewer.this.fieldFactory.create(Display.getCurrent(), ApplicationViewer.this.currentPage.getModel());
                } else if (type.equals("Put Attached Data")) {
                    newElement = ApplicationViewer.this.putAttachedDataFactory.create(Display.getCurrent(), ApplicationViewer.this.currentPage.getModel());
                } else if (type.equals("Comparison")) {
                    newElement = ApplicationViewer.this.comparisonFactory.create(Display.getCurrent(), ApplicationViewer.this.currentPage.getModel());
                } else if (type.equals("Variable Assignment")) {
                    newElement = ApplicationViewer.this.assignmentFactory.create(Display.getCurrent(), ApplicationViewer.this.currentPage.getModel());
                }
            }
            if (newElement != null) {
                ApplicationViewer.this.currentPage.addElement(newElement, ApplicationViewer.this.lastMouseX, ApplicationViewer.this.lastMouseY);
            }
        }
    }

    public class DeleteObjectAction
    extends Action {
        public DeleteObjectAction() {
            this.setText("Delete");
        }

        public void run() {
            MessageBox confirmationDialog = new MessageBox(ApplicationViewer.this.canvas.getShell(), 200);
            if (ApplicationViewer.this.currentPage.getSelectedObjects().size() > 1) {
                confirmationDialog.setMessage("Are you sure you want to delete these elements?");
            } else {
                confirmationDialog.setMessage("Are you sure you want to delete this element?");
            }
            int result = confirmationDialog.open();
            if (result == 64) {
                ApplicationViewer.this.currentPage.deleteSelectedObjects();
            }
        }
    }

    public class AlignSelectionAction
    extends Action {
        int style;

        public AlignSelectionAction(int style) {
            this.style = style;
            switch (style) {
                case 1: {
                    this.setText("Left");
                    break;
                }
                case 2: {
                    this.setText("Top");
                    break;
                }
                case 4: {
                    this.setText("Right");
                    break;
                }
                case 8: {
                    this.setText("Bottom");
                }
            }
        }

        public void run() {
            ApplicationViewer.this.currentPage.alignSelectedObjects(this.style);
        }
    }

    public class CenterSelectionAction
    extends Action {
        int style;

        public CenterSelectionAction(int style) {
            this.style = style;
            switch (style) {
                case 1: {
                    this.setText("Horizontally");
                    break;
                }
                case 2: {
                    this.setText("Vertically");
                }
            }
        }

        public void run() {
            ApplicationViewer.this.currentPage.centerSelectedObjects(this.style);
        }
    }

    public class SpaceSelectionAction
    extends Action {
        int style;

        public SpaceSelectionAction(int style) {
            this.style = style;
            switch (style) {
                case 1: {
                    this.setText("Horizontally");
                    break;
                }
                case 2: {
                    this.setText("Vertically");
                }
            }
        }

        public void run() {
            ApplicationViewer.this.currentPage.spaceEvenlySelectedObjects(this.style);
        }
    }

    public class ShowPropertiesAction
    extends Action {
        public ShowPropertiesAction() {
            this.setText("Properties");
        }

        public void run() {
            ApplicationViewer.this.showProperties();
        }
    }

    public class ToggleLinePointAction
    extends Action {
        public ToggleLinePointAction() {
            this.setText("Toggle Line Point");
        }

        public void run() {
            ApplicationViewer.this.currentPage.toggleLinePoint();
        }
    }
}

