/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.vtp.desktop.ui.app.editor.ApplicationNavigator;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelPage;

public class IconicAppPage
extends Composite
implements PaintListener,
MouseListener {
    private ApplicationNavigator navigator;
    private List listeners;
    private boolean selected = false;
    private Color selectedColor;
    private Color unselectedColor;
    private List contextActions = new ArrayList();

    public IconicAppPage(Composite parent, int style, ApplicationModelPage page) {
        super(parent, style | 0x40000);
        this.selectedColor = new Color((Device)parent.getDisplay(), 223, 148, 125);
        this.unselectedColor = new Color((Device)parent.getDisplay(), 183, 202, 192);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IconicAppPage.this.selectedColor.dispose();
                IconicAppPage.this.unselectedColor.dispose();
            }
        });
        this.setBackground(parent.getBackground());
        this.listeners = new ArrayList();
        FillLayout layout = new FillLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        this.setLayout((Layout)layout);
        this.navigator = new ApplicationNavigator(page);
        this.navigator.createPartControl(this);
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.hookContextMenus();
    }

    private void hookContextMenus() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IconicAppPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.navigator.getControl());
        this.navigator.getControl().setMenu(menu);
        menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IconicAppPage.this.fillContextMenu(manager);
            }
        });
        menu = menuMgr.createContextMenu((Control)this);
        this.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
        Iterator iterator = this.contextActions.iterator();
        while (iterator.hasNext()) {
            manager.add((IAction)iterator.next());
        }
    }

    public void addContextAction(IAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null.");
        }
        this.contextActions.remove(action);
        this.contextActions.add(action);
    }

    public void removeContextAction(IAction action) {
        this.contextActions.remove(action);
    }

    public void paintControl(PaintEvent e) {
        e.gc.setAntialias(1);
        Color b = e.gc.getBackground();
        e.gc.setBackground(this.getParent().getBackground());
        e.gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
        if (this.selected) {
            e.gc.setBackground(this.selectedColor);
            e.gc.fillRoundRectangle(0, 0, this.getSize().x, this.getSize().y, 30, 30);
        } else {
            e.gc.setBackground(this.getParent().getBackground());
            e.gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
            Color f = e.gc.getForeground();
            e.gc.setForeground(this.unselectedColor);
            e.gc.drawRoundRectangle(1, 1, this.getSize().x - 2, this.getSize().y - 2, 30, 30);
            e.gc.setForeground(f);
        }
        e.gc.setBackground(Display.getCurrent().getSystemColor(1));
        e.gc.fillRoundRectangle(3, 3, this.getSize().x - 6, this.getSize().y - 6, 20, 20);
        e.gc.setBackground(b);
    }

    public ApplicationModelPage getPage() {
        return this.navigator.getPage();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.selected = true;
        this.fireSelection();
        this.redraw();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.redraw();
        if (selected) {
            this.fireSelection();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Selection listener cannot be null.");
        }
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSelection() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SelectionListener)iterator.next()).selected(this);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point p = super.computeSize(wHint, hHint, changed);
        if (p.x == -1 && p.y == -1) {
            p.x = 90;
            p.y = 120;
        } else if (p.x == -1) {
            p.x = p.y / 4 * 3;
        } else {
            p.y = p.x / 3 * 4;
        }
        return p;
    }

    public static interface SelectionListener {
        public void selected(IconicAppPage var1);
    }
}

