/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelObject;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationStartElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.Locatable;
import org.eclipse.vtp.desktop.ui.app.editor.model.Selectable;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIComponent;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIComponentListener;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIConnector;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeEntryElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeEntryRenderer;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeExitElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeExitRenderer;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.GraphicUpdateEvent;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.GraphicUpdateListener;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.PropertiesListener;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.SelectionListener;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.StructureListener;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.NodeList;

public class ApplicationModelPage
implements StructureListener,
UIComponentListener {
    public static final int POINTER_TOOL = 0;
    public static final int CONNECTOR_TOOL = 1;
    public static final int NO_LINE_LABELS = 1;
    public static final int NO_ELEMENT_LABELS = 2;
    public static final int NO_SELECTION = 4;
    public static final int NO_SHADOWS = 8;
    public static final int NO_DECORATORS = 16;
    public static final int NO_ICONS = 32;
    public static final int NO_WATERMARK = 64;
    public static final int NO_TITLE = 128;
    public static final int NO_BORDERS = 256;
    public static final int FLAT = 512;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private int currentTool;
    private List graphicListeners;
    private List selectionListeners;
    private List propertiesListeners;
    private List uiElements;
    private List uiConnectors;
    private List selectedObjects;
    private List locatables;
    private UIElement currentOrigin;
    private Selectable primarySelection;
    private int lastX;
    private int lastY;
    private int pwidth = 100;
    private int pheight = 100;
    public Map resourceMap;
    Font font = null;
    int lastW;
    int lastH;
    boolean hasPainted = false;
    Point multiselection;
    boolean validationInProgress = false;
    boolean mouseDown = false;
    ApplicationModel model;
    private String name;
    int lastMoveX = -1;
    int lastMoveY = -1;

    public ApplicationModelPage(ApplicationModel model) {
        this.model = model;
        this.resourceMap = model.resourceMap;
        model.addStructureListener(this);
        this.graphicListeners = new ArrayList();
        this.selectionListeners = new ArrayList();
        this.uiElements = new ArrayList();
        this.uiConnectors = new ArrayList();
        this.selectedObjects = new ArrayList();
        this.locatables = new ArrayList();
        this.propertiesListeners = new ArrayList();
    }

    public ApplicationModelPage(ApplicationModel model, String pageName) {
        this.name = pageName;
        this.model = model;
        this.resourceMap = model.resourceMap;
        model.addStructureListener(this);
        this.graphicListeners = new ArrayList();
        this.selectionListeners = new ArrayList();
        this.uiElements = new ArrayList();
        this.uiConnectors = new ArrayList();
        this.selectedObjects = new ArrayList();
        this.locatables = new ArrayList();
        this.propertiesListeners = new ArrayList();
    }

    public ApplicationModel getModel() {
        return this.model;
    }

    private UIElement findElement(String id) {
        Iterator iterator = this.uiElements.iterator();
        while (iterator.hasNext()) {
            UIElement uie = (UIElement)iterator.next();
            if (!uie.getId().equals(id)) continue;
            return uie;
        }
        return null;
    }

    public void clear() {
        UIElement[] uie = new UIElement[this.uiElements.size()];
        int i = 0;
        while (i < this.uiElements.size()) {
            uie[i] = (UIElement)this.uiElements.get(i);
            ++i;
        }
        i = 0;
        while (i < uie.length) {
            this.model.deleteElement(uie[i].getElement());
            ++i;
        }
        this.fireGraphicUpdate(null);
    }

    public void delete() {
        this.clear();
        this.model.deletePage(this);
        this.fireGraphicUpdate(null);
    }

    public void load(org.w3c.dom.Element pageElement) {
        try {
            this.name = pageElement.getAttribute("name");
            org.w3c.dom.Element[] componentElements = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)pageElement, (String)"elements"));
            int i = 0;
            while (i < componentElements.length) {
                String id = componentElements[i].getAttribute("instance-id");
                Element baseElement = this.model.getElement(id);
                int x = Integer.parseInt(componentElements[i].getAttribute("x"));
                this.pwidth = Math.max(this.pwidth, x);
                int y = Integer.parseInt(componentElements[i].getAttribute("y"));
                this.pheight = Math.max(this.pheight, y);
                UIElement el = new UIElement(baseElement);
                if (baseElement instanceof WormholeEntryElement) {
                    el.setRenderer(new WormholeEntryRenderer());
                } else if (baseElement instanceof WormholeExitElement) {
                    el.setRenderer(new WormholeExitRenderer());
                }
                el.setLocation(x, y);
                this.uiElements.add(el);
                el.setModelPage(this);
                el.addListener(this);
                ++i;
            }
            org.w3c.dom.Element[] connectors = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)pageElement, (String)"connectors"));
            int i2 = 0;
            while (i2 < connectors.length) {
                String connectorId = connectors[i2].getAttribute("instance-id");
                Connector con = this.model.getConnector(connectorId);
                if (con != null) {
                    org.w3c.dom.Element midPointsElement;
                    Point[] midPoints;
                    UIConnector connector = new UIConnector(this.findElement(con.getOrigin().getId()), this.findElement(con.getDestination().getId()), con, false);
                    connector.setModelPage(this);
                    NodeList nl = connectors[i2].getElementsByTagName("mid-points");
                    if (nl.getLength() > 0 && (midPoints = new Point[Integer.parseInt((midPointsElement = (org.w3c.dom.Element)nl.item(0)).getAttribute("number"))]).length > 0) {
                        org.w3c.dom.Element[] midPointElements = XMLUtilities.getElementsOfNodeList((NodeList)midPointsElement.getChildNodes());
                        int m = 0;
                        while (m < midPointElements.length) {
                            int x = Integer.parseInt(midPointElements[m].getAttribute("x"));
                            int y = Integer.parseInt(midPointElements[m].getAttribute("y"));
                            int index = Integer.parseInt(midPointElements[m].getAttribute("index"));
                            midPoints[index] = new Point(x, y);
                            ++m;
                        }
                        m = 0;
                        while (m < midPoints.length) {
                            connector.addMidPoint(midPoints[m].x, midPoints[m].y);
                            ++m;
                        }
                    }
                    if ((nl = connectors[i2].getElementsByTagName("label-position")).getLength() > 0) {
                        org.w3c.dom.Element labelPositionElement = (org.w3c.dom.Element)nl.item(0);
                        String segmentString = labelPositionElement.getAttribute("segment");
                        String loxString = labelPositionElement.getAttribute("lox");
                        String loyString = labelPositionElement.getAttribute("loy");
                        connector.setLabelLocation(Integer.parseInt(segmentString), Integer.parseInt(loxString), Integer.parseInt(loyString));
                    }
                    connector.addListener(this);
                    this.uiConnectors.add(connector);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToDocument(org.w3c.dom.Element pagesElement) {
        org.w3c.dom.Element pageElement = pagesElement.getOwnerDocument().createElement("ui-page");
        pageElement.setAttribute("name", this.getName());
        pagesElement.appendChild(pageElement);
        org.w3c.dom.Element elementsElement = pageElement.getOwnerDocument().createElement("elements");
        pageElement.appendChild(elementsElement);
        Iterator iterator = this.uiElements.iterator();
        while (iterator.hasNext()) {
            UIElement uie = (UIElement)iterator.next();
            uie.writeToDocument(elementsElement);
        }
        org.w3c.dom.Element connectorsElement = pageElement.getOwnerDocument().createElement("connectors");
        pageElement.appendChild(connectorsElement);
        iterator = this.uiConnectors.iterator();
        while (iterator.hasNext()) {
            UIConnector uic = (UIConnector)iterator.next();
            uic.writeToDocument(connectorsElement);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireGraphicUpdate(null);
        if (this.model != null) {
            this.model.fireInternalModified();
        }
    }

    public Point getGraphSize() {
        return new Point(this.pwidth, this.pheight);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void paint(Point origin, Point extent, GC gc) {
        this.paint(origin, extent, gc, 0);
    }

    public void paint(Point origin, Point extent, GC gc, int style) {
        Font titleFont;
        Color shadowFontColor;
        Color topFontColor;
        Color grey;
        gc.setFont(this.font);
        this.hasPainted = true;
        Rectangle r = new Rectangle(0, 0, 1, 1);
        Iterator iterator = this.uiElements.iterator();
        while (iterator.hasNext()) {
            UIElement el = (UIElement)iterator.next();
            r = r.union(el.calculateBounds(gc));
        }
        iterator = this.uiConnectors.iterator();
        while (iterator.hasNext()) {
            UIConnector con = (UIConnector)iterator.next();
            r = r.union(con.calculateBounds(gc));
        }
        this.pwidth = r.width;
        this.pheight = r.height;
        Color c = gc.getForeground();
        Color white = (Color)this.resourceMap.get("COLOR_WHITE");
        if (white == null) {
            white = new Color((Device)Display.getCurrent(), 255, 255, 255);
            this.resourceMap.put("COLOR_WHITE", white);
        }
        gc.setBackground(white);
        gc.fillRectangle(0, 0, this.pwidth, this.pheight);
        Color blue = (Color)this.resourceMap.get("COLOR_BLUE");
        if (blue == null) {
            blue = new Color((Device)Display.getCurrent(), 0, 0, 255);
            this.resourceMap.put("COLOR_BLUE", blue);
        }
        if ((grey = (Color)this.resourceMap.get("COLOR_GREY")) == null) {
            grey = new Color((Device)Display.getCurrent(), 200, 200, 200);
            this.resourceMap.put("COLOR_GREY", grey);
        }
        if ((topFontColor = (Color)this.resourceMap.get("COLOR_TOP_FONT")) == null) {
            topFontColor = new Color((Device)Display.getCurrent(), 202, 208, 126);
            this.resourceMap.put("COLOR_TOP_FONT", topFontColor);
        }
        if ((shadowFontColor = (Color)this.resourceMap.get("COLOR_SHADOW_FONT")) == null) {
            shadowFontColor = new Color((Device)Display.getCurrent(), 170, 174, 102);
            this.resourceMap.put("COLOR_SHADOW_FONT", shadowFontColor);
        }
        if ((titleFont = (Font)this.resourceMap.get("FONT_TITLE")) == null) {
            titleFont = new Font((Device)Display.getCurrent(), new FontData("verdana", 24, 1));
            this.resourceMap.put("FONT_TITLE", titleFont);
        }
        if (this.currentTool == 1 && this.currentOrigin != null) {
            gc.setForeground(blue);
            if (this.lastMoveX != -1 && this.lastMoveY != -1) {
                gc.drawLine(this.currentOrigin.getX(), this.currentOrigin.getY(), this.lastMoveX, this.lastMoveY);
            }
            gc.setForeground(c);
        }
        if ((style & 0x80) == 0) {
            Color fg = gc.getForeground();
            Font f = gc.getFont();
            gc.setFont(titleFont);
            Point p = gc.stringExtent(this.getName());
            gc.setForeground(shadowFontColor);
            gc.drawString(this.getName(), extent.x - p.x - 7, 6, true);
            gc.setForeground(topFontColor);
            gc.drawString(this.getName(), extent.x - p.x - 9, 3, true);
            gc.setFont(f);
            gc.setForeground(fg);
        }
        if ((style & 8) == 0) {
            iterator = this.uiElements.iterator();
            while (iterator.hasNext()) {
                UIElement el = (UIElement)iterator.next();
                el.paintShadows(this.resourceMap, gc);
            }
        }
        iterator = this.uiConnectors.iterator();
        while (iterator.hasNext()) {
            UIConnector con = (UIConnector)iterator.next();
            con.paint(this.resourceMap, gc, style);
        }
        if (this.currentTool == 0 && this.multiselection != null) {
            gc.setForeground(grey);
            gc.setLineStyle(3);
            int r1x = Math.min(this.lastX, this.multiselection.x);
            int r1y = Math.min(this.lastY, this.multiselection.y);
            int r2x = Math.max(this.lastX, this.multiselection.x);
            int r2y = Math.max(this.lastY, this.multiselection.y);
            gc.drawRectangle(r1x, r1y, r2x - r1x, r2y - r1y);
            gc.setLineStyle(1);
            gc.setForeground(c);
        }
        iterator = this.uiElements.iterator();
        while (iterator.hasNext()) {
            UIElement el = (UIElement)iterator.next();
            el.paint(this.resourceMap, gc, style);
        }
    }

    public List getSelectedObjects() {
        return this.selectedObjects;
    }

    public void toggleLinePoint() {
        if (this.selectedObjects.size() > 0 && this.selectedObjects.get(0) instanceof UIConnector) {
            ((UIConnector)this.selectedObjects.get(0)).toggleLinePoint(this.lastX, this.lastY);
        }
    }

    public void updateRequested(UIComponent component) {
        if (!this.validationInProgress) {
            this.fireGraphicUpdate(null);
        }
    }

    public void deleteSelectedObjects() {
        Iterator iterator = this.selectedObjects.iterator();
        while (iterator.hasNext()) {
            Object selectedObject = iterator.next();
            if (selectedObject instanceof UIConnector) {
                this.deleteConnector((UIConnector)selectedObject);
                continue;
            }
            if (((UIElement)selectedObject).getElement() instanceof ApplicationStartElement) continue;
            this.deleteElement((UIElement)selectedObject);
        }
        this.selectedObjects.clear();
        this.primarySelection = null;
        this.locatables.clear();
        this.model.validateStatus();
        this.fireGraphicUpdate(null);
    }

    public void alignSelectedObjects(int style) {
        UIElement[] elements = this.selectedObjects.toArray(new UIElement[this.selectedObjects.size()]);
        UIElement targetElement = (UIElement)this.primarySelection;
        int i = 0;
        while (i < elements.length) {
            UIElement ce = elements[i];
            switch (style) {
                case 1: {
                    if (ce == targetElement) break;
                    ce.setLocation(targetElement.upperLeft.x + ce.x - ce.upperLeft.x, ce.y);
                    break;
                }
                case 2: {
                    if (ce == targetElement) break;
                    ce.setLocation(ce.x, targetElement.upperLeft.y + ce.y - ce.upperLeft.y);
                    break;
                }
                case 4: {
                    if (ce == targetElement) break;
                    ce.setLocation(targetElement.lowerRight.x - (ce.lowerRight.x - ce.x), ce.y);
                    break;
                }
                case 8: {
                    if (ce == targetElement) break;
                    ce.setLocation(ce.x, targetElement.lowerRight.y - (ce.lowerRight.y - ce.y));
                }
            }
            ++i;
        }
        this.model.fireInternalModified();
        this.fireGraphicUpdate(null);
    }

    public void centerSelectedObjects(int style) {
        UIElement[] elements = this.selectedObjects.toArray(new UIElement[this.selectedObjects.size()]);
        UIElement targetElement = (UIElement)this.primarySelection;
        int i = 0;
        while (i < elements.length) {
            UIElement ce = elements[i];
            switch (style) {
                case 1: {
                    if (ce == targetElement) break;
                    ce.setLocation(ce.x, targetElement.y);
                    break;
                }
                case 2: {
                    if (ce == targetElement) break;
                    ce.setLocation(targetElement.x, ce.y);
                }
            }
            ++i;
        }
        this.model.fireInternalModified();
        this.fireGraphicUpdate(null);
    }

    public void spaceEvenlySelectedObjects(int style) {
        UIElement[] elements = this.selectedObjects.toArray(new UIElement[this.selectedObjects.size()]);
        switch (style) {
            case 1: {
                elements = this.sortHorizontal(elements);
                break;
            }
            case 2: {
                elements = this.sortVertical(elements);
            }
        }
        UIElement targetElement = (UIElement)this.primarySelection;
        UIElement lowElement = elements[0];
        UIElement highElement = elements[elements.length - 1];
        int targetIndex = -1;
        int i = 0;
        while (i < elements.length) {
            if (elements[i] == targetElement) {
                targetIndex = i;
            }
            ++i;
        }
        double spread = style == 1 ? highElement.x - lowElement.x : highElement.y - lowElement.y;
        double spacing = spread / ((double)elements.length - 1.0);
        int i2 = 0;
        while (i2 < elements.length) {
            UIElement ce = elements[i2];
            switch (style) {
                case 1: {
                    if (ce == targetElement) break;
                    ce.setLocation(targetElement.x - (int)((double)(targetIndex - i2) * spacing), ce.y);
                    break;
                }
                case 2: {
                    if (ce == targetElement) break;
                    ce.setLocation(ce.x, targetElement.y - (int)((double)(targetIndex - i2) * spacing));
                }
            }
            ++i2;
        }
        this.model.fireInternalModified();
        this.fireGraphicUpdate(null);
    }

    private UIElement[] sortHorizontal(UIElement[] elements) {
        int i = 0;
        while (i < elements.length - 1) {
            int j = 0;
            while (j < elements.length - 1 - i) {
                if (elements[j + 1].x < elements[j].x) {
                    UIElement temp = elements[j];
                    elements[j] = elements[j + 1];
                    elements[j + 1] = temp;
                }
                ++j;
            }
            ++i;
        }
        return elements;
    }

    private UIElement[] sortVertical(UIElement[] elements) {
        int i = 0;
        while (i < elements.length - 1) {
            int j = 0;
            while (j < elements.length - 1 - i) {
                if (elements[j + 1].y < elements[j].y) {
                    UIElement temp = elements[j];
                    elements[j] = elements[j + 1];
                    elements[j + 1] = temp;
                }
                ++j;
            }
            ++i;
        }
        return elements;
    }

    public void deleteConnector(UIConnector connector) {
        this.model.deleteConnector(connector.getConnector());
    }

    public void deleteElement(UIElement element) {
        this.model.deleteElement(element.getElement());
    }

    public void addElement(Element element, int x, int y) {
        UIElement uiElement = new UIElement(element);
        if (element instanceof WormholeEntryElement) {
            uiElement.setRenderer(new WormholeEntryRenderer());
        } else if (element instanceof WormholeExitElement) {
            uiElement.setRenderer(new WormholeExitRenderer());
        }
        this.uiElements.add(uiElement);
        uiElement.addListener(this);
        uiElement.setLocation(x, y);
        this.model.addElement(element);
        this.fireGraphicUpdate(null);
        this.fireGraphicUpdate(null);
    }

    public void addElement(Element element) {
        this.addElement(element, 50, 50);
    }

    public int getCurrentTool() {
        return this.currentTool;
    }

    public void setCurrentTool(int currentTool) {
        this.currentTool = currentTool;
    }

    public UIConnector getConnectorAt(int x, int y) {
        int i = this.uiConnectors.size() - 1;
        while (i > -1) {
            UIConnector connector = (UIConnector)this.uiConnectors.get(i);
            if (connector.contains(x, y)) {
                return connector;
            }
            --i;
        }
        return null;
    }

    public UIElement getElementAt(int x, int y) {
        int i = this.uiElements.size() - 1;
        while (i > -1) {
            UIElement element = (UIElement)this.uiElements.get(i);
            if (element.contains(x, y)) {
                return element;
            }
            --i;
        }
        return null;
    }

    public List getElementsIn(Rectangle rect) {
        ArrayList<UIElement> containedElements = new ArrayList<UIElement>();
        int i = 0;
        while (i < this.uiElements.size()) {
            UIElement element = (UIElement)this.uiElements.get(i);
            if (element.containedIn(rect)) {
                containedElements.add(element);
            }
            ++i;
        }
        return containedElements;
    }

    public UIComponent getEditorComponentAt(int x, int y) {
        UIComponent ec = this.getElementAt(x, y);
        if (ec == null) {
            ec = this.getConnectorAt(x, y);
        }
        return ec;
    }

    private void clearSelections() {
        Iterator iterator = this.selectedObjects.iterator();
        while (iterator.hasNext()) {
            Selectable sel = (Selectable)iterator.next();
            sel.setSelected(false);
        }
        this.primarySelection = null;
        this.selectedObjects.clear();
    }

    public void processMouseDown(int tool, MouseEvent e) {
        this.currentTool = tool;
        this.mouseDown = true;
        this.lastX = e.x;
        this.lastY = e.y;
        UIComponent ec = this.getEditorComponentAt(this.lastX, this.lastY);
        if (ec == null) {
            if ((e.stateMask & 0x20000) != 131072) {
                this.clearSelections();
            }
            this.locatables.clear();
            this.multiselection = new Point(this.lastX, this.lastY);
        } else if (this.currentTool == 1) {
            this.clearSelections();
            this.locatables.clear();
            if (ec instanceof Selectable) {
                Selectable selectable = (Selectable)((Object)ec);
                selectable.setSelected(true);
                this.selectedObjects.add(selectable);
                this.primarySelection = selectable;
                this.dispatchSelectionChanged();
            }
            if (ec instanceof UIElement && ((UIElement)ec).getElement() instanceof ConnectorOrigin) {
                this.currentOrigin = (UIElement)ec;
            }
        } else if (ec instanceof UIConnector) {
            Locatable loc;
            this.clearSelections();
            this.locatables.clear();
            if (ec instanceof Selectable) {
                Selectable selectable = (Selectable)((Object)ec);
                selectable.setSelected(true);
                this.selectedObjects.add(selectable);
                this.primarySelection = selectable;
                this.dispatchSelectionChanged();
            }
            if ((loc = ec.getLocatable(this.lastX, this.lastY)) != null) {
                this.locatables.add(new LocatableRecord(ec, loc, e.x - loc.getX(), e.y - loc.getY()));
            }
        } else if ((e.stateMask & 0x20000) == 131072) {
            if (this.selectedObjects.size() > 0 && this.selectedObjects.get(0) instanceof UIConnector) {
                this.clearSelections();
                this.locatables.clear();
                if (ec instanceof Selectable) {
                    Selectable selectable = (Selectable)((Object)ec);
                    selectable.setSelected(true);
                    this.selectedObjects.add(selectable);
                    this.primarySelection = selectable;
                    this.dispatchSelectionChanged();
                }
            } else if (this.selectedObjects.contains(ec)) {
                this.selectedObjects.remove(ec);
                if (this.primarySelection == ec) {
                    this.primarySelection = null;
                    if (this.selectedObjects.size() > 0) {
                        this.primarySelection = (Selectable)this.selectedObjects.get(0);
                    }
                }
                Selectable selectable = (Selectable)((Object)ec);
                selectable.setSelected(false);
                Iterator iterator = this.locatables.iterator();
                while (iterator.hasNext()) {
                    LocatableRecord lr = (LocatableRecord)iterator.next();
                    if (lr.parent != ec) continue;
                    iterator.remove();
                }
            } else if (ec instanceof Selectable) {
                Selectable selectable = (Selectable)((Object)ec);
                selectable.setSelected(true);
                this.selectedObjects.add(selectable);
                this.primarySelection = selectable;
                this.dispatchSelectionChanged();
            }
        } else if (!this.selectedObjects.contains(ec)) {
            Locatable loc;
            this.clearSelections();
            this.locatables.clear();
            if (ec instanceof Selectable) {
                Selectable selectable = (Selectable)((Object)ec);
                selectable.setSelected(true);
                this.selectedObjects.add(selectable);
                this.primarySelection = selectable;
                this.dispatchSelectionChanged();
            }
            if ((loc = ec.getLocatable(this.lastX, this.lastY)) != null) {
                this.locatables.add(new LocatableRecord(ec, loc, e.x - loc.getX(), e.y - loc.getY()));
            }
        } else {
            this.locatables.clear();
            Iterator iterator = this.selectedObjects.iterator();
            while (iterator.hasNext()) {
                Locatable loc = (Locatable)iterator.next();
                this.locatables.add(new LocatableRecord((UIComponent)((Object)loc), loc, e.x - loc.getX(), e.y - loc.getY()));
            }
            if (ec instanceof UIElement) {
                this.primarySelection = (Selectable)((Object)ec);
            }
        }
        this.fireGraphicUpdate(null);
    }

    public List getSelectedObjectProperties(Selectable selectable) {
        List ret = new ArrayList();
        if (selectable != null) {
            ret = ((UIComponent)((Object)selectable)).getPropertyPanels();
        }
        return ret;
    }

    public void processMouseUp(int tool, MouseEvent e) {
        this.currentTool = tool;
        if (this.currentTool == 1) {
            if (this.currentOrigin != null) {
                UIElement element = this.getElementAt(e.x, e.y);
                if (element != null && element.getElement() instanceof ConnectorDestination) {
                    Connector c = new Connector((ConnectorOrigin)((Object)this.currentOrigin.getElement()), (ConnectorDestination)((Object)element.getElement()));
                    this.model.addConnector(c);
                    UIConnector con = new UIConnector(this.currentOrigin, element, c, this.currentOrigin.getElement() == element.getElement());
                    con.setModelPage(this);
                    this.uiConnectors.add(con);
                    con.addListener(this);
                    this.clearSelections();
                    UIConnector selectable = con;
                    selectable.setSelected(true);
                    this.selectedObjects.add(selectable);
                    this.primarySelection = selectable;
                    this.dispatchSelectionChanged();
                    this.dispatchDisplayProperties();
                }
                this.currentOrigin = null;
            }
        } else if (this.locatables.size() > 0) {
            this.pwidth = 0;
            this.pheight = 0;
            Iterator iterator = this.uiElements.iterator();
            while (iterator.hasNext()) {
                UIElement el = (UIElement)iterator.next();
                this.pwidth = Math.max(this.pwidth, el.getLowerRight().x + 10);
                this.pheight = Math.max(this.pheight, el.getLowerRight().y + 10);
            }
            iterator = this.uiConnectors.iterator();
            while (iterator.hasNext()) {
                UIConnector con = (UIConnector)iterator.next();
                Rectangle rec = con.getBounds();
                this.pwidth = Math.max(this.pwidth, rec.width + rec.x + 10);
                this.pheight = Math.max(this.pheight, rec.height + rec.y + 10);
            }
        } else if (this.multiselection != null) {
            UIElement el;
            if ((e.stateMask & 0x20000) != 131072) {
                this.clearSelections();
            }
            int r1x = Math.min(this.lastX, this.multiselection.x);
            int r1y = Math.min(this.lastY, this.multiselection.y);
            int r2x = Math.max(this.lastX, this.multiselection.x);
            int r2y = Math.max(this.lastY, this.multiselection.y);
            Rectangle selRect = new Rectangle(r1x, r1y, r2x - r1x, r2y - r1y);
            List selList = this.getElementsIn(selRect);
            Iterator iterator = selList.iterator();
            while (iterator.hasNext()) {
                el = (UIElement)iterator.next();
                if (this.selectedObjects.contains(el)) continue;
                el.setSelected(true);
                this.selectedObjects.add(el);
                if (this.primarySelection != null) continue;
                this.primarySelection = el;
            }
            this.pwidth = 0;
            this.pheight = 0;
            iterator = this.uiElements.iterator();
            while (iterator.hasNext()) {
                el = (UIElement)iterator.next();
                this.pwidth = Math.max(this.pwidth, el.getLowerRight().x + 10);
                this.pheight = Math.max(this.pheight, el.getLowerRight().y + 10);
            }
            iterator = this.uiConnectors.iterator();
            while (iterator.hasNext()) {
                UIConnector con = (UIConnector)iterator.next();
                Rectangle rec = con.getBounds();
                this.pwidth = Math.max(this.pwidth, rec.width + rec.x + 10);
                this.pheight = Math.max(this.pheight, rec.height + rec.y + 10);
            }
            this.multiselection = null;
        }
        this.lastMoveX = -1;
        this.lastMoveY = -1;
        this.locatables.clear();
        this.mouseDown = false;
        this.fireGraphicUpdate(null);
    }

    public void processMouseMove(int tool, MouseEvent e) {
        this.currentTool = tool;
        if (this.mouseDown) {
            this.lastMoveX = e.x;
            this.lastMoveY = e.y;
            if (this.currentTool == 0) {
                if (this.locatables.size() > 0) {
                    Locatable locatable;
                    int dx = Integer.MAX_VALUE;
                    int dy = Integer.MAX_VALUE;
                    int newBottom = 0;
                    int newRight = 0;
                    Iterator iterator = this.locatables.iterator();
                    while (iterator.hasNext()) {
                        LocatableRecord record = (LocatableRecord)iterator.next();
                        locatable = record.locatable;
                        int moveX = e.x - record.dragOffsetX;
                        int moveY = e.y - record.dragOffsetY;
                        int distanceFromTop = locatable.getUpperLeft().y + (moveY - locatable.getY());
                        int distanceFromLeft = locatable.getUpperLeft().x + (moveX - locatable.getX());
                        int newBottomi = locatable.getLowerRight().y + (moveY - locatable.getY()) + 10;
                        int newRighti = locatable.getLowerRight().x + (moveX - locatable.getX()) + 10;
                        if (distanceFromTop <= 0) {
                            moveY = locatable.getY() - locatable.getUpperLeft().y;
                            distanceFromTop = 0;
                        }
                        if (distanceFromLeft <= 0) {
                            moveX = locatable.getX() - locatable.getUpperLeft().x;
                            distanceFromLeft = 0;
                        }
                        if (newBottomi >= 1960) {
                            moveY = 1950 - (locatable.getLowerRight().y - locatable.getY());
                            newBottomi = 1960;
                        }
                        if (newRighti >= 1960) {
                            moveX = 1950 - (locatable.getLowerRight().x - locatable.getX());
                            newRighti = 1960;
                        }
                        dx = this.minDistanceZero(dx, moveX - locatable.getX());
                        dy = this.minDistanceZero(dy, moveY - locatable.getY());
                        newBottom = Math.max(newBottom, newBottomi);
                        newRight = Math.max(newRight, newRighti);
                    }
                    if (newRight > this.pwidth) {
                        this.pwidth = newRight;
                    }
                    if (newBottom > this.pheight) {
                        this.pheight = newBottom;
                    }
                    iterator = this.locatables.iterator();
                    Rectangle focusArea = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
                    while (iterator.hasNext()) {
                        locatable = ((LocatableRecord)iterator.next()).locatable;
                        locatable.setLocation(locatable.getX() + dx, locatable.getY() + dy);
                        if (!this.model.isModified()) {
                            this.model.fireInternalModified();
                        }
                        focusArea.x = Math.min(focusArea.x, locatable.getUpperLeft().x);
                        focusArea.y = Math.min(focusArea.y, locatable.getUpperLeft().y);
                        focusArea.width = Math.max(focusArea.width, locatable.getLowerRight().x - focusArea.x);
                        focusArea.height = Math.max(focusArea.height, locatable.getLowerRight().y - focusArea.y);
                    }
                    this.fireGraphicUpdate(focusArea);
                }
                if (this.multiselection != null) {
                    int mx = e.x;
                    int my = e.y;
                    if (mx < 0) {
                        mx = 0;
                    } else if (mx > 1950) {
                        mx = 1950;
                    }
                    if (my < 0) {
                        my = 0;
                    } else if (my > 1950) {
                        my = 1950;
                    }
                    this.multiselection = new Point(mx, my);
                    if (Math.min(e.x + 10, 1960) > this.pwidth) {
                        this.pwidth = Math.min(e.x + 10, 1960);
                    }
                    if (Math.min(e.y + 10, 1960) > this.pheight) {
                        this.pheight = Math.min(e.y + 10, 1960);
                    }
                    Rectangle focusArea = new Rectangle(e.x < 10 ? 0 : e.x - 10, e.y < 10 ? 0 : e.y - 10, Math.min(1960 - e.x, 20), Math.min(1960 - e.y, 20));
                    this.fireGraphicUpdate(focusArea);
                }
            } else if (this.currentTool == 1 && this.currentOrigin != null) {
                Rectangle focusArea = new Rectangle(Math.max(0, this.lastX - 10), Math.max(0, this.lastY - 10), this.lastX < 10 ? 10 : 20, this.lastY < 10 ? 10 : 20);
                this.fireGraphicUpdate(focusArea);
            }
        }
    }

    private int minDistanceZero(int a, int b) {
        int at = a;
        int bt = b;
        if (at < 0) {
            at *= -1;
        }
        if (bt < 0) {
            bt *= -1;
        }
        if (at < bt) {
            return a;
        }
        if (bt < at) {
            return b;
        }
        return a;
    }

    public void addGraphicListener(GraphicUpdateListener listener) {
        this.graphicListeners.remove(listener);
        this.graphicListeners.add(listener);
    }

    public void removeGraphicListener(GraphicUpdateListener listener) {
        this.graphicListeners.remove(listener);
    }

    protected void fireGraphicUpdate(Rectangle focusArea) {
        GraphicUpdateEvent e = new GraphicUpdateEvent();
        e.clientArea = this.getGraphSize();
        e.focusArea = focusArea;
        e.finished = !this.mouseDown;
        Iterator iterator = this.graphicListeners.iterator();
        while (iterator.hasNext()) {
            GraphicUpdateListener gl = (GraphicUpdateListener)iterator.next();
            gl.graphicUpdate(e);
        }
    }

    public void addPropertiesListener(PropertiesListener listener) {
        this.propertiesListeners.remove(listener);
        this.propertiesListeners.add(listener);
    }

    public void removePropertiesListener(PropertiesListener listener) {
        this.propertiesListeners.remove(listener);
    }

    private void dispatchDisplayProperties() {
        new Thread(new Runnable(){

            public void run() {
                Iterator iterator = ApplicationModelPage.this.propertiesListeners.iterator();
                while (iterator.hasNext()) {
                    ((PropertiesListener)iterator.next()).displayProperties();
                }
            }
        }).start();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void dispatchSelectionChanged() {
        new Thread(new Runnable(){

            public void run() {
                Iterator iterator = ApplicationModelPage.this.selectionListeners.iterator();
                while (iterator.hasNext()) {
                    ((SelectionListener)iterator.next()).selectionChanged(ApplicationModelPage.this);
                }
            }
        }).start();
    }

    public void objectAdded(ApplicationModelObject target) {
    }

    public void objectRemoved(ApplicationModelObject target) {
        if (target instanceof Element) {
            Iterator iterator = this.uiElements.iterator();
            while (iterator.hasNext()) {
                UIElement element = (UIElement)iterator.next();
                if (element.getElement() != target) continue;
                iterator.remove();
                element.removeListener(this);
                break;
            }
        } else {
            Iterator iterator = this.uiConnectors.iterator();
            while (iterator.hasNext()) {
                UIConnector connector = (UIConnector)iterator.next();
                if (connector.getConnector() != target) continue;
                iterator.remove();
                connector.removeListener(this);
                break;
            }
        }
        this.model.fireInternalModified();
    }

    public void updateStatusRequested(UIComponent component) {
    }

    public void modifiedRequest(UIComponent component) {
        this.fireGraphicUpdate(null);
    }

    public void validate() {
        this.model.validateStatus();
        this.fireGraphicUpdate(null);
    }

    class LocatableRecord {
        Locatable locatable;
        UIComponent parent;
        int dragOffsetX;
        int dragOffsetY;

        LocatableRecord(UIComponent parent, Locatable locatable, int dx, int dy) {
            this.parent = parent;
            this.locatable = locatable;
            this.dragOffsetX = dx;
            this.dragOffsetY = dy;
        }
    }
}

