/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComparisonPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;

public class ComparisonElement
extends Element
implements ConnectorDestination,
ConnectorOrigin {
    List incomingConnectors;
    ConnectorRecord cTrue = new ConnectorRecord(this, "True", ConnectorRecord.EXIT_POINT);
    ConnectorRecord cFalse = new ConnectorRecord(this, "False", ConnectorRecord.EXIT_POINT);
    ConnectorRecord error = new ConnectorRecord(this, "error.javascript", ConnectorRecord.ERROR_POINT);
    private List listeners = new ArrayList();
    private int lType = 0;
    private String lValue = "";
    private int compType = 0;
    private int rType = 0;
    private String rValue = "";
    MediaProvider provider = null;

    public ComparisonElement(String name) {
        super(name);
        this.incomingConnectors = new ArrayList();
    }

    public ComparisonElement(String id, String name) {
        super(id, name);
        this.incomingConnectors = new ArrayList();
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("True")) {
            return this.cTrue;
        }
        if (name.equals("False")) {
            return this.cFalse;
        }
        if (name.equals("error.javascript")) {
            return this.error;
        }
        return null;
    }

    public List getHooks() {
        return this.getFreeHooks();
    }

    public List getFreeHooks() {
        return Collections.unmodifiableList(new ArrayList());
    }

    public List getExits() {
        return Collections.unmodifiableList(Arrays.asList(this.cTrue, this.cFalse, this.error));
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        if (this.cTrue.getConnector() == null) {
            freeExits.add(this.cTrue);
        }
        if (this.cFalse.getConnector() == null) {
            freeExits.add(this.cFalse);
        }
        if (this.error.getConnector() == null) {
            freeExits.add(this.error);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isErrorFrom = false;
        boolean isAllExitsUsed = true;
        boolean hasErrorFrom = true;
        if (this.cTrue.getConnector() == null || this.cFalse.getConnector() == null) {
            isAllExitsUsed = false;
        }
        isErrorFrom = this.error.getConnector() != null;
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null)) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isAllExitsUsed) {
            this.setError(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<ComparisonElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public MediaProvider getMediaProvider() {
        return this.provider;
    }

    public String getTagName() {
        return "comparison";
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new ComparisonPropertiesPanel(this));
        return ret;
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }

    public int getCompType() {
        return this.compType;
    }

    public void setCompType(int compType) {
        this.compType = compType;
    }

    public int getLType() {
        return this.lType;
    }

    public void setLType(int type) {
        this.lType = type;
    }

    public String getLValue() {
        return this.lValue;
    }

    public void setLValue(String value) {
        this.lValue = value;
    }

    public int getRType() {
        return this.rType;
    }

    public void setRType(int type) {
        this.rType = type;
    }

    public String getRValue() {
        return this.rValue;
    }

    public void setRValue(String value) {
        this.rValue = value;
    }

    public void readSettings(org.w3c.dom.Element element) {
        this.lType = Integer.parseInt(element.getAttribute("lType"));
        this.lValue = element.getAttribute("lValue");
        this.compType = Integer.parseInt(element.getAttribute("cType"));
        this.rType = Integer.parseInt(element.getAttribute("rType"));
        this.rValue = element.getAttribute("rValue");
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("lType", Integer.toString(this.lType));
        element.setAttribute("lValue", this.lValue);
        element.setAttribute("cType", Integer.toString(this.compType));
        element.setAttribute("rType", Integer.toString(this.rType));
        element.setAttribute("rValue", this.rValue);
    }
}

