/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelObject;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.DataPoint;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Connector
extends ApplicationModelObject {
    private ConnectorOrigin origin;
    private ConnectorDestination destination;
    protected List exitCodes;
    Map dataPoints = new HashMap();

    public Connector(ConnectorOrigin origin, ConnectorDestination destination) {
        this.origin = origin;
        this.destination = destination;
        this.exitCodes = new ArrayList();
    }

    public Connector(String id, ConnectorOrigin origin, ConnectorDestination destination) {
        super(id);
        this.origin = origin;
        this.destination = destination;
        this.exitCodes = new ArrayList();
    }

    public void writeToDocument(Element parent) {
        Element connectorElement = parent.getOwnerDocument().createElement("destination");
        parent.appendChild(connectorElement);
        connectorElement.setAttribute("instance-id", this.getId());
        Element originElement = parent.getOwnerDocument().createElement("origin");
        connectorElement.appendChild(originElement);
        originElement.setAttribute("instance-id", this.origin.getId());
        Element targetElement = parent.getOwnerDocument().createElement("target");
        connectorElement.appendChild(targetElement);
        targetElement.setAttribute("instance-id", this.destination.getId());
        Iterator<Object> iterator = this.exitCodes.iterator();
        while (iterator.hasNext()) {
            Element endPointElement;
            ConnectorRecord record = (ConnectorRecord)iterator.next();
            if (record.getType() == ConnectorRecord.HOOK_POINT) {
                endPointElement = parent.getOwnerDocument().createElement("hookpoint-reference");
                originElement.appendChild(endPointElement);
                endPointElement.setAttribute("end-point-name", record.getName());
                continue;
            }
            endPointElement = parent.getOwnerDocument().createElement("endpoint-reference");
            originElement.appendChild(endPointElement);
            endPointElement.setAttribute("end-point-name", record.getName());
        }
        Element midPointsElement = parent.getOwnerDocument().createElement("mid-points");
        connectorElement.appendChild(midPointsElement);
        iterator = this.dataPoints.values().iterator();
        while (iterator.hasNext()) {
            List l = (List)iterator.next();
            int i = 0;
            while (i < l.size()) {
                DataPoint dp = (DataPoint)l.get(i);
                Element dpElement = parent.getOwnerDocument().createElement("data-point");
                connectorElement.appendChild(dpElement);
                dpElement.setAttribute("parent", dp.getParent());
                dpElement.setAttribute("name", dp.getName());
                dpElement.setAttribute("type", (String)DataPoint.TYPE_NAMES.get(dp.getType()));
                dpElement.setAttribute("value", dp.getValue());
                ++i;
            }
        }
    }

    public void readSettings(Element parent) {
        NodeList nl = parent.getElementsByTagName("data-point");
        int i = 0;
        while (i < nl.getLength()) {
            Element dataPointElement = (Element)nl.item(i);
            String parentName = dataPointElement.getAttribute("parent");
            String name = dataPointElement.getAttribute("name");
            String type = dataPointElement.getAttribute("type");
            String value = dataPointElement.getAttribute("value");
            ArrayList<DataPoint> dpList = (ArrayList<DataPoint>)this.dataPoints.get(parentName);
            if (dpList == null) {
                dpList = new ArrayList<DataPoint>();
                this.dataPoints.put(parentName, dpList);
            }
            dpList.add(new DataPoint(parentName, name, DataPoint.getTypeByName(type), value));
            ++i;
        }
    }

    public void setDestination(ConnectorDestination destination) {
        this.destination = destination;
    }

    public void setOrigin(ConnectorOrigin origin) {
        this.origin = origin;
    }

    public void addExitPoint(ConnectorRecord record) {
        if (record != null) {
            record.setConnector(this);
            this.exitCodes.add(record);
        }
    }

    public void removeExitPoint(ConnectorRecord record) {
        record.setConnector(null);
        this.exitCodes.remove(record);
    }

    public List getExitCodes() {
        return Collections.unmodifiableList(this.exitCodes);
    }

    public void delete() {
        Iterator iterator = this.exitCodes.iterator();
        while (iterator.hasNext()) {
            ((ConnectorRecord)iterator.next()).setConnector(null);
        }
        this.exitCodes.clear();
    }

    public ConnectorDestination getDestination() {
        return this.destination;
    }

    public ConnectorOrigin getOrigin() {
        return this.origin;
    }

    public Map getDataPoints() {
        return this.dataPoints;
    }

    public void setDataPoints(Map dataPoints) {
        this.dataPoints = dataPoints;
    }
}

