/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.BlankMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;

public class DisconnectElement
extends Element
implements ConnectorDestination {
    private List incomingConnectors;
    private MediaProvider mediaProvider = new BlankMediaProvider(this.getId(), "Disconnect", "builtin.disconnect.1_0_0_0");

    public DisconnectElement(String promptName) {
        super("Hang Up");
        this.incomingConnectors = new ArrayList();
    }

    public DisconnectElement(String id, String promptName) {
        super(id, "Hang Up");
        this.incomingConnectors = new ArrayList();
    }

    public void validateStatus() {
        super.validateStatus();
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart()) {
            this.setError(true);
        }
    }

    public boolean hasPathToStart() {
        ArrayList<DisconnectElement> originPath = new ArrayList<DisconnectElement>();
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public String getTagName() {
        return "disconnect";
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public MediaProvider getMediaProvider() {
        return this.mediaProvider;
    }
}

