/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.core.project.IBusinessObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.ForEachVariablePropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;

public class ForEachElement
extends Element
implements ConnectorDestination,
ConnectorOrigin {
    List incomingConnectors;
    ConnectorRecord nextItem = new ConnectorRecord(this, "Next Item", ConnectorRecord.HOOK_POINT);
    ConnectorRecord noMoreItems = new ConnectorRecord(this, "No More Items", ConnectorRecord.EXIT_POINT);
    ConnectorRecord mainMenu = new ConnectorRecord(this, "Main Menu", ConnectorRecord.EXIT_POINT);
    ConnectorRecord optOut = new ConnectorRecord(this, "Opt Out", ConnectorRecord.EXIT_POINT);
    ConnectorRecord noItems = new ConnectorRecord(this, "No Items", ConnectorRecord.EXIT_POINT);
    String varName;
    int varMulti;
    String varType;
    boolean allowUserNav = false;
    boolean supportBack = false;
    boolean supportMainMenu = false;
    boolean supportOptOut = false;
    private List listeners = new ArrayList();

    public ForEachElement(String name) {
        super(name);
        this.incomingConnectors = new ArrayList();
    }

    public ForEachElement(String id, String name) {
        super(id, name);
        this.incomingConnectors = new ArrayList();
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("Next Item")) {
            return this.nextItem;
        }
        if (name.equals("No More Items")) {
            return this.noMoreItems;
        }
        if (name.equals("Main Menu")) {
            return this.mainMenu;
        }
        if (name.equals("Opt Out")) {
            return this.optOut;
        }
        if (name.equals("No Items")) {
            return this.noItems;
        }
        return null;
    }

    public List getHooks() {
        return Collections.unmodifiableList(Arrays.asList(this.nextItem));
    }

    public List getFreeHooks() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        if (this.nextItem.getConnector() == null) {
            freeExits.add(this.nextItem);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public List getExits() {
        return Collections.unmodifiableList(Arrays.asList(this.noMoreItems, this.noItems));
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        if (this.noMoreItems.getConnector() == null) {
            freeExits.add(this.noMoreItems);
        }
        if (this.noItems.getConnector() == null) {
            freeExits.add(this.noItems);
        }
        if (this.allowUserNav) {
            if (this.supportMainMenu && this.mainMenu.getConnector() == null) {
                freeExits.add(this.mainMenu);
            }
            if (this.supportOptOut && this.optOut.getConnector() == null) {
                freeExits.add(this.optOut);
            }
        }
        return Collections.unmodifiableList(freeExits);
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isExitedFrom = false;
        boolean isErrorFrom = false;
        boolean hasErrorFrom = false;
        if (this.noMoreItems.getConnector() != null) {
            isExitedFrom = true;
        }
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null)) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isExitedFrom) {
            this.setWarning(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<ForEachElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("var-name", this.varName == null ? "" : this.varName);
        element.setAttribute("var-multi", Integer.toString(this.varMulti));
        element.setAttribute("var-type", this.varType == null ? "" : this.varType);
        element.setAttribute("user-nav", Boolean.toString(this.allowUserNav));
        element.setAttribute("support-back", Boolean.toString(this.supportBack));
        element.setAttribute("support-main-menu", Boolean.toString(this.supportMainMenu));
        element.setAttribute("support-opt-out", Boolean.toString(this.supportOptOut));
    }

    public void readSettings(org.w3c.dom.Element element) {
        this.varName = element.getAttribute("var-name");
        this.varMulti = Integer.parseInt(element.getAttribute("var-multi"));
        this.varType = element.getAttribute("var-type");
        this.allowUserNav = Boolean.valueOf(element.getAttribute("user-nav"));
        this.supportBack = Boolean.valueOf(element.getAttribute("support-back"));
        this.supportMainMenu = Boolean.valueOf(element.getAttribute("support-main-menu"));
        this.supportOptOut = Boolean.valueOf(element.getAttribute("support-opt-out"));
    }

    public MediaProvider getMediaProvider() {
        return null;
    }

    public String getTagName() {
        return "for-each";
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new ForEachVariablePropertiesPanel(this));
        return ret;
    }

    public List getIncomingVariables() {
        ArrayList ret = new ArrayList();
        ArrayList visited = new ArrayList();
        this.getVariables("", ret, visited);
        return ret;
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
            if (endPointName.equals("Next Item") && this.varName != null && !this.varName.equals("")) {
                FieldType ft = FieldType.custom((String)this.varType, (boolean)this.isObject(this.varType), (boolean)false, (int)0);
                Variable v = new Variable("CurrentItem", ft);
                this.buildObjectFields(v);
                variables.add(v);
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }

    public void buildObjectFields(ObjectDefinition def) {
        if (def.getType().isArray()) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().isObject()) {
            List bos = ((IApplicationProject)this.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < bos.size()) {
                IBusinessObject ibo = (IBusinessObject)bos.get(i);
                if (ibo.getName().equals(def.getType().getTypeName())) {
                    List fields = ibo.getFields();
                    int f = 0;
                    while (f < fields.size()) {
                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                        this.buildObjectFields(def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)));
                        ++f;
                    }
                }
                ++i;
            }
        } else if (def.getType().equals("String")) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }

    public boolean isObject(String typeName) {
        return !typeName.equals("String") && !typeName.equals("Number") && !typeName.equals("Decimal") && !typeName.equals("Boolean") && !typeName.equals("DateTime");
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }

    private void firePathRemoval(ConnectorRecord record) {
        int i = 0;
        while (i < this.listeners.size()) {
            ConnectorOriginPathListener l = (ConnectorOriginPathListener)this.listeners.get(i);
            l.pathRemoved(this, record);
            ++i;
        }
    }

    public boolean isAllowUserNav() {
        return this.allowUserNav;
    }

    public void setAllowUserNav(boolean allowUserNav) {
        this.allowUserNav = allowUserNav;
        if (!allowUserNav) {
            this.firePathRemoval(this.mainMenu);
            this.firePathRemoval(this.optOut);
        }
    }

    public boolean isSupportMainMenu() {
        return this.supportMainMenu;
    }

    public void setSupportMainMenu(boolean supportMainMenu) {
        this.supportMainMenu = supportMainMenu;
        if (!supportMainMenu) {
            this.firePathRemoval(this.mainMenu);
        }
    }

    public boolean isSupportOptOut() {
        return this.supportOptOut;
    }

    public void setSupportOptOut(boolean supportOptOut) {
        this.supportOptOut = supportOptOut;
        if (!supportOptOut) {
            this.firePathRemoval(this.optOut);
        }
    }
}

