/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.desktop.core.project.IBrand;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScript;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptCustomObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptDynamicMenuObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptFieldObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptMenuObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptMessageObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptObject;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.GridCellManager;
import org.eclipse.vtp.desktop.ui.app.editors.UICustomBindingIndex;
import org.eclipse.vtp.desktop.ui.app.editors.UIDefaultBindingIndex;
import org.eclipse.vtp.desktop.ui.app.widgets.DialogWidget;
import org.eclipse.vtp.framework.media.binding.MediaBinding;
import org.eclipse.vtp.framework.media.util.BindingAggragate;
import org.eclipse.vtp.framework.media.util.BindingIndex;
import org.eclipse.vtp.framework.media.util.DefaultBindingIndex;
import org.eclipse.vtp.framework.media.xml.MediaXML;

public class MediaLibraryPropertiesPanel
extends ComponentPropertiesPanel {
    private TableViewer brands = null;
    private Map sessionsByBrandNames = new HashMap();
    private Map indexesByBrandNames = new HashMap();
    private ApplicationModel model;
    private Element element;
    private BindingAggragate bindingAggragate;
    private Map dialogByBrandMap = new HashMap();

    public MediaLibraryPropertiesPanel(Element fe) {
        super("Media & Settings");
        this.element = fe;
    }

    public void setSessionsByBrandNames(Map sessions) {
        this.sessionsByBrandNames.clear();
        this.sessionsByBrandNames.putAll(sessions);
        this.indexesByBrandNames.clear();
        try {
            MediaBinding defBinding = (MediaBinding)this.sessionsByBrandNames.get("Default");
            UIDefaultBindingIndex defIndex = new UIDefaultBindingIndex(this.model.getProject().getBrandSet().getBrand("Default"), defBinding);
            this.indexesByBrandNames.put("Default", defIndex);
            Iterator i = this.model.getProject().getBrandSet().getBrands().iterator();
            while (i.hasNext()) {
                IBrand brand = (IBrand)i.next();
                if ("Default".equals(brand.getName()) || !this.sessionsByBrandNames.containsKey(brand.getName())) continue;
                this.indexesByBrandNames.put(brand.getName(), new UICustomBindingIndex(defIndex, this.model.getProject().getBrandSet().getBrand(brand.getName()), (MediaBinding)this.sessionsByBrandNames.get(brand.getName())));
            }
            this.bindingAggragate = new BindingAggragate((DefaultBindingIndex)defIndex, this.indexesByBrandNames);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setModel(ApplicationModel model) {
        this.model = model;
    }

    public void setMediaProvider(MediaProvider mediaProvider) {
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        comp.setLayout((Layout)gl);
        comp.setBackground(parent.getBackground());
        SashForm sash = new SashForm(comp, 256);
        sash.setBackground(parent.getBackground());
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 400;
        sash.setLayoutData((Object)gd);
        Group brandGroup = new Group((Composite)sash, 0);
        brandGroup.setBackground(sash.getBackground());
        brandGroup.setText("Brands");
        brandGroup.setLayout((Layout)new GridLayout(1, false));
        ToolBar brandTools = new ToolBar((Composite)brandGroup, 0x800100);
        brandTools.setBackground(brandGroup.getBackground());
        brandTools.setLayoutData((Object)new GridData(768));
        ToolItem newBrandItem = new ToolItem(brandTools, 8);
        newBrandItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"));
        newBrandItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog in = new InputDialog(MediaLibraryPropertiesPanel.this.getRootShell(), "New Brand", "Enter the name for the new brand:", "", new IInputValidator(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String isValid(String newText) {
                        if (newText == null || newText.length() == 0) {
                            return "Enter a name for this brand";
                        }
                        if (MediaLibraryPropertiesPanel.access$1(1.access$0(this.this$1)).containsKey(newText)) {
                            return "The name '" + newText + "' is not available";
                        }
                        return null;
                    }
                });
                if (in.open() != 0) {
                    return;
                }
                MediaLibraryPropertiesPanel.this.brands.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            static /* synthetic */ MediaLibraryPropertiesPanel access$0(1 var0) {
                return var0.MediaLibraryPropertiesPanel.this;
            }
        });
        ToolItem removeBrandItem = new ToolItem(brandTools, 8);
        removeBrandItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        removeBrandItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection iss = (IStructuredSelection)MediaLibraryPropertiesPanel.this.brands.getSelection();
                if (iss.size() == 0) {
                    return;
                }
                MessageDialog.openConfirm((Shell)MediaLibraryPropertiesPanel.this.getRootShell(), (String)"Delete Brand", (String)("Are you sure you want to remove the brand '" + iss.getFirstElement() + "'?"));
                MediaLibraryPropertiesPanel.this.brands.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.brands = new TableViewer((Composite)brandGroup, 2820);
        this.brands.getTable().setLayoutData((Object)new GridData(1808));
        BrandsContentProvider bcp = new BrandsContentProvider();
        this.brands.setContentProvider((IContentProvider)bcp);
        this.brands.setLabelProvider((IBaseLabelProvider)bcp);
        this.brands.setSorter(new ViewerSorter(){

            public int category(Object element) {
                return "Default".equals(element) ? 1 : 2;
            }
        });
        this.brands.setInput((Object)this.model);
        final DialogWidget sc = new DialogWidget((Composite)sash, 512, this.element);
        gd = new GridData(1808);
        gd.widthHint = 300;
        sc.setLayoutData(gd);
        sc.setAlwaysShowScrollBars(true);
        sc.getVerticalBar().setIncrement(10);
        sc.getVerticalBar().setPageIncrement(15);
        sc.setModel(this.model);
        this.brands.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                sc.setDialogData((String)((IStructuredSelection)event.getSelection()).getFirstElement(), (Map)MediaLibraryPropertiesPanel.this.dialogByBrandMap.get(((IStructuredSelection)event.getSelection()).getFirstElement()), (BindingIndex)MediaLibraryPropertiesPanel.this.indexesByBrandNames.get(((IStructuredSelection)event.getSelection()).getFirstElement()));
            }
        });
        MediaProvider mp = this.element.getMediaProvider();
        MediaScript ms = mp.getScript();
        List dialogs = ms.getDialogs();
        int d = 0;
        while (d < dialogs.size()) {
            MediaScriptObject mso = (MediaScriptObject)dialogs.get(d);
            Map graphByDialog = new HashMap();
            if (mso instanceof MediaScriptFieldObject) {
                sc.addFieldDialog((MediaScriptFieldObject)mso);
                graphByDialog = this.bindingAggragate.getFieldDialogAggregates(mp.getProviderType(), mp.getId(), mso.getName());
            } else if (mso instanceof MediaScriptMessageObject) {
                sc.addMessageDialog((MediaScriptMessageObject)mso);
                graphByDialog = this.bindingAggragate.getMessageDialogAggregates(mp.getProviderType(), mp.getId(), mso.getName());
            } else if (mso instanceof MediaScriptDynamicMenuObject) {
                sc.addDynamicMenuDialog((MediaScriptDynamicMenuObject)mso);
                graphByDialog = this.bindingAggragate.getDynamicMenuDialogAggregates(mp.getProviderType(), mp.getId(), mso.getName());
            } else if (mso instanceof MediaScriptMenuObject) {
                sc.addMenuDialog((MediaScriptMenuObject)mso);
                graphByDialog = this.bindingAggragate.getMenuDialogAggregates(mp.getProviderType(), mp.getId(), mso.getName());
            } else if (mso instanceof MediaScriptCustomObject) {
                MediaScriptCustomObject msco = (MediaScriptCustomObject)mso;
                if (msco.getBaseType().equals("message")) {
                    sc.addCustomMessageDialog(msco);
                    graphByDialog = this.bindingAggragate.getMessageDialogAggregates(mp.getProviderType(), mp.getId(), mso.getName());
                } else if (msco.getBaseType().equals("field")) {
                    sc.addCustomFieldDialog(msco);
                    graphByDialog = this.bindingAggragate.getFieldDialogAggregates(mp.getProviderType(), mp.getId(), mso.getName());
                } else if (msco.getBaseType().equals("menu")) {
                    sc.addCustomMenuDialog(msco);
                    graphByDialog = this.bindingAggragate.getMenuDialogAggregates(mp.getProviderType(), mp.getId(), mso.getName());
                }
            }
            Set entrySet = graphByDialog.entrySet();
            Iterator it = entrySet.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                HashMap diagMap = (HashMap)this.dialogByBrandMap.get(entry.getKey());
                if (diagMap == null) {
                    diagMap = new HashMap();
                    this.dialogByBrandMap.put(entry.getKey(), diagMap);
                }
                diagMap.put(mso.getName(), entry.getValue());
            }
            ++d;
        }
        this.brands.setSelection((ISelection)new StructuredSelection((Object)"Default"));
        sash.setWeights(new int[]{30, 80});
    }

    public void save() {
        try {
            Iterator i = this.model.getProject().getBrandSet().getBrands().iterator();
            while (i.hasNext()) {
                IBrand brand = (IBrand)i.next();
                String name = brand.getName();
                MediaBinding mediaBinding = (MediaBinding)this.sessionsByBrandNames.get(name);
                if (mediaBinding == null) continue;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    MediaXML.saveBinding((MediaBinding)mediaBinding, (Result)new StreamResult(output));
                    brand.getBinding().write((InputStream)new ByteArrayInputStream(output.toByteArray()), null);
                }
                catch (IOException e) {
                    this.showMessage("ERROR", "Failed to save media properties for '" + name + "': " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (CoreException e) {
            this.showMessage("ERROR", "Failed to save media properties: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.brands.getControl().getShell(), (String)title, (String)message);
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 50;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    static /* synthetic */ Map access$1(MediaLibraryPropertiesPanel mediaLibraryPropertiesPanel) {
        return mediaLibraryPropertiesPanel.sessionsByBrandNames;
    }

    public static interface HeaderExpansionListener {
        public void headerExpansionChanged(HeaderComposite var1);
    }

    private final class BrandsContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private BrandsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return MediaLibraryPropertiesPanel.this.indexesByBrandNames.keySet().toArray();
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class HeaderComposite
    extends Composite
    implements PaintListener,
    MouseListener {
        String title;
        Color topGradient;
        Color bottomGradient;
        GridCellManager cellManager;
        String groupName;
        boolean expanded;
        List listeners;

        public HeaderComposite(Composite parent, int style, String title) {
            super(parent, style);
            this.title = "";
            this.topGradient = null;
            this.bottomGradient = null;
            this.cellManager = null;
            this.groupName = "";
            this.expanded = true;
            this.listeners = new ArrayList();
            this.title = title;
            this.addPaintListener(this);
            this.addMouseListener(this);
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
            if (this.cellManager != null) {
                if (expanded) {
                    this.cellManager.showGroup(this.groupName);
                } else {
                    this.cellManager.hideGroup(this.groupName);
                }
            }
            this.fireExpansionChanged();
        }

        public void addExpansionListener(HeaderExpansionListener l) {
            this.listeners.remove(l);
            this.listeners.add(l);
        }

        public void removeExpansionListener(HeaderExpansionListener l) {
            this.listeners.remove(l);
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public void setCellManager(GridCellManager manager) {
            this.cellManager = manager;
        }

        public void setTopGradient(Color tg) {
            this.topGradient = tg;
        }

        public void setBottomGradient(Color bg) {
            this.bottomGradient = bg;
        }

        public void paintControl(PaintEvent e) {
            if (this.topGradient == null) {
                this.topGradient = e.gc.getBackground();
            }
            if (this.bottomGradient == null) {
                this.bottomGradient = e.gc.getBackground();
            }
            Color fg = e.gc.getForeground();
            Color bg = e.gc.getBackground();
            e.gc.setForeground(this.topGradient);
            e.gc.setBackground(this.bottomGradient);
            Point size = this.getSize();
            e.gc.fillGradientRectangle(0, 0, size.x, size.y, true);
            e.gc.setForeground(fg);
            e.gc.setBackground(bg);
            Point titleSize = e.gc.stringExtent(this.title);
            e.gc.drawString(this.title, 15, (size.y - titleSize.y) / 2, true);
        }

        void fireExpansionChanged() {
            int i = 0;
            while (i < this.listeners.size()) {
                ((HeaderExpansionListener)this.listeners.get(i)).headerExpansionChanged(this);
                ++i;
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (this.cellManager != null) {
                if (this.expanded) {
                    this.cellManager.hideGroup(this.groupName);
                } else {
                    this.cellManager.showGroup(this.groupName);
                }
                this.expanded = !this.expanded;
            }
            this.fireExpansionChanged();
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

