/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuChoice;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuElementPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;

public class MenuElement
extends Element
implements ConnectorDestination,
ConnectorOrigin {
    List incomingConnectors;
    List exitPoints;
    boolean barginEnabled;
    List menuChoices;
    private List listeners = new ArrayList();
    boolean retriesSeparate = false;
    int noInputLimit = 2;
    int noMatchLimit = 2;
    int badInputLimit = 2;

    public MenuElement(String name) {
        super(name);
        this.incomingConnectors = new ArrayList();
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "error.input.nomatch", ConnectorRecord.ERROR_POINT));
        this.exitPoints.add(new ConnectorRecord(this, "error.input.noinput", ConnectorRecord.ERROR_POINT));
        this.menuChoices = new ArrayList();
    }

    public MenuElement(String id, String name) {
        super(id, name);
        this.incomingConnectors = new ArrayList();
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "error.input.nomatch", ConnectorRecord.ERROR_POINT));
        this.exitPoints.add(new ConnectorRecord(this, "error.input.noinput", ConnectorRecord.ERROR_POINT));
        this.menuChoices = new ArrayList();
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public boolean isBarginEnabled() {
        return this.barginEnabled;
    }

    public void setBarginEnabled(boolean barginEnabled) {
        this.barginEnabled = barginEnabled;
    }

    public ConnectorRecord getRecord(String name) {
        int i = 0;
        while (i < this.exitPoints.size()) {
            if (((ConnectorRecord)this.exitPoints.get(i)).getName().equals(name)) {
                return (ConnectorRecord)this.exitPoints.get(i);
            }
            ++i;
        }
        return null;
    }

    public List getHooks() {
        return this.getFreeHooks();
    }

    public List getFreeHooks() {
        return Collections.unmodifiableList(new ArrayList());
    }

    public List getExits() {
        ArrayList<ConnectorRecord> exits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            exits.add(cr);
        }
        return Collections.unmodifiableList(exits);
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            if (cr.getConnector() != null) continue;
            freeExits.add(cr);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isExitedFrom = false;
        boolean isErrorFrom = false;
        boolean hasErrorFrom = false;
        int i = 0;
        while (i < this.exitPoints.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.exitPoints.get(i);
            if (cr.getType() == ConnectorRecord.ERROR_POINT) {
                hasErrorFrom = true;
            }
            if (cr.getConnector() != null) {
                if (cr.getType() == ConnectorRecord.EXIT_POINT) {
                    isExitedFrom = true;
                } else {
                    isErrorFrom = true;
                }
            }
            ++i;
        }
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null)) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isExitedFrom) {
            this.setWarning(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<MenuElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public String getTagName() {
        return "menu";
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("barge-in", this.barginEnabled ? "true" : "false");
        element.setAttribute("retry-strategy", this.retriesSeparate ? "separate" : "combined");
        element.setAttribute("no-input-limit", Integer.toString(this.noInputLimit));
        element.setAttribute("no-match-limit", Integer.toString(this.noMatchLimit));
        element.setAttribute("bad-input-limit", Integer.toString(this.badInputLimit));
        org.w3c.dom.Element choicesElement = element.getOwnerDocument().createElement("choices");
        element.appendChild(choicesElement);
        int i = 0;
        while (i < this.menuChoices.size()) {
            MenuChoice mc = (MenuChoice)this.menuChoices.get(i);
            org.w3c.dom.Element choiceElement = element.getOwnerDocument().createElement("choice");
            choiceElement.setAttribute("name", mc.getOptionName());
            choiceElement.setAttribute("dtmf", mc.getDtmf());
            choiceElement.setAttribute("silent", mc.isSilent() ? "true" : "false");
            choicesElement.appendChild(choiceElement);
            ++i;
        }
    }

    public void readSettings(org.w3c.dom.Element element) {
        if (!element.getAttribute("retry-strategy").equals("")) {
            this.retriesSeparate = element.getAttribute("retry-strategy").equals("separate");
        }
        if (!element.getAttribute("no-input-limit").equals("")) {
            try {
                this.noInputLimit = Integer.parseInt(element.getAttribute("no-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("no-match-limit").equals("")) {
            try {
                this.noMatchLimit = Integer.parseInt(element.getAttribute("no-match-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("bad-input-limit").equals("")) {
            try {
                this.badInputLimit = Integer.parseInt(element.getAttribute("bad-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new MenuElementPropertiesPanel(this));
        return ret;
    }

    public MediaProvider getMediaProvider() {
        return new MenuMediaProvider(this);
    }

    public void addChoice(MenuChoice choice) {
        this.menuChoices.add(choice);
        this.exitPoints.add(new ConnectorRecord(this, choice.getOptionName(), ConnectorRecord.EXIT_POINT));
    }

    public void moveChoiceUp(MenuChoice choice) {
        int index = this.menuChoices.indexOf(choice);
        if (index > 0) {
            this.menuChoices.remove(index);
            this.menuChoices.add(index - 1, choice);
        }
    }

    public void moveChoiceDown(MenuChoice choice) {
        int index = this.menuChoices.indexOf(choice);
        if (index < this.menuChoices.size() - 1) {
            this.menuChoices.remove(index);
            this.menuChoices.add(index + 1, choice);
        }
    }

    public void removeChoice(MenuChoice choice) {
        this.menuChoices.remove(choice);
        int i = 0;
        while (i < this.exitPoints.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.exitPoints.get(i);
            if (cr.getName().equals(choice.getOptionName())) {
                if (cr.getConnector() != null) {
                    this.getModel().deleteConnector(cr.getConnector());
                }
                this.exitPoints.remove(cr);
                break;
            }
            ++i;
        }
    }

    public void updateChoice(MenuChoice choice, String oldName) {
        int i = 0;
        while (i < this.exitPoints.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.exitPoints.get(i);
            if (cr.getName().equals(oldName)) {
                cr.setName(choice.getOptionName());
                break;
            }
            ++i;
        }
    }

    public List getChoices() {
        return Collections.unmodifiableList(this.menuChoices);
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }
}

